/*
 * Decompiled with CFR 0.152.
 */
package sisc.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessControlException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.WeakHashMap;
import sisc.compiler.Syntax;
import sisc.data.Box;
import sisc.data.EOFObject;
import sisc.data.EmptyList;
import sisc.data.Expression;
import sisc.data.ExpressionValue;
import sisc.data.ImmutablePair;
import sisc.data.ImmutableVector;
import sisc.data.NamedValue;
import sisc.data.Pair;
import sisc.data.Procedure;
import sisc.data.Quantity;
import sisc.data.SchemeBinaryInputPort;
import sisc.data.SchemeBinaryOutputPort;
import sisc.data.SchemeBoolean;
import sisc.data.SchemeCharacter;
import sisc.data.SchemeCharacterInputPort;
import sisc.data.SchemeCharacterOutputPort;
import sisc.data.SchemeString;
import sisc.data.SchemeVector;
import sisc.data.SchemeVoid;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.data.Values;
import sisc.env.SymbolicEnvironment;
import sisc.exprs.AnnotatedExpr;
import sisc.exprs.AppEval;
import sisc.interpreter.CallFrame;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.io.Charset;
import sisc.io.InputPort;
import sisc.io.OutputPort;
import sisc.nativefun.NativeLibrary;
import sisc.reader.Lexer;
import sisc.reader.Parser;
import sisc.util.Defaults;
import sisc.util.Version;

public abstract class Util
implements Version {
    public static final boolean caseSensitive = Util.safeGetProperty("sisc.caseSensitive", new Boolean(Defaults.CASE_SENSITIVE).toString()).equals("true");
    public static final boolean permitInterrupts = Util.safeGetProperty("sisc.permitInterrupts", new Boolean(Defaults.PERMIT_INTERRUPTS).toString()).equals("true");
    public static final int minFloatPrecision = Integer.parseInt(Util.safeGetProperty("sisc.minFloatPrecision", Integer.toString(Defaults.MIN_FLOAT_PRECISION)));
    public static final int maxFloatPrecision = Integer.parseInt(Util.safeGetProperty("sisc.maxFloatPrecision", Integer.toString(Defaults.MAX_FLOAT_PRECISION)));
    public static final Value[] ZV = new Value[0];
    public static final Quantity FIVE = Quantity.valueOf(5);
    public static EOFObject EOF = EOFObject.EOF;
    public static Syntax QUOTE = new Syntax(5);
    public static EmptyList EMPTYLIST = EmptyList.EMPTYLIST;
    public static SchemeVoid VOID = SchemeVoid.VOID;
    public static SchemeBoolean TRUE = SchemeBoolean.TRUE;
    public static SchemeBoolean FALSE = SchemeBoolean.FALSE;
    public static SchemeVector EMPTYVEC = new SchemeVector(new Value[0]);
    public static Symbol BEGIN = Symbol.get("begin");
    public static Symbol ERRORK = Symbol.get("error-continuation");
    public static Symbol EXPSC = Symbol.get("*sc-expander*");
    public static Symbol EXPTOP = Symbol.get("*top*");
    public static Symbol FCONT = Symbol.get("failure-continuation");
    public static Symbol JEXCEPTION = Symbol.get("java-exception");
    public static Symbol LAMBDA = Symbol.get("lambda");
    public static Symbol LOCATION = Symbol.get("location");
    public static Symbol MESSAGE = Symbol.get("message");
    public static Symbol NAME = Symbol.get("name");
    public static Symbol OTHER = Symbol.get("other");
    public static Symbol PARENT = Symbol.get("parent");
    public static Symbol QUOTESYM = Symbol.get("quote");
    public static Symbol REPORT = Symbol.get("*report*");
    public static Symbol SETBANG = Symbol.get("set!");
    public static Symbol SISC = Symbol.get("*sisc*");
    public static Symbol SISC_SPECIFIC = Symbol.get("*sisc-specific*");
    public static Symbol SYMENV = Symbol.get("*symenv*");
    public static Symbol THIS = Symbol.get("this");
    public static Symbol TOPLEVEL = Symbol.get("*toplevel*");
    public static Symbol BACKQUOTE = Symbol.get("quasiquote");
    public static Symbol UNQUOTE = Symbol.get("unquote");
    public static Symbol UNQUOTE_SPLICING = Symbol.get("unquote-splicing");
    public static Symbol SOURCE_LINE = Symbol.get("line-number");
    public static Symbol SOURCE_COLUMN = Symbol.get("column-number");
    public static Symbol SOURCE_FILE = Symbol.get("source-file");
    public static Symbol EVAL = Symbol.get("eval");
    static Class JOBJ = null;
    static Class[] OBJARRY = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = Util.class$("java.lang.Object")) : class$java$lang$Object};
    static Constructor JOBJCONST = null;
    public static Symbol SISCB;
    public static WeakHashMap bundles;
    static Locale myLocale;
    static MessageFormat formatter;
    private static Charset defaultCharset;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$sisc$util$Util;

    static String safeGetProperty(String string, String string2) {
        try {
            return System.getProperty(string, string2);
        }
        catch (AccessControlException accessControlException) {
            return string2;
        }
    }

    public static String warn(String string) {
        StringBuffer stringBuffer = new StringBuffer("{");
        stringBuffer.append(Util.liMessage(SISCB, "warning"));
        stringBuffer.append(": ");
        stringBuffer.append(Util.liMessage(SISCB, string));
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static String warn(String string, String string2, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer("{");
        stringBuffer.append(Util.liMessage(SISCB, "warning"));
        stringBuffer.append(": ");
        stringBuffer.append(Util.liMessage(SISCB, string));
        stringBuffer.append("\n ");
        stringBuffer.append(string2).append(':').append(n);
        stringBuffer.append(':').append(n2).append(": }");
        return stringBuffer.toString();
    }

    public static String warn(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer("{");
        stringBuffer.append(Util.liMessage(SISCB, "warning"));
        stringBuffer.append(": ");
        stringBuffer.append(Util.liMessage(SISCB, string, string2));
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static Value javaWrap(Object object) {
        if (JOBJ != null) {
            try {
                return (Value)JOBJCONST.newInstance(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return FALSE;
    }

    public static void error(Interpreter interpreter, Value value, String string, Pair pair) throws ContinuationException {
        Util.error(interpreter, Util.append(pair, Util.list(new Pair(MESSAGE, new SchemeString(string)), new Pair(LOCATION, value))));
    }

    public static void error(Interpreter interpreter, Value value, String string, Exception exception) throws ContinuationException {
        Util.error(interpreter, Util.list(new Pair(MESSAGE, new SchemeString(string)), new Pair(LOCATION, value), new Pair(JEXCEPTION, Util.javaWrap(exception))));
    }

    public static void error(Interpreter interpreter, Value value, String string) throws ContinuationException {
        Util.error(interpreter, Util.list(new Pair(MESSAGE, new SchemeString(string)), new Pair(LOCATION, value)));
    }

    public static void error(Interpreter interpreter, String string, Pair pair) throws ContinuationException {
        Util.error(interpreter, new Pair(new Pair(MESSAGE, new SchemeString(string)), pair));
    }

    public static void error(Interpreter interpreter, String string) throws ContinuationException {
        Util.error(interpreter, Util.list(new Pair(MESSAGE, new SchemeString(string))));
    }

    public static void error(Interpreter interpreter, Value value) throws ContinuationException {
        Util.error(interpreter, Util.list(new Pair(MESSAGE, value)));
    }

    public static String simpleErrorToString(Pair pair) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        String string2 = null;
        Pair pair2 = null;
        while (pair != EMPTYLIST && (string == null || string2 == null)) {
            Pair pair3 = (Pair)pair.car();
            if (pair3.car().equals(MESSAGE)) {
                string2 = pair3.cdr().toString();
            } else if (pair3.car().equals(LOCATION)) {
                string = pair3.cdr().toString();
            } else if (pair3.car().equals(PARENT)) {
                pair2 = (Pair)pair3.cdr();
            }
            pair = (Pair)pair.cdr();
        }
        if (string == null) {
            stringBuffer.append(Util.liMessage(SISCB, "error"));
        } else {
            stringBuffer.append(Util.liMessage(SISCB, "errorinwhere", string));
        }
        if (string2 != null) {
            stringBuffer.append(": ").append(string2);
        } else {
            stringBuffer.append('.');
        }
        if (pair2 != null) {
            stringBuffer.append("\n  ").append(Util.simpleErrorToString(pair2));
        }
        return stringBuffer.toString();
    }

    public static ClassLoader currentClassLoader() {
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        if (classLoader == null) {
            try {
                classLoader = (class$sisc$util$Util == null ? (class$sisc$util$Util = Util.class$("sisc.util.Util")) : class$sisc$util$Util).getClassLoader();
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
        if (classLoader == null) {
            try {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
        if (classLoader == null) {
            throw new RuntimeException(Util.liMessage(SISCB, "notclassloader"));
        }
        return classLoader;
    }

    public static Value read(String string) throws IOException {
        PushbackReader pushbackReader = new PushbackReader(new StringReader(string));
        Parser parser = new Parser(new Lexer());
        Value value = parser.nextExpression(pushbackReader);
        try {
            Value value2 = parser.nextExpression(pushbackReader);
        }
        catch (EOFException eOFException) {
            return value;
        }
        throw new IOException(Util.liMessage(SISCB, "stringreaderror", string));
    }

    public static void error(Interpreter interpreter, Pair pair) throws ContinuationException {
        interpreter.error(pair);
    }

    public static String justify(String string, int n, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        while (stringBuffer.length() < n - string.length()) {
            stringBuffer.append(c);
        }
        return stringBuffer.append(string).toString();
    }

    public static final void argCheck(Pair pair, int n) throws Exception {
        int n2 = Util.length(pair);
        if (n2 != n && n != -1) {
            throw new RuntimeException(Util.liMessage(SISCB, "notenoughargs", new Object[]{new Integer(n), new Integer(n2)}));
        }
    }

    public static void updateName(Value value, Symbol symbol) {
        NamedValue namedValue;
        if (value instanceof NamedValue && (namedValue = (NamedValue)((Object)value)).getName() == null) {
            namedValue.setName(symbol);
        }
    }

    public static int length(Pair pair) {
        Pair pair2 = pair;
        try {
            int n = 0;
            while (pair != EMPTYLIST) {
                pair = (Pair)pair.cdr();
                ++n;
            }
            return n;
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException(Util.liMessage(SISCB, "notaproperlist", pair2.synopsis()));
        }
    }

    public static Vector pairToExpVect(Pair pair) {
        Vector<Value> vector = new Vector<Value>();
        while (pair != EMPTYLIST) {
            vector.addElement(pair.car());
            pair = (Pair)pair.cdr();
        }
        return vector;
    }

    public static Expression[] pairToExpressions(Pair pair) {
        int n = Util.length(pair);
        Expression[] expressionArray = new Expression[n];
        for (int i = 0; i < n; ++i) {
            expressionArray[i] = pair.car();
            pair = (Pair)pair.cdr();
        }
        return expressionArray;
    }

    public static Value[] pairToValues(Pair pair) {
        int n = Util.length(pair);
        if (n == 0) {
            return ZV;
        }
        Value[] valueArray = new Value[n];
        for (int i = 0; i < n; ++i) {
            valueArray[i] = pair.car();
            pair = (Pair)pair.cdr();
        }
        return valueArray;
    }

    public static Symbol[] argsToSymbols(Pair pair) {
        Symbol[] symbolArray;
        if (pair == EMPTYLIST) {
            return new Symbol[0];
        }
        int n = 1;
        Value value = pair.cdr();
        while (value instanceof Pair && value != EMPTYLIST) {
            ++n;
            value = ((Pair)value).cdr();
        }
        if (value == EMPTYLIST) {
            symbolArray = new Symbol[n];
        } else {
            symbolArray = new Symbol[n + 1];
            symbolArray[n] = (Symbol)value;
        }
        int n2 = 0;
        while (true) {
            symbolArray[n2++] = (Symbol)pair.car();
            if (n2 == n) break;
            pair = (Pair)pair.cdr();
        }
        return symbolArray;
    }

    public static void typeError(String string, Value value) {
        Util.typeError(SISCB, string, value);
    }

    public static void typeError(Symbol symbol, String string, Value value) {
        if (value instanceof Values) {
            throw new RuntimeException(Util.liMessage(SISCB, "multiplevalues"));
        }
        throw new RuntimeException(Util.liMessage(SISCB, "unexpectedarg", Util.liMessage(symbol, string), value.synopsis()));
    }

    public static final Symbol sym(String string) {
        return Symbol.get(string);
    }

    public static final String symval(Value value) {
        if (value instanceof Symbol) {
            return ((Symbol)value).symval;
        }
        Util.typeError("symbol", value);
        return null;
    }

    public static final Quantity num(Value value) {
        if (value instanceof Quantity) {
            return (Quantity)value;
        }
        Util.typeError("number", value);
        return null;
    }

    public static final Pair pair(Value value) {
        if (value instanceof Pair) {
            return (Pair)value;
        }
        Util.typeError("pair", value);
        return null;
    }

    public static final Procedure proc(Value value) {
        if (value instanceof Procedure) {
            return (Procedure)value;
        }
        Util.typeError("procedure", value);
        return null;
    }

    public static final Pair truePair(Value value) {
        if (value == EMPTYLIST) {
            Util.typeError("pair", value);
        }
        return Util.pair(value);
    }

    public static final char character(Value value) {
        return Util.chr((Value)value).c;
    }

    public static final SchemeCharacter chr(Value value) {
        if (value instanceof SchemeCharacter) {
            return (SchemeCharacter)value;
        }
        Util.typeError("character", value);
        return null;
    }

    public static final String string(Value value) {
        return Util.str(value).asString();
    }

    public static final SchemeString str(Value value) {
        if (value instanceof SchemeString) {
            return (SchemeString)value;
        }
        Util.typeError("string", value);
        return null;
    }

    public static final Symbol symbol(Value value) {
        if (value instanceof Symbol) {
            return (Symbol)value;
        }
        Util.typeError("symbol", value);
        return null;
    }

    public static final SchemeVector vec(Value value) {
        if (value instanceof SchemeVector) {
            return (SchemeVector)value;
        }
        Util.typeError("vector", value);
        return null;
    }

    public static final OutputPort outport(Value value) {
        if (value instanceof OutputPort) {
            return (OutputPort)((Object)value);
        }
        Util.typeError("output-port", value);
        return null;
    }

    public static final SchemeBinaryOutputPort binoutport(Value value) {
        if (value instanceof SchemeBinaryOutputPort) {
            return (SchemeBinaryOutputPort)value;
        }
        Util.typeError("binary-output-port", value);
        return null;
    }

    public static final OutputStream binoutstream(Value value) {
        return Util.binoutport(value).getOutputStream();
    }

    public static final SchemeCharacterOutputPort charoutport(Value value) {
        if (value instanceof SchemeCharacterOutputPort) {
            return (SchemeCharacterOutputPort)value;
        }
        Util.typeError("character-output-port", value);
        return null;
    }

    public static final Writer charoutwriter(Value value) {
        return Util.charoutport(value).getWriter();
    }

    public static final InputPort inport(Value value) {
        if (value instanceof InputPort) {
            return (InputPort)((Object)value);
        }
        Util.typeError("input-port", value);
        return null;
    }

    public static final SchemeBinaryInputPort bininport(Value value) {
        if (value instanceof SchemeBinaryInputPort) {
            return (SchemeBinaryInputPort)value;
        }
        Util.typeError("binary-input-port", value);
        return null;
    }

    public static final InputStream bininstream(Value value) {
        return Util.bininport(value).getInputStream();
    }

    public static final SchemeCharacterInputPort charinport(Value value) {
        if (value instanceof SchemeCharacterInputPort) {
            return (SchemeCharacterInputPort)value;
        }
        Util.typeError("character-input-port", value);
        return null;
    }

    public static final Reader charinreader(Value value) {
        return Util.charinport(value).getReader();
    }

    public static final SymbolicEnvironment env(Value value) {
        if (value instanceof SymbolicEnvironment) {
            return (SymbolicEnvironment)((Object)value);
        }
        Util.typeError("environment", value);
        return null;
    }

    public static final Box box(Value value) {
        if (value instanceof Box) {
            return (Box)value;
        }
        Util.typeError("box", value);
        return null;
    }

    public static final CallFrame cont(Value value) {
        if (value instanceof CallFrame) {
            return (CallFrame)value;
        }
        Util.typeError("continuation", value);
        return null;
    }

    public static final Expression expr(Value value) {
        if (value instanceof ExpressionValue) {
            return ((ExpressionValue)value).e;
        }
        Util.typeError("expression", value);
        return null;
    }

    public static final AnnotatedExpr annotated(Value value) {
        if (value instanceof AnnotatedExpr) {
            return (AnnotatedExpr)value;
        }
        Util.typeError("annotatedexpression", value);
        return null;
    }

    public static URL makeURL(String string) {
        URL uRL = null;
        if (string == null) {
            return uRL;
        }
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                uRL = new URL("file", null, string);
            }
            catch (MalformedURLException malformedURLException2) {
                // empty catch block
            }
        }
        return uRL;
    }

    public static URL url(Value value) {
        try {
            return Util.url(Util.string(value));
        }
        catch (MalformedURLException malformedURLException) {
            Util.typeError("url", value);
            return null;
        }
    }

    public static URL url(String string) throws MalformedURLException {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return new URL("file", null, string);
        }
    }

    public static URL url(Value value, Value value2) {
        URL uRL = Util.url(value);
        String string = Util.string(value2);
        try {
            return new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                return new URL(uRL, "file:" + string);
            }
            catch (MalformedURLException malformedURLException2) {
                Util.typeError("url", value2);
                return null;
            }
        }
    }

    public static final NativeLibrary nlib(Value value) {
        if (value instanceof NativeLibrary) {
            return (NativeLibrary)value;
        }
        Util.typeError("nativelibrary", value);
        return null;
    }

    public static final ImmutablePair immutablePair(Value value) {
        if (value instanceof ImmutablePair) {
            return (ImmutablePair)value;
        }
        Util.typeError("immutable-pair", value);
        return null;
    }

    public static final ImmutableVector immutableVector(Value value) {
        if (value instanceof ImmutableVector) {
            return (ImmutableVector)value;
        }
        Util.typeError("immutable-vector", value);
        return null;
    }

    public static final SchemeBoolean truth(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static final boolean truth(Value value) {
        return value != FALSE;
    }

    public static Value assq(Value value, Pair pair) {
        while (pair != EMPTYLIST) {
            Pair pair2 = Util.pair(pair.car());
            if (pair2.car() == value) {
                return pair2;
            }
            pair = Util.pair(pair.cdr());
        }
        return FALSE;
    }

    public static Pair mapcar(Pair pair) {
        Pair pair2 = EMPTYLIST;
        while (pair != EMPTYLIST) {
            pair2 = new Pair(Util.truePair(pair.car()).car(), pair2);
            pair = Util.pair(pair.cdr());
        }
        return Util.reverseInPlace(pair2);
    }

    public static Pair reverse(Pair pair) {
        Pair pair2 = EMPTYLIST;
        while (pair != EMPTYLIST) {
            pair2 = new Pair(pair.car(), pair2);
            pair = (Pair)pair.cdr();
        }
        return pair2;
    }

    public static Pair reverseInPlace(Pair pair) {
        if (pair == EMPTYLIST) {
            return EMPTYLIST;
        }
        Pair pair2 = EMPTYLIST;
        while (true) {
            Value value = pair.cdr();
            pair.setCdr(pair2);
            pair2 = pair;
            if (value == EMPTYLIST) break;
            pair = (Pair)value;
        }
        return pair2;
    }

    public static Pair append(Pair pair, Pair pair2) {
        if (pair == EMPTYLIST) {
            return pair2;
        }
        return new Pair(pair.car(), Util.append((Pair)pair.cdr(), pair2));
    }

    public static final Pair list(Value value) {
        return new Pair(value, EMPTYLIST);
    }

    public static final Pair list(Value value, Value value2) {
        return new Pair(value, Util.list(value2));
    }

    public static final Pair list(Value value, Value value2, Value value3) {
        return new Pair(value, Util.list(value2, value3));
    }

    public static final Pair list(Value value, Value value2, Value value3, Value value4) {
        return new Pair(value, Util.list(value2, value3, value4));
    }

    public static final Pair list(Value value, Value value2, Value value3, Value value4, Value value5) {
        return new Pair(value, Util.list(value2, value3, value4, value5));
    }

    public static final Pair valArrayToList(Value[] valueArray, int n, int n2) {
        Pair pair = EMPTYLIST;
        for (int i = n + n2 - 1; i >= n; --i) {
            pair = new Pair(valueArray[i], pair);
        }
        return pair;
    }

    public static final Pair valArrayToList(Value[] valueArray) {
        return valueArray == null ? EMPTYLIST : Util.valArrayToList(valueArray, 0, valueArray.length);
    }

    public static final SchemeVector valArrayToVec(Value[] valueArray) {
        if (valueArray == null) {
            return EMPTYVEC;
        }
        for (int i = 0; i < valueArray.length; ++i) {
            if (valueArray[i] != null) continue;
            valueArray[i] = VOID;
        }
        return new SchemeVector(valueArray);
    }

    public static Value memq(Value value, Pair pair) {
        while (pair != EMPTYLIST) {
            if (pair.car() == value) {
                return pair;
            }
            pair = Util.pair(pair.cdr());
        }
        return FALSE;
    }

    public static void registerBundle(Symbol symbol) throws MissingResourceException {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(symbol.symval);
        bundles.put(symbol, resourceBundle);
    }

    public static String liMessage(Symbol symbol, String string) {
        ResourceBundle resourceBundle = (ResourceBundle)bundles.get(symbol);
        try {
            if (resourceBundle == null) {
                Util.registerBundle(symbol);
                resourceBundle = (ResourceBundle)bundles.get(symbol);
            }
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            if (!symbol.equals(SISCB)) {
                return Util.liMessage(SISCB, string);
            }
            return "<localized message not found: " + string + ">";
        }
    }

    public static String liMessage(Symbol symbol, String string, String string2) {
        return MessageFormat.format(Util.liMessage(symbol, string), string2);
    }

    public static String liMessage(Symbol symbol, String string, String string2, String string3) {
        return MessageFormat.format(Util.liMessage(symbol, string), string2, string3);
    }

    public static String liMessage(Symbol symbol, String string, String string2, String string3, String string4) {
        return MessageFormat.format(Util.liMessage(symbol, string), string2, string3, string4);
    }

    public static String liMessage(Symbol symbol, String string, String string2, String string3, String string4, String string5) {
        return MessageFormat.format(Util.liMessage(symbol, string), string2, string3, string4, string5);
    }

    public static String liMessage(Symbol symbol, String string, String string2, int n, int n2) {
        return MessageFormat.format(Util.liMessage(symbol, string), string2, new Integer(n), new Integer(n2));
    }

    public static String liMessage(Symbol symbol, String string, Object[] objectArray) {
        return MessageFormat.format(Util.liMessage(symbol, string), objectArray);
    }

    protected static String javaExceptionToString(Exception exception) {
        return "<" + exception.getClass().getName() + ">: " + exception.getMessage();
    }

    public static Pair sourceAnnotations(String string, int n, int n2, Pair pair) {
        return new Pair(new Pair(SOURCE_FILE, new SchemeString(string)), new Pair(new Pair(SOURCE_LINE, Quantity.valueOf(n)), new Pair(new Pair(SOURCE_COLUMN, Quantity.valueOf(n2)), pair)));
    }

    public static Expression annotatedAppEval(Class clazz, String string) {
        AppEval appEval = new AppEval();
        appEval.setAnnotation(SOURCE_FILE, new SchemeString(clazz.getName() + "/" + string));
        return appEval;
    }

    public static Charset getDefaultCharacterSet() {
        return defaultCharset;
    }

    public static Charset charsetFromString(String string) {
        Charset charset;
        if (string == null) {
            charset = Util.getDefaultCharacterSet();
        } else {
            try {
                charset = Charset.forName(string);
            }
            catch (Exception exception) {
                System.err.println(Util.warn("unsupencoding", string));
                charset = Util.getDefaultCharacterSet();
            }
        }
        return charset;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            JOBJ = Class.forName("sisc.modules.s2j.JavaObject");
            JOBJCONST = JOBJ.getConstructor(OBJARRY);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SISCB = Symbol.intern("sisc.Messages");
        bundles = new WeakHashMap();
        myLocale = Locale.getDefault();
        formatter = new MessageFormat("");
        formatter.setLocale(myLocale);
        defaultCharset = null;
        try {
            defaultCharset = Charset.forName("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ExceptionInInitializerError(unsupportedEncodingException);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw new ExceptionInInitializerError(unsupportedCharsetException);
        }
    }
}

