/*
 * Decompiled with CFR 0.152.
 */
package sisc.tests;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import junit.framework.TestCase;
import sisc.data.Procedure;
import sisc.data.Value;
import sisc.interpreter.Context;
import sisc.interpreter.Interpreter;
import sisc.interpreter.SchemeException;

public class TestR5RS
extends TestCase {
    private Interpreter interpreter;

    public TestR5RS(String string) {
        super(string);
    }

    protected void setUp() throws ClassNotFoundException {
        this.interpreter = Context.enter();
    }

    protected void tearDown() {
        this.interpreter = null;
        System.gc();
    }

    private Value quote(String string) throws IOException {
        return this.interpreter.dynenv.parser.nextExpression(new PushbackReader(new BufferedReader(new StringReader(string))));
    }

    private Value eval(String string) throws IOException, SchemeException {
        return this.interpreter.eval(this.quote(string));
    }

    private void check(String string, String string2) throws IOException, SchemeException {
        Value value = this.eval(string);
        boolean bl = value.valueEqual(this.quote(string2));
        if (!bl) {
            System.out.println("*** evaluation of ***\n" + string + '\n' + "*** returned ***\n" + value + '\n' + "*** expected was ***\n" + string2 + '\n' + "*** end ***");
        }
        TestR5RS.assertTrue((boolean)bl);
    }

    public void test4_1_1() throws Exception {
        this.eval("(define x 28)");
        this.check("x", "28");
    }

    public void test4_1_2() throws Exception {
        this.check("(quote a)", "a");
        this.check("(quote #(a b c))", "#(a b c)");
        this.check("(quote (+ 1 2))", "(+ 1 2)");
        this.check("'a", "a");
        this.check("'#(a b c)", "#(a b c)");
        this.check("'()", "()");
        this.check("'(+ 1 2)", "(+ 1 2)");
        this.check("'(quote a)", "(quote a)");
        this.check("''a", "(quote a)");
        this.check("'\"abc\"", "\"abc\"");
        this.check("\"abc\"", "\"abc\"");
        this.check("'145932", "145932");
        this.check("145932", "145932");
        this.check("'#t", "#t");
        this.check("#t", "#t");
    }

    public void test4_1_2a() throws Exception {
        try {
            this.eval("(set-car! '(1 . 2) 'a)");
            TestR5RS.fail();
        }
        catch (SchemeException schemeException) {
            // empty catch block
        }
    }

    public void test4_1_2b() throws Exception {
        try {
            this.eval("(string-set! '\"abc\" 0 #\\b)");
            TestR5RS.fail();
        }
        catch (SchemeException schemeException) {
            // empty catch block
        }
    }

    public void test4_1_2c() throws Exception {
        try {
            this.eval("(vector-set! '#(1 2 3) 0 'a)");
            TestR5RS.fail();
        }
        catch (SchemeException schemeException) {
            // empty catch block
        }
    }

    public void test4_1_3a() throws Exception {
        this.check("(+ 3 4)", "7");
        this.check("((if #f + *) 3 4)", "12");
    }

    public void test4_1_3b() throws Exception {
        try {
            this.eval("()");
            TestR5RS.fail();
        }
        catch (SchemeException schemeException) {
            // empty catch block
        }
    }

    public void test4_1_4() throws Exception {
        TestR5RS.assertTrue((boolean)(this.eval("(lambda (x) (+ x x))") instanceof Procedure));
        this.check("((lambda (x) (+ x x)) 4)", "8");
        this.eval("(define reverse-subtract\n  (lambda (x y) (- y x)))");
        this.check("(reverse-subtract 7 10)", "3");
        this.eval("(define add4\n  (let ((x 4))\n    (lambda (y) (+ x y))))");
        this.check("(add4 6)", "10");
    }

    public void test4_1_4a() throws Exception {
        try {
            this.eval("(lambda (x y x) y)");
            TestR5RS.fail();
        }
        catch (SchemeException schemeException) {
            // empty catch block
        }
    }

    public void test4_1_4b() throws Exception {
        this.check("((lambda x x) 3 4 5 6)", "(3 4 5 6)");
        this.check("((lambda (x y . z) z) 3 4 5 6)", "(5 6)");
    }

    public void test4_1_5() throws Exception {
        this.check("(if (> 3 2) 'yes 'no)", "yes");
        this.check("(if (> 2 3) 'yes 'no)", "no");
        this.check("(if (> 3 2)\n    (- 3 2)\n    (+ 3 2))", "1");
    }

    public void test4_1_6() throws Exception {
        this.eval("(define x 2)");
        this.check("(+ x 1)", "3");
        this.eval("(set! x 4)");
        this.check("(+ x 1)", "5");
    }

    public void no_test4_2_1() throws Exception {
        this.check("(cond ((> 3 2) 'greater)\n      ((< 3 2) 'less))", "greater");
        this.check("(cond ((> 3 3) 'greater)\n      ((< 3 3) 'less))\n      (else 'equal))", "equal");
        this.check("(cond ((assv 'b '((a 1) (b 2))) => cadr)\n      (else #f))", "2");
    }

    public void test4_2_2_let() throws Exception {
        this.check("(let ((x 2) (y 3))\n  (* x y))", "6");
        this.check("(let ((x 2) (y 3))\n  (let ((x 7)\n        (z (+ x y)))\n    (* z x)))", "35");
    }

    public void test4_2_2a_let() throws Exception {
        try {
            this.eval("(let ((x 1) (y x)) 0)");
            TestR5RS.fail();
        }
        catch (SchemeException schemeException) {
            // empty catch block
        }
    }

    public void test4_2_2b_let() throws Exception {
        try {
            this.eval("(let ((x y) (y 1)) 0)");
            TestR5RS.fail();
        }
        catch (SchemeException schemeException) {
            // empty catch block
        }
    }

    public void test4_2_2a_letstar() throws Exception {
        this.check("(let ((x 2) (y 3))\n  (let* ((x 7)\n         (z (+ x y)))\n    (* z x)))", "70");
    }

    public void test4_2_2b_letstar() throws Exception {
        this.check("(let* ((a 1) (b (+ a 1)) (c (+ a b)) (d (+ b c)) (e (+ c d)))  (list a b c d e))", "(1 2 3 5 8)");
    }

    public void test4_2_2c_letstar() throws Exception {
        this.check("(let* ((x 1) (y x)) y)", "1");
    }

    public void test4_2_2d_letstar() throws Exception {
        try {
            this.eval("(let* ((x y) (y 1)) 0)");
            TestR5RS.fail();
        }
        catch (SchemeException schemeException) {
            // empty catch block
        }
    }

    public void test4_2_2_letrec() throws Exception {
        this.check("(letrec ((even?\n          (lambda (n)\n            (if (zero? n)\n                #t\n                (odd? (- n 1)))))\n         (odd?\n          (lambda (n)\n            (if (zero? n)\n                #f\n                (even? (- n 1))))))\n  (even? 88))\n", "#t");
        this.check("(letrec ((x (lambda () y)) (y (lambda () x))) 0)", "0");
    }

    public void test4_2_2_common() throws Exception {
        this.check("(let ((x 1)) (let    () (define x 2) x) x)", "1");
        this.check("(let ((x 1)) (let*   () (define x 2) x) x)", "1");
        this.check("(let ((x 1)) (letrec () (define x 2) x) x)", "1");
        this.check("(let ((x 1)) (begin     (define x 2) x) x)", "2");
    }

    public void test4_2_3() throws Exception {
        this.eval("(define x 0)");
        this.check("(begin (set! x 5)\n       (+ x 1))", "6");
    }

    public void test4_2_4_named_let() throws Exception {
        this.check("(let f ((x 3) (y 7))\n  (if (= x 0) y (f (- x 1) y)))", "7");
    }

    public void test4_2_6() throws Exception {
        this.check("`(list ,(+ 1 2) 4)", "(list 3 4)");
        this.check("(let ((name 'a)) `(list ,name ',name))", "(list a (quote a))");
        this.check("`(a ,(+ 1 2) ,@(list 4 5 6) b)", "(a 3 4 5 6 b)");
        this.check("`#(10 5 ,(+ 1 1) ,@(list 4 3) 8)", "#(10 5 2 4 3 8)");
        this.check("`(a `(b ,(+ 1 2) ,(foo ,(+ 1 3) d) e) f)", "(a `(b ,(+ 1 2) ,(foo 4 d) e) f)");
        this.check("(let ((name1 'x) (name2 'y)) `(a `(b ,,name1 ,',name2 d) e))", "(a `(b ,x ,'y d) e))");
    }

    public void test5_2() throws Exception {
        try {
            this.eval("(define x 1 2 3)");
            TestR5RS.fail();
        }
        catch (SchemeException schemeException) {
            // empty catch block
        }
    }

    public void test5_2a() throws Exception {
        try {
            this.eval("(set! x 1 2 3)");
            TestR5RS.fail();
        }
        catch (SchemeException schemeException) {
            // empty catch block
        }
    }

    public void test5_2b() throws Exception {
        this.check("(begin (define (f x) x x x x x) (f 1))", "1");
        try {
            this.check("(let ((a 1))  (define (f x)    (define b (+ a x))    (define a 5)    (+ a b))  (f 10))", "20");
        }
        catch (SchemeException schemeException) {
            // empty catch block
        }
    }

    public void test6_1a() throws Exception {
        this.check("(eqv? 'a 'a)", "#t");
        this.check("(eqv? 'a 'b)", "#f");
        this.check("(eqv? 2 2)", "#t");
        this.check("(eqv? '() '())", "#t");
        this.check("(eqv? 100000000 100000000)", "#t");
        this.check("(eqv? (cons 1 2) (cons 1 2))", "#f");
        this.check("(eqv? (lambda () 1) (lambda () 2))", "#f");
        this.check("(eqv? #f 'nil)", "#f");
        this.check("(let ((p (lambda (x) x))) (eqv? p p))", "#t");
        this.eval("(define gen-counter   (lambda ()     (let ((n 0))       (lambda ()         (set! n (+ n 1))         n))))");
        this.check("(let ((g (gen-counter))) (eqv? g g))", "#t");
        this.check("(eqv? (gen-counter) (gen-counter))", "#f");
        this.check("(let ((x '(a))) (eqv? x x))", "#t");
    }

    public void test6_1b() throws Exception {
        this.check("(eq? 'a 'a)", "#t");
        this.check("(eq? (list 'a) (list 'a))", "#f");
        this.check("(eq? '() '())", "#t");
        this.check("(eq? car car)", "#t");
        this.check("(let ((x '(a))) (eq? x x))", "#t");
        this.check("(let ((x '#())) (eq? x x))", "#t");
        this.check("(let ((p (lambda (x) x))) (eq? p p))", "#t");
    }

    public void test6_1c() throws Exception {
        this.check("(equal? 'a 'a)", "#t");
        this.check("(equal? '(a) '(a))", "#t");
        this.check("(equal? '(a (b) c) '(a (b) c))", "#t");
        this.check("(equal? \"abc\" \"abc\")", "#t");
        this.check("(equal? 2 2)", "#t");
        this.check("(equal? (make-vector 5 'a) (make-vector 5 'a))", "#t");
    }

    public void testNumbers() throws Exception {
        this.check("(+ 3 4)", "7");
        this.check("(+ 3)", "3");
        this.check("(+)", "0");
        this.check("(* 4)", "4");
        this.check("(*)", "1");
        this.check("(+)", "0");
        this.check("(*)", "1");
        this.check("(- 1)", "-1");
        this.check("(/ 1)", "1");
        this.check("(+ 3 3)", "6");
        this.check("(- 3 3)", "0");
        this.check("(* 3 3)", "9");
        this.check("(/ 3 3)", "1");
        this.check("(+  1 2 3 4)", "10");
        this.check("(-  1 2 3 4)", "-8");
        this.check("(*  1 2 3 4)", "24");
        this.check("(/ 24 2 3 4)", "1");
    }

    public void test6_3_2() throws Exception {
        this.check("(pair? '(a . b))", "#t");
        this.check("(pair? '(a b c))", "#t");
        this.check("(pair? '())", "#f");
        this.check("(pair? '#(a b))", "#f");
        this.check("(cons 'a '())", "(a)");
        this.check("(cons '(a) '(b c d))", "((a) b c d)");
        this.check("(cons \"a\" '(b c))", "(\"a\" b c)");
        this.check("(cons 'a '3)", "(a . 3)");
        this.check("(cons '(a b) 'c)", "((a b) . c)");
        this.check("(car '(a b c))", "a");
        this.check("(car '((a) b c d))", "(a)");
        this.check("(car '(1 . 2))", "1");
        try {
            this.eval("(car '())");
            TestR5RS.fail();
        }
        catch (SchemeException schemeException) {
            // empty catch block
        }
    }

    public void test6_3_2a() throws Exception {
        this.check("(cdr '((a) b c d))", "(b c d)");
        this.check("(cdr '(1 . 2))", "2");
        try {
            this.eval("(cdr '())");
            TestR5RS.fail();
        }
        catch (SchemeException schemeException) {
            // empty catch block
        }
    }

    public void test6_3_2b() throws Exception {
        this.eval("(define (f) (list 'not-a-constant-list))");
        this.eval("(define (g) '(constant-list))");
        this.eval("(set-car! (f) 3)");
        try {
            this.eval("(set-car! (g) 3)");
            TestR5RS.fail();
        }
        catch (SchemeException schemeException) {
            // empty catch block
        }
    }

    public void test6_3_2c() throws Exception {
        this.eval("(define (f) (list 'not-a-constant-list))");
        this.eval("(define (g) '(constant-list))");
        this.eval("(set-cdr! (f) 3)");
        try {
            this.eval("(set-cdr! (g) 3)");
            TestR5RS.fail();
        }
        catch (SchemeException schemeException) {
            // empty catch block
        }
    }

    public void test6_3_2d() throws Exception {
        this.check("(list? '(a b c))", "#t");
        this.check("(list? '())", "#t");
        this.check("(list? '(a . b))", "#f");
        this.check("(list 'a (+ 3 4) 'c)", "(a 7 c)");
        this.check("(list)", "()");
        this.check("(length '(a b c))", "3");
        this.check("(length '(a (b) (c d e)))", "3");
        this.check("(length '())", "0");
        this.check("(append '(x) '(y))", "(x y)");
        this.check("(append '(a) '(b c d))", "(a b c d)");
        this.check("(append '(a (b)) '((c)))", "(a (b) (c))");
        this.check("(append '(a b) '(c . d))", "(a b c . d)");
        this.check("(append '() 'a)", "a");
        this.check("(reverse '(a b c))", "(c b a)");
        this.check("(reverse '(a (b c) d (e (f))))", "((e (f)) d (b c) a)");
        this.check("(memq 'a '(a b c))", "(a b c)");
        this.check("(memq 'b '(a b c))", "(b c)");
        this.check("(memq 'a '(b c d))", "#f");
        this.check("(memq   (list 'a) '(b (a) c))", "#f");
        this.check("(member (list 'a) '(b (a) c))", "((a) c)");
        this.check("(memv '101 '(100 101 102))", "(101 102)");
        this.eval("(define e '((a 1) (b 2) (c 3)))");
        this.check("(assq 'a e)", "(a 1)");
        this.check("(assq 'b e)", "(b 2)");
        this.check("(assq 'd e)", "#f");
        this.check("(assq  (list 'a) '(((a)) ((b)) ((c))))", "#f");
        this.check("(assoc (list 'a) '(((a)) ((b)) ((c))))", "((a))");
        this.check("(assv 5 '((2 3) (5 7) (11 13)))", "(5 7)");
        this.check("(assq 'b '((a . 1) (b . 2)))", "(b . 2)");
    }

    public void test6_3_3() throws Exception {
        this.check("(symbol? 'foo)", "#t");
        this.check("(symbol? (car '(a b)))", "#t");
        this.check("(symbol? \"bar\")", "#f");
        this.check("(symbol? 'nil)", "#t");
        this.check("(symbol? '())", "#f");
        this.check("(symbol? #f)", "#f");
        this.check("(symbol->string 'flying-fish)", "\"flying-fish\"");
        this.check("(symbol->string 'Martin)", "\"martin\"");
        this.check("(symbol->string (string->symbol \"Malvia\"))", "\"Malvia\"");
    }

    public void test6_3_5() throws Exception {
        this.eval("(define (f) (make-string 3 #\\*))");
        this.eval("(define (g) \"***\"))");
        this.eval("(string-set! (f) 0 #\\?)");
        try {
            this.eval("(string-set! (g) 0 #\\?)");
            TestR5RS.fail();
        }
        catch (SchemeException schemeException) {
            // empty catch block
        }
    }

    public void test6_3_5a() throws Exception {
        try {
            this.eval("(string-set! (symbol->string 'immutable) 0 #\\?)");
            TestR5RS.fail();
        }
        catch (SchemeException schemeException) {
            // empty catch block
        }
    }

    public void test6_3_6() throws Exception {
        this.check("(vector-ref '#(1 1 2 3 5 8 13 21) 5)", "8");
        this.check("(vector 'a 'b 'c)", "#(a b c)");
        this.check("(vector-length '#(1 2 3 4))", "4");
    }

    public void test6_4_procedureq() throws Exception {
        this.check("(procedure?  car)", "#t");
        this.check("(procedure? 'car)", "#f");
        this.check("(procedure?  (lambda (x) (* x x)))", "#t");
        this.check("(procedure? '(lambda (x) (* x x)))", "#f");
        this.check("(call-with-current-continuation procedure?)", "#t");
    }

    public void test6_4_apply() throws Exception {
        this.check("(apply + (list 3 4))", "7");
        this.check("(apply + 1 2 '(3 4))", "10");
        this.check("(let ((l (list 1 2)))  (apply    (lambda x (set-car! x 3))    l)  l)", "(1 2)");
    }

    public void test6_4_map() throws Exception {
        this.check("(map + '(1 2 3) '(4 5 6))", "(5 7 9)");
    }

    public void test6_4_for_each() throws Exception {
        this.check("(let ((v (make-vector 5))       (n 0))   (for-each     (lambda (x y)       (vector-set! v n (+ x y))       (set! n (+ n 1)))     '(0 1 2 3 4)     '(1 1 2 3 5))   v)", "#(1 2 4 6 9)");
    }

    public void test6_4_force() throws Exception {
        this.check("(force (delay (+ 1 2)))", "3");
        this.check("(let ((p (delay (+ 1 2)))) (list (force p) (force p)))", "(3 3)");
        this.eval("(begin  (define count 0)  (define x 'foo)  (define p    (delay      (begin        (set! count (+ count 1))        (if (> count x)          count          (force p)))))  (define x 5))");
        this.check("(force p)", "6");
        this.eval("(set! x 10)");
        this.check("(force p)", "6");
    }

    public void test6_4_callcc() throws Exception {
        this.check("(let ((path '())\n      (c #f))\n  (let ((add (lambda (s)\n               (set! path (cons s path)))))\n    (dynamic-wind\n      (lambda () (add 'connect))\n      (lambda ()\n        (add (call-with-current-continuation\n               (lambda (c0)\n                 (set! c c0)\n                 'talk1))))\n      (lambda () (add 'disconnect)))\n    (if (< (length path) 4)\n        (c 'talk2)\n        (reverse path))))", "(connect talk1 disconnect connect talk2 disconnect)");
    }

    public void test6_5() throws Exception {
        this.check("(eval '(* 7 3) (scheme-report-environment 5))", "21");
        this.check("(let ((f (eval '(lambda (f x) (f x x))\n       (null-environment 5))))\n  (f + 10))", "20");
    }
}

