/*
 * Decompiled with CFR 0.152.
 */
package sisc.ser;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import sisc.data.Expression;
import sisc.interpreter.AppContext;
import sisc.ser.NestedObjectOutputStream;
import sisc.ser.SLL2Serializer;

public class StreamSerializer
extends SLL2Serializer {
    private Map entryPoints;
    private Map classes;
    private int nextEp;
    private int nextClassIdx;

    private StreamSerializer(AppContext appContext, NestedObjectOutputStream nestedObjectOutputStream) throws IOException {
        super(appContext, nestedObjectOutputStream);
        nestedObjectOutputStream.setSerializerInstance(this);
        this.classes = new HashMap();
        this.entryPoints = new HashMap();
    }

    public StreamSerializer(AppContext appContext, OutputStream outputStream) throws IOException {
        this(appContext, new NestedObjectOutputStream(outputStream));
    }

    protected void writeExpression(Expression expression, boolean bl) throws IOException {
        int n = this.nextEp;
        Integer n2 = (Integer)this.entryPoints.get(expression);
        if (n2 != null) {
            this.writeSeenEntryPoint(n2);
        } else {
            this.entryPoints.put(expression, new Integer(this.nextEp));
            this.writeNewEntryPointMarker(this.nextEp, expression);
            ++this.nextEp;
            this.writeExpression(expression, n, -1, bl);
        }
    }

    public void writeClass(Class clazz) throws IOException {
        Integer n = (Integer)this.classes.get(clazz);
        if (n == null) {
            this.classes.put(clazz, new Integer(this.nextClassIdx));
            this.writeInt(this.nextClassIdx);
            ++this.nextClassIdx;
            this.writeUTF(clazz.getName());
        } else {
            this.writeInt(n);
        }
    }

    protected void serializeEnd(int n, int n2) {
    }
}

