/*
 * Decompiled with CFR 0.152.
 */
package sisc.ser;

import java.io.IOException;
import java.io.ObjectInput;
import java.util.LinkedList;
import sisc.data.Expression;
import sisc.data.Singleton;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.env.SymbolicEnvironment;
import sisc.interpreter.AppContext;
import sisc.ser.DeserializerImpl;
import sisc.ser.LibraryBinding;
import sisc.util.InternedValue;

public abstract class SLL2Deserializer
extends DeserializerImpl {
    private LinkedList deserQueue = new LinkedList();

    protected SLL2Deserializer(AppContext appContext, ObjectInput objectInput) throws IOException {
        super(appContext, objectInput);
    }

    public Expression readExpression() throws IOException {
        return this.readExpression(false, -1);
    }

    public Expression readInitializedExpression() throws IOException {
        return this.readExpression(true, -1);
    }

    protected abstract void recordReadObject(int var1, Expression var2);

    protected abstract Expression skipReadObject(boolean var1, int var2) throws IOException;

    private Expression deserializeDetails(boolean bl, int n, Expression expression) throws IOException {
        if (expression instanceof Singleton) {
            expression.deserialize(this);
            expression = ((Singleton)((Object)expression)).singletonValue();
            this.recordReadObject(n, expression);
        } else {
            this.recordReadObject(n, expression);
            int n2 = this.deserQueue.size();
            this.deserQueue.addFirst(expression);
            if (bl) {
                this.deserLoop(n2);
            }
        }
        return expression;
    }

    protected Expression readExpression(boolean bl, int n) throws IOException {
        int n2 = this.readInt();
        switch (n2) {
            case 2: {
                n = this.readInt();
                return this.skipReadObject(bl, n);
            }
            case 3: {
                Symbol symbol = (Symbol)this.readInitializedExpression();
                Class clazz = this.readClass();
                Value value = InternedValue.deserResolve(symbol, clazz);
                return this.deserializeDetails(bl, n, value);
            }
            case 0: {
                Expression expression;
                Class clazz = this.readClass();
                try {
                    expression = (Expression)clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                    throw new IOException(instantiationException.getMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                    throw new IOException(illegalAccessException.getMessage());
                }
                return this.deserializeDetails(bl, n, expression);
            }
            case 1: {
                return null;
            }
            case 4: {
                String string = this.readUTF();
                int n3 = this.readInt();
                Expression expression = this.resolveLibraryBinding(new LibraryBinding(string, n3));
                this.recordReadObject(n, expression);
                return expression;
            }
        }
        return this.fetchShared(n2 - 16);
    }

    public Expression deser() throws IOException {
        int n = this.deserQueue.size();
        Expression expression = this.readExpression();
        this.deserLoop(n);
        return expression;
    }

    private void deserLoop(int n) throws IOException {
        while (this.deserQueue.size() > n) {
            Object e = this.deserQueue.removeFirst();
            this.initializeExpression((Expression)e);
        }
    }

    private void initializeExpression(Expression expression) throws IOException {
        expression.deserialize(this);
        expression.deserializeAnnotations(this);
    }

    protected abstract Expression fetchShared(int var1) throws IOException;

    public SymbolicEnvironment readSymbolicEnvironment() throws IOException {
        Expression expression = this.readExpression();
        if (expression instanceof Symbol) {
            expression = this.ctx.getExpression((Symbol)expression);
        }
        return (SymbolicEnvironment)((Object)expression);
    }
}

