/*
 * Decompiled with CFR 0.152.
 */
package sisc.ser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import sisc.data.Expression;
import sisc.data.Symbol;
import sisc.interpreter.AppContext;
import sisc.ser.BufferedRandomAccessInputStream;
import sisc.ser.Library;
import sisc.ser.LibraryBinding;
import sisc.ser.MemoryRandomAccessInputStream;
import sisc.ser.SeekableDataInputStream;
import sisc.util.Util;

public class LibraryManager
extends Util {
    protected Map loadedLibraries;
    AppContext ctx;

    public LibraryManager(AppContext appContext) {
        this.ctx = appContext;
        this.loadedLibraries = new HashMap();
    }

    public Expression getExpression(Symbol symbol) throws IOException {
        Iterator iterator = this.loadedLibraries.values().iterator();
        while (iterator.hasNext()) {
            LoadableLibrary loadableLibrary = (LoadableLibrary)iterator.next();
            try {
                return loadableLibrary.getLibrary().getLocalExpression(symbol);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
        }
        throw new FileNotFoundException(LibraryManager.liMessage(SISCB, "namedlibbindingnotanywhere", symbol.toString()));
    }

    public LibraryBinding lookupBinding(Expression expression) throws IOException {
        Iterator iterator = this.loadedLibraries.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            LoadableLibrary loadableLibrary = (LoadableLibrary)entry.getValue();
            int n = loadableLibrary.getLibrary().reverseLookup(expression);
            if (n <= -1) continue;
            return new LibraryBinding(string, n);
        }
        return null;
    }

    public void addLibrary(Library library) {
        this.loadedLibraries.put(library.getName(), new LoadableLibrary(library));
    }

    public void addLibrary(String string, URL uRL) {
        this.loadedLibraries.put(string, new LoadableLibrary(uRL));
    }

    public boolean loadLibrary(String string) {
        try {
            URL uRL = new URL(string);
            this.addLibrary(string, uRL);
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return false;
        }
    }

    public Expression resolveBinding(LibraryBinding libraryBinding) throws IOException {
        LoadableLibrary loadableLibrary = (LoadableLibrary)this.loadedLibraries.get(libraryBinding.name);
        return loadableLibrary.getLibrary().getExpression(libraryBinding.epid);
    }

    class LoadableLibrary {
        URL path;
        Library handle;

        public LoadableLibrary(URL uRL) {
            this.path = uRL;
        }

        public LoadableLibrary(Library library) {
            this.handle = library;
        }

        public void open() throws IOException {
            if (this.handle == null) {
                SeekableDataInputStream seekableDataInputStream = this.path.getProtocol().equals("file") ? new SeekableDataInputStream(new BufferedRandomAccessInputStream(new File(new File(this.path.getPath()), this.path.getFile()).getCanonicalPath(), "r", 8, 2048)) : new SeekableDataInputStream(new MemoryRandomAccessInputStream(this.path.openStream()));
                try {
                    this.handle = Library.load(LibraryManager.this.ctx, seekableDataInputStream);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
            }
        }

        public Library getLibrary() throws IOException {
            this.open();
            return this.handle;
        }
    }
}

