/*
 * Decompiled with CFR 0.152.
 */
package sisc.ser;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import sisc.data.Expression;
import sisc.data.Singleton;
import sisc.data.Symbol;
import sisc.env.SymbolicEnvironment;
import sisc.interpreter.AppContext;
import sisc.ser.BerEncoding;
import sisc.ser.BlockSerializer;
import sisc.ser.Library;
import sisc.util.ExpressionVisitee;
import sisc.util.ExpressionVisitor;

public class LibraryBuilder
extends BerEncoding
implements ExpressionVisitor {
    AppContext ctx;
    boolean addAllowed = true;
    Set classes;
    Set seen;
    Set duplicates;
    int dupid = 0;
    LinkedList entryPoints;
    LinkedList newEntryPoints;
    LinkedList serQueue;
    Map names;
    boolean includeAEs;

    public LibraryBuilder() {
        this(null);
    }

    public LibraryBuilder(AppContext appContext) {
        this(appContext, true);
    }

    public LibraryBuilder(AppContext appContext, boolean bl) {
        this.ctx = appContext;
        this.includeAEs = bl;
        this.classes = new HashSet();
        this.seen = new HashSet();
        this.duplicates = new HashSet();
        this.entryPoints = new LinkedList();
        this.newEntryPoints = new LinkedList();
        this.names = new HashMap();
    }

    public void setAppContext(AppContext appContext) {
        this.ctx = appContext;
    }

    public int add(Symbol symbol, Expression expression) {
        int n = this.add(expression);
        this.names.put(symbol, new Integer(n));
        return n;
    }

    public int add(Expression expression) {
        int n;
        if (expression == null) {
            return -1;
        }
        int n2 = this.entryPoints.indexOf(expression);
        if (n2 == -1 && (n = this.newEntryPoints.indexOf(expression)) != -1) {
            n2 = this.entryPoints.size() + n;
        }
        if (n2 == -1 && this.addAllowed) {
            n2 = this.entryPoints.size() + this.newEntryPoints.size();
            this.newEntryPoints.add(expression);
        }
        return n2;
    }

    public int get(Expression expression) {
        return this.entryPoints.indexOf(expression);
    }

    public Library buildLibrary(String string, OutputStream outputStream) throws IOException {
        Object object;
        Object object2;
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        System.err.println("Pass 1: Discovery...");
        this.serQueue = new LinkedList();
        while (!this.newEntryPoints.isEmpty()) {
            this.entryPoints.addAll(this.newEntryPoints);
            this.serQueue.addAll(this.newEntryPoints);
            this.newEntryPoints.clear();
            while (!this.serQueue.isEmpty()) {
                object2 = (Expression)this.serQueue.removeFirst();
                if (object2 == null) continue;
                if (this.seen.contains(object2)) {
                    if (this.entryPoints.contains(object2) || this.newEntryPoints.contains(object2)) continue;
                    this.duplicates.add(object2);
                    continue;
                }
                this.seen.add(object2);
                this.classes.add(object2.getClass());
                if (object2 instanceof SymbolicEnvironment) {
                    if (this.includeAEs || ((Expression)object2).getName() == null) {
                        ((Expression)object2).visit(this);
                    }
                } else {
                    ((Expression)object2).visit(this);
                }
                if (object2 instanceof Singleton) continue;
                ((Expression)object2).visitAnnotations(this);
            }
        }
        this.addAllowed = false;
        this.duplicates.removeAll(this.entryPoints);
        object2 = new Expression[this.entryPoints.size() + this.duplicates.size()];
        int n = 0;
        Object object3 = this.entryPoints.iterator();
        while (object3.hasNext()) {
            object2[n++] = (Expression)object3.next();
        }
        object3 = this.duplicates.iterator();
        while (object3.hasNext()) {
            object2[n++] = (Expression)object3.next();
        }
        System.err.println("Pass 2: Write data segment");
        object3 = File.createTempFile("heap", "tmp");
        ((File)object3).deleteOnExit();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream((File)object3));
        Vector vector = new Vector(this.classes);
        BlockSerializer blockSerializer = new BlockSerializer(this.ctx, bufferedOutputStream, vector, (Expression[])object2);
        Iterator iterator = this.entryPoints.iterator();
        while (iterator.hasNext()) {
            object = (Expression)iterator.next();
            blockSerializer.serialize((Expression)object);
        }
        ((OutputStream)bufferedOutputStream).flush();
        ((OutputStream)bufferedOutputStream).close();
        System.err.println("Pass 3: Write index");
        dataOutputStream.writeUTF("SLL4");
        dataOutputStream.writeUTF(string);
        LibraryBuilder.writeBer(this.classes.size(), dataOutputStream);
        for (int i = 0; i < vector.size(); ++i) {
            dataOutputStream.writeUTF(((Class)vector.elementAt(i)).getName());
        }
        int[] nArray = blockSerializer.getOffsets();
        object = blockSerializer.getSizes();
        LibraryBuilder.writeBer(nArray.length, dataOutputStream);
        for (int i = 0; i < nArray.length; ++i) {
            LibraryBuilder.writeBer(nArray[i], dataOutputStream);
            LibraryBuilder.writeBer((long)object[i], dataOutputStream);
        }
        LibraryBuilder.writeBer(this.names.size(), dataOutputStream);
        Object object4 = this.names.keySet().iterator();
        while (object4.hasNext()) {
            Symbol symbol = (Symbol)object4.next();
            dataOutputStream.writeUTF(symbol.symval);
            LibraryBuilder.writeBer(((Integer)this.names.get(symbol)).intValue(), dataOutputStream);
        }
        System.err.println("Pass 4: Append data segment");
        object4 = new BufferedInputStream(new FileInputStream((File)object3));
        int n2 = 0;
        byte[] byArray = new byte[65536];
        while (-1 != (n2 = ((FilterInputStream)object4).read(byArray))) {
            if (n2 <= 0) continue;
            dataOutputStream.write(byArray, 0, n2);
        }
        dataOutputStream.flush();
        System.err.println(this.classes.size() + " classes");
        System.err.println(nArray.length + " entry points");
        return null;
    }

    public boolean visit(ExpressionVisitee expressionVisitee) {
        if (expressionVisitee != null) {
            this.serQueue.addFirst(expressionVisitee);
            if (this.includeAEs && expressionVisitee instanceof SymbolicEnvironment) {
                SymbolicEnvironment symbolicEnvironment = (SymbolicEnvironment)expressionVisitee;
                if (symbolicEnvironment.getName() == null) {
                    this.add(symbolicEnvironment.asValue());
                } else {
                    this.add(symbolicEnvironment.getName(), symbolicEnvironment.asValue());
                }
            }
        }
        return true;
    }
}

