/*
 * Decompiled with CFR 0.152.
 */
package sisc.ser;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import sisc.data.Pair;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.env.MemorySymEnv;
import sisc.env.SymbolicEnvironment;
import sisc.ser.Deserializer;
import sisc.ser.Library;
import sisc.ser.LibraryBuilder;
import sisc.ser.LibraryDeserializer;
import sisc.ser.Serializer;
import sisc.util.ExpressionVisitor;

public class LibraryAE
extends MemorySymEnv {
    protected LibraryBuilder lb;
    protected Library base;
    protected Map addressMap;
    protected Set bindWatch;
    protected int parentIdx = -1;

    public LibraryAE(Symbol symbol, LibraryBuilder libraryBuilder) {
        super(symbol);
        this.lb = libraryBuilder;
        this.bindWatch = new HashSet();
    }

    public LibraryAE(SymbolicEnvironment symbolicEnvironment, LibraryBuilder libraryBuilder) {
        this.parent = symbolicEnvironment;
        this.lb = libraryBuilder;
        this.bindWatch = new HashSet();
    }

    public LibraryAE(Library library) {
        this.base = library;
        this.addressMap = new HashMap();
    }

    public SymbolicEnvironment getParent() {
        if (this.parent == null && this.parentIdx > -1) {
            this.loadParent();
        }
        return this.parent;
    }

    public void addSymbolicBindings(Library library, Pair pair) {
        while (pair != EMPTYLIST) {
            Symbol symbol = (Symbol)pair.car();
            this.addBinding(library, symbol, library.getEntryPoint(symbol));
            pair = (Pair)pair.cdr();
        }
    }

    public void addBinding(Library library, Symbol symbol, int n) {
        this.addressMap.put(symbol, new LibraryBinding(library, n));
    }

    public void undefine(Symbol symbol) {
        if (this.bindWatch != null) {
            this.bindWatch.remove(symbol);
        }
        super.undefine(symbol);
    }

    private void loadParent() {
        if (this.parent == null || this.parentIdx > -1) {
            try {
                this.parent = (SymbolicEnvironment)((Object)this.base.getExpression(this.parentIdx));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLoc(Symbol symbol) {
        Map map = this.symbolMap;
        synchronized (map) {
            Object object;
            Integer n = (Integer)this.symbolMap.get(symbol);
            if (n != null) {
                return n;
            }
            if (this.addressMap != null) {
                object = (LibraryBinding)this.addressMap.get(symbol);
                if (object != null) {
                    try {
                        return this.store(symbol, (Value)((LibraryBinding)object).lib.getExpression(((LibraryBinding)object).entryPoint));
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                this.loadParent();
            }
            if (this.parent == null) {
                return -1;
            }
            object = this.parent.lookup(symbol);
            if (object == null) {
                return -1;
            }
            return this.store(symbol, (Value)object);
        }
    }

    public int store(Symbol symbol, Value value) {
        if (this.bindWatch != null) {
            this.bindWatch.add(symbol);
        }
        return super.store(symbol, value);
    }

    public LibraryAE() {
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        this.setName((Symbol)deserializer.readExpression());
        this.base = ((LibraryDeserializer)deserializer).getLibrary();
        int n = deserializer.readInt();
        this.addressMap = new HashMap(n);
        for (int i = 0; i < n; ++i) {
            Symbol symbol = (Symbol)deserializer.readExpression();
            this.addBinding(this.base, symbol, deserializer.readInt());
        }
        this.parentIdx = deserializer.readInt();
        this.deserializeSidecar(deserializer);
    }

    public void serialize(Serializer serializer) throws IOException {
        serializer.writeExpression(this.getName());
        if (this.base == null) {
            if (this.getName() != null) {
                this.lb.add(this.getName(), this);
            }
            serializer.writeInt(this.bindWatch.size());
            Iterator iterator = this.bindWatch.iterator();
            while (iterator.hasNext()) {
                Symbol symbol = (Symbol)iterator.next();
                serializer.writeExpression(symbol);
                int n = this.lb.add(super.lookup(symbol));
                serializer.writeInt(n);
            }
            serializer.writeInt(this.lb.add(this.parent == null ? null : this.parent.asValue()));
        } else {
            serializer.writeInt(0);
            Iterator iterator = this.addressMap.keySet().iterator();
            while (iterator.hasNext()) {
                Symbol symbol = (Symbol)iterator.next();
                LibraryBinding libraryBinding = (LibraryBinding)this.addressMap.get(symbol);
                serializer.writeExpression(symbol);
                serializer.writeInt(libraryBinding.entryPoint);
            }
            serializer.writeInt(this.parentIdx);
        }
        this.serializeSidecar(serializer);
    }

    public boolean visit(ExpressionVisitor expressionVisitor) {
        this.visitSidecar(expressionVisitor);
        if (!expressionVisitor.visit(this.parent)) {
            return false;
        }
        if (this.base == null) {
            if (this.getName() != null && expressionVisitor == this.lb) {
                this.lb.add(this.getName(), this);
            }
            Iterator iterator = this.bindWatch.iterator();
            while (iterator.hasNext()) {
                Symbol symbol = (Symbol)iterator.next();
                if (!expressionVisitor.visit(symbol)) {
                    return false;
                }
                if (expressionVisitor != this.lb) continue;
                this.lb.add(super.lookup(symbol));
            }
            if (expressionVisitor == this.lb) {
                this.lb.add(this.parent == null ? null : this.parent.asValue());
            }
        } else {
            Iterator iterator = this.addressMap.keySet().iterator();
            while (iterator.hasNext()) {
                Symbol symbol = (Symbol)iterator.next();
                if (expressionVisitor.visit(symbol)) continue;
                return false;
            }
        }
        return true;
    }

    static class LibraryBinding {
        public Library lib;
        public int entryPoint;

        public LibraryBinding(Library library, int n) {
            this.lib = library;
            this.entryPoint = n;
        }
    }
}

