/*
 * Decompiled with CFR 0.152.
 */
package sisc.ser;

import java.io.IOException;
import java.io.ObjectOutput;
import sisc.data.Expression;
import sisc.data.Singleton;
import sisc.interpreter.AppContext;
import sisc.interpreter.Context;
import sisc.ser.LibraryBinding;
import sisc.ser.NestedObjectOutputStream;
import sisc.ser.Serializer;
import sisc.ser.SerializerImpl;

public class JavaSerializer
extends SerializerImpl {
    private JavaSerializer(AppContext appContext, ObjectOutput objectOutput) throws IOException {
        super(appContext, objectOutput);
        if (appContext == null) {
            System.err.println("AppContext is null!!!");
        }
    }

    public static Serializer create(ObjectOutput objectOutput) throws IOException {
        return objectOutput instanceof NestedObjectOutputStream ? ((NestedObjectOutputStream)objectOutput).getSerializerInstance() : new JavaSerializer(Context.currentAppContext(), objectOutput);
    }

    public void writeExpression(Expression expression) throws IOException {
        if (expression == null || expression instanceof Singleton) {
            this.writeBoolean(false);
            this.writeObject(expression);
        } else {
            LibraryBinding libraryBinding = this.lookupLibraryBinding(expression);
            if (libraryBinding == null) {
                this.writeBoolean(false);
                this.writeObject(expression);
            } else {
                this.writeBoolean(true);
                this.writeUTF(libraryBinding.name);
                this.writeInt(libraryBinding.epid);
            }
        }
    }

    public void writeInitializedExpression(Expression expression) throws IOException {
        this.writeExpression(expression);
    }

    public void writeClass(Class clazz) throws IOException {
        this.writeObject(clazz);
    }
}

