/*
 * Decompiled with CFR 0.152.
 */
package sisc.ser;

import java.io.IOException;
import java.io.ObjectInput;
import sisc.data.Expression;
import sisc.data.Symbol;
import sisc.env.DelegatingSymEnv;
import sisc.env.SymbolicEnvironment;
import sisc.interpreter.AppContext;
import sisc.interpreter.Context;
import sisc.ser.Deserializer;
import sisc.ser.DeserializerImpl;
import sisc.ser.LibraryBinding;
import sisc.ser.NestedObjectInputStream;
import sisc.util.InternedValue;

public class JavaDeserializer
extends DeserializerImpl {
    private JavaDeserializer(AppContext appContext, ObjectInput objectInput) throws IOException {
        super(appContext, objectInput);
    }

    public static Deserializer create(ObjectInput objectInput) throws IOException {
        return objectInput instanceof NestedObjectInputStream ? ((NestedObjectInputStream)objectInput).getDeserializerInstance() : new JavaDeserializer(Context.currentAppContext(), objectInput);
    }

    protected Object readObjectIOExceptionOnly() throws IOException {
        try {
            return this.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(classNotFoundException.toString());
        }
    }

    public Expression readExpression() throws IOException {
        boolean bl = this.readBoolean();
        if (bl) {
            String string = this.readUTF();
            int n = this.readInt();
            return this.resolveLibraryBinding(new LibraryBinding(string, n));
        }
        Object object = this.readObjectIOExceptionOnly();
        return (Expression)(object instanceof InternedValue ? ((InternedValue)object).readResolve() : object);
    }

    public Expression readInitializedExpression() throws IOException {
        return this.readExpression();
    }

    public SymbolicEnvironment readSymbolicEnvironment() throws IOException {
        Expression expression = this.readExpression();
        return expression instanceof Symbol ? new DelegatingSymEnv((Symbol)expression) : (SymbolicEnvironment)((Object)expression);
    }

    public Class readClass() throws IOException {
        return (Class)this.readObjectIOExceptionOnly();
    }
}

