/*
 * Decompiled with CFR 0.152.
 */
package sisc.ser;

import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import sisc.data.Expression;
import sisc.interpreter.AppContext;
import sisc.ser.SLL2Serializer;

public class BlockSerializer
extends SLL2Serializer {
    private CountingOutputStream cos;
    private Map offsets;
    private Set seen;
    private Vector classes;
    private int[] sizes;
    private Expression[] entryPoints;
    private HashMap epi;
    private HashMap ci;

    private BlockSerializer(AppContext appContext, CountingOutputStream countingOutputStream, Vector vector, Expression[] expressionArray) throws IOException {
        super(appContext, new WrappedDataOutputStream(countingOutputStream));
        int n;
        this.cos = countingOutputStream;
        this.classes = vector;
        this.entryPoints = expressionArray;
        this.sizes = new int[expressionArray.length];
        this.offsets = new HashMap();
        this.seen = new HashSet();
        this.ci = new HashMap();
        for (n = 0; n < vector.size(); ++n) {
            this.ci.put(vector.elementAt(n), new Integer(n));
        }
        this.epi = new HashMap();
        for (n = 0; n < expressionArray.length; ++n) {
            this.epi.put(expressionArray[n], new Integer(n));
        }
    }

    public BlockSerializer(AppContext appContext, OutputStream outputStream, Vector vector, Expression[] expressionArray) throws IOException {
        this(appContext, new CountingOutputStream(outputStream), vector, expressionArray);
    }

    public int[] getSizes() {
        return this.sizes;
    }

    protected void writeExpression(Expression expression, boolean bl) throws IOException {
        boolean bl2;
        Integer n = (Integer)this.epi.get(expression);
        int n2 = -1;
        int n3 = -1;
        if (n != null) {
            n3 = n;
            if (this.seen.contains(expression)) {
                this.writeSeenEntryPoint(n3);
                return;
            }
            this.seen.add(expression);
            this.offsets.put(new Integer(n3), new Integer(this.cos.position));
            this.writeNewEntryPointMarker(n3, expression);
            n2 = this.cos.position;
            bl = true;
        }
        if ((bl2 = this.writeExpression(expression, n3, n2, bl)) && n2 != -1) {
            this.sizes[n3] = this.cos.position - n2;
        }
    }

    public void writeClass(Class clazz) throws IOException {
        this.writeInt((Integer)this.ci.get(clazz));
    }

    protected void serializeEnd(int n, int n2) {
        if (n2 != -1) {
            this.sizes[n] = this.cos.position - n2;
        }
    }

    public int[] getOffsets() {
        int[] nArray = new int[this.offsets.size()];
        Iterator iterator = this.offsets.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            nArray[n.intValue()] = (Integer)this.offsets.get(n);
        }
        return nArray;
    }

    private static class WrappedDataOutputStream
    extends DataOutputStream
    implements ObjectOutput {
        public WrappedDataOutputStream(OutputStream outputStream) {
            super(outputStream);
        }

        public void writeObject(Object object) throws IOException {
            throw new IOException("cannot serialize " + object);
        }
    }

    private static class CountingOutputStream
    extends FilterOutputStream {
        public int position = 0;

        public CountingOutputStream(OutputStream outputStream) {
            super(outputStream);
        }

        public void write(int n) throws IOException {
            ++this.position;
            this.out.write(n);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.position += n2;
            this.out.write(byArray, n, n2);
        }
    }
}

