/*
 * Decompiled with CFR 0.152.
 */
package sisc.reader;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Serializable;
import java.util.HashMap;
import sisc.compiler.CompilerConstants;
import sisc.compiler.Syntax;
import sisc.data.Box;
import sisc.data.Expression;
import sisc.data.ImmutablePair;
import sisc.data.ImmutableString;
import sisc.data.ImmutableVector;
import sisc.data.Pair;
import sisc.data.Quantity;
import sisc.data.SchemeCharacter;
import sisc.data.SchemeVector;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.exprs.AnnotatedExpr;
import sisc.reader.CharUtil;
import sisc.reader.Lexer;
import sisc.reader.SourceReader;
import sisc.reader.Tokens;
import sisc.util.Defaults;
import sisc.util.Util;

public class Parser
extends Util
implements Tokens {
    public static final int PRODUCE_IMMUTABLES = 1;
    public static final int PRODUCE_ANNOTATIONS = 2;
    public static final int STRICT_R5RS = 4;
    public static final int CASE_SENSITIVE = 8;
    public static final int READING_VECTOR = 16;
    public static final int PERMISSIVE_PARSING = 32;
    public boolean annotate = Defaults.EMIT_ANNOTATIONS;
    public Lexer lexer;
    static final Object DOT = new Object(){

        public String toString() {
            return ".";
        }
    };
    static final Object ENDPAIR = new Object(){

        public String toString() {
            return ")";
        }
    };
    static final Symbol SYNTAX = Symbol.get("syntax");
    static final Symbol ANNOTATION = Symbol.get("make-annotation");
    static final HashMap chars = new HashMap(8);

    public static boolean isPeculiarIdentifier(String string) {
        return string.equals("+") || string.equals("-") || string.equals("...");
    }

    public Parser(Lexer lexer) {
        this.lexer = lexer;
    }

    void warn(String string, PushbackReader pushbackReader) {
        if (pushbackReader instanceof SourceReader) {
            SourceReader sourceReader = (SourceReader)pushbackReader;
            System.err.println(Parser.warn(string, sourceReader.sourceFile, sourceReader.line, sourceReader.column));
        } else {
            System.err.println(Parser.warn(string));
        }
    }

    public final Value nextExpression(PushbackReader pushbackReader) throws IOException {
        return this.nextExpression(pushbackReader, 1, EMPTYLIST);
    }

    public final Value nextExpression(PushbackReader pushbackReader, int n, Pair pair) throws IOException {
        return this.nextExpression(pushbackReader, 10, n, pair);
    }

    public final Value nextExpression(PushbackReader pushbackReader, int n, int n2) throws IOException {
        return this.nextExpression(pushbackReader, n, n2, (Pair)EMPTYLIST);
    }

    public Value nextExpression(PushbackReader pushbackReader, int n, int n2, Pair pair) throws IOException {
        Object object = VOID;
        try {
            object = this._nextExpression(pushbackReader, new HashMap(), null, n, n2, pair);
            return (Value)object;
        }
        catch (ClassCastException classCastException) {
            if (object == ENDPAIR) {
                this.potentialError(n2, "orphanedparen", pushbackReader);
                return this.nextExpression(pushbackReader, n, n2, pair);
            }
            if (object == DOT) {
                throw new IOException(Parser.liMessage(SISCB, "unexpecteddot"));
            }
            return (Value)object;
        }
    }

    protected final Value nextExpression(PushbackReader pushbackReader, HashMap hashMap, int n, Pair pair) throws IOException {
        return (Value)this._nextExpression(pushbackReader, hashMap, null, n, pair);
    }

    protected void potentialError(int n, String string, PushbackReader pushbackReader) throws IOException {
        if (this.permissiveParsing(n)) {
            if (pushbackReader == null) {
                System.err.println(Parser.warn(string));
            } else {
                this.warn(string, pushbackReader);
            }
        } else {
            throw new IOException(Parser.liMessage(SISCB, string));
        }
    }

    protected void potentialError(int n, String string, String string2, PushbackReader pushbackReader) throws IOException {
        if (this.permissiveParsing(n)) {
            if (pushbackReader == null) {
                System.err.println(Parser.warn(string, string2));
            } else {
                System.err.println(Parser.warn(Parser.liMessage(SISCB, string, string2)));
            }
        } else {
            throw new IOException(Parser.liMessage(SISCB, string, string2));
        }
    }

    private Value lastValue(HashMap hashMap, Object object) {
        return (Value)(object instanceof Integer ? hashMap.get(object) : object);
    }

    protected Object _nextExpression(PushbackReader pushbackReader, HashMap hashMap, Integer n, int n2, Pair pair) throws IOException {
        return this._nextExpression(pushbackReader, hashMap, n, 10, n2, pair);
    }

    protected Quantity numberCheck(Object object, PushbackReader pushbackReader, int n) throws IOException {
        try {
            return (Quantity)object;
        }
        catch (ClassCastException classCastException) {
            this.potentialError(n, "badtokennotnumber", pushbackReader);
            return Quantity.ZERO;
        }
    }

    protected Object listSpecial(Symbol symbol, PushbackReader pushbackReader, HashMap hashMap, Integer n, int n2, Pair pair) throws IOException {
        Pair pair2;
        boolean bl = this.produceImmutables(n2);
        Pair pair3 = bl ? new ImmutablePair(EMPTYLIST, EMPTYLIST, false) : new Pair(EMPTYLIST, EMPTYLIST);
        Pair pair4 = pair2 = bl ? new ImmutablePair(symbol, pair3) : new Pair(symbol, pair3);
        if (n != null) {
            hashMap.put(n, pair2);
        }
        pair3.setCar(this.nextExpression(pushbackReader, hashMap, n2, pair));
        if (bl) {
            ((ImmutablePair)pair3).makeImmutable();
        }
        return pair2;
    }

    protected Object _nextExpression(PushbackReader pushbackReader, HashMap hashMap, Integer n, int n2, int n3, Pair pair) throws IOException {
        Object object;
        int n4 = -1;
        int n5 = -1;
        String string = null;
        int n6 = this.lexer.nextToken(pushbackReader, n2);
        block1 : switch (n6) {
            case 11: {
                return EOF;
            }
            case 6: {
                object = DOT;
                break;
            }
            case 7: {
                object = this.listSpecial(UNQUOTE, pushbackReader, hashMap, n, n3, pair);
                break;
            }
            case 10: {
                object = this.listSpecial(UNQUOTE_SPLICING, pushbackReader, hashMap, n, n3, pair);
                break;
            }
            case 5: {
                object = this.listSpecial(QUOTESYM, pushbackReader, hashMap, n, n3 & 0xFFFFFFFD, pair);
                break;
            }
            case 9: {
                object = this.listSpecial(BACKQUOTE, pushbackReader, hashMap, n, n3, pair);
                break;
            }
            case 0: {
                object = this.lexer.nval;
                break;
            }
            case 1: {
                object = new ImmutableString(this.lexer.sval);
                break;
            }
            case 2: {
                Object object2;
                if (pushbackReader instanceof SourceReader) {
                    object2 = (SourceReader)pushbackReader;
                    n4 = ((SourceReader)object2).line;
                    n5 = ((SourceReader)object2).column - 1;
                    string = ((SourceReader)object2).sourceFile;
                }
                if (this.annotate && this.produceAnnotations(n3) && n4 >= 0) {
                    object2 = new AnnotatedExpr(null, Parser.sourceAnnotations(string, n4, n5, pair));
                    if (n != null) {
                        hashMap.put(n, object2);
                        n = null;
                    }
                    ((AnnotatedExpr)object2).expr = this.readList(pushbackReader, hashMap, n, n3, pair);
                    return object2;
                }
                return this.readList(pushbackReader, hashMap, n, n3, pair);
            }
            case 4: {
                object = ENDPAIR;
                break;
            }
            case 12: {
                Symbol symbol = Symbol.intern(this.lexer.readToBreak(pushbackReader, Lexer.protected_literal_barrier, true, true));
                this.lexer.readChar(pushbackReader);
                return symbol;
            }
            case 3: {
                if (this.lexer.strictR5RS && !Parser.isPeculiarIdentifier(this.lexer.sval) && this.lexer.sval.length() >= 1 && !Character.isLetter(this.lexer.sval.charAt(0)) && !Lexer.in(this.lexer.sval.charAt(0), Lexer.special_initials)) {
                    this.potentialError(n3, "invalididentifier", this.lexer.sval, pushbackReader);
                }
                object = Symbol.get(this.lexer.sval, this.caseSensitive(n3));
                break;
            }
            case 8: {
                Object object3;
                Serializable serializable;
                int n7 = pushbackReader.read();
                char c = Character.toLowerCase((char)n7);
                switch (c) {
                    case 't': {
                        object = TRUE;
                        break block1;
                    }
                    case 'f': {
                        object = FALSE;
                        break block1;
                    }
                    case ';': {
                        this.nextExpression(pushbackReader);
                        object = this._nextExpression(pushbackReader, hashMap, n, n3, pair);
                        break block1;
                    }
                    case '\\': {
                        n7 = pushbackReader.read();
                        if (Lexer.in((char)n7, Lexer.special)) {
                            object = new SchemeCharacter((char)n7);
                            break block1;
                        }
                        pushbackReader.unread(n7);
                        String string2 = this.lexer.readToBreak(pushbackReader, Lexer.special, false, false);
                        String string3 = string2.toLowerCase();
                        SchemeCharacter schemeCharacter = CharUtil.namedConstToChar(string3);
                        try {
                            if (schemeCharacter != null) {
                                object = schemeCharacter;
                                break block1;
                            }
                            if (string2.length() == 1) {
                                object = new SchemeCharacter(string2.charAt(0));
                                break block1;
                            }
                            if (string2.charAt(0) == 'u') {
                                object = new SchemeCharacter(CharUtil.hexToChar(string3.substring(1)));
                                break block1;
                            }
                            object = new SchemeCharacter(CharUtil.octToChar(string3));
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.potentialError(n3, "invalidcharconst", pushbackReader);
                            object = new SchemeCharacter('\u0000');
                        }
                        break block1;
                    }
                    case 'b': {
                        object = this.numberCheck(this._nextExpression(pushbackReader, hashMap, null, 2, n3, pair), pushbackReader, n3);
                        break block1;
                    }
                    case 'o': {
                        object = this.numberCheck(this._nextExpression(pushbackReader, hashMap, null, 8, n3, pair), pushbackReader, n3);
                        break block1;
                    }
                    case 'x': {
                        object = this.numberCheck(this._nextExpression(pushbackReader, hashMap, null, 16, n3, pair), pushbackReader, n3);
                        break block1;
                    }
                    case 'd': {
                        object = this.numberCheck(this._nextExpression(pushbackReader, hashMap, null, n3, pair), pushbackReader, n3);
                        break block1;
                    }
                    case '&': {
                        object = new Box();
                        if (n != null) {
                            hashMap.put(n, object);
                        }
                        ((Box)object).val = (Value)this._nextExpression(pushbackReader, hashMap, null, n3, pair);
                        break block1;
                    }
                    case 'i': {
                        object = this.numberCheck(this._nextExpression(pushbackReader, hashMap, null, n2, n3, pair), pushbackReader, n3).toInexact();
                        break block1;
                    }
                    case 'e': {
                        object = this.numberCheck(this._nextExpression(pushbackReader, hashMap, null, n2, n3, pair), pushbackReader, n3).toExact();
                        break block1;
                    }
                    case '!': {
                        String string4 = this.lexer.readToBreak(pushbackReader, Lexer.special, false, false);
                        if (string4.equals("eof")) {
                            object = EOF;
                            break block1;
                        }
                        if (string4.equals("void")) {
                            object = VOID;
                            break block1;
                        }
                        if (string4.equals("+inf")) {
                            object = Quantity.POSITIVE_INFINITY;
                            break block1;
                        }
                        if (string4.equals("-inf")) {
                            object = Quantity.NEGATIVE_INFINITY;
                            break block1;
                        }
                        if (string4.equals("nan")) {
                            object = Quantity.NaN;
                            break block1;
                        }
                        this.potentialError(n3, "invalidsharpc", string4, pushbackReader);
                        object = VOID;
                        break block1;
                    }
                    case '%': {
                        String string5 = this.lexer.readToBreak(pushbackReader, Lexer.special, false, false).toLowerCase();
                        Syntax syntax = (Syntax)CompilerConstants.SYNTACTIC_TOKENS.get(string5);
                        if (syntax == null) {
                            this.potentialError(n3, "invalidsyntoken", string5, pushbackReader);
                            syntax = (Syntax)CompilerConstants.SYNTACTIC_TOKENS.get("unknown");
                        }
                        object = syntax;
                        break block1;
                    }
                    case '\'': {
                        object = this.listSpecial(SYNTAX, pushbackReader, hashMap, n, n3, pair);
                        break block1;
                    }
                    case '@': {
                        Pair pair2 = (Pair)this.nextExpression(pushbackReader, hashMap, n3, pair);
                        object = new AnnotatedExpr(pair2.cdr(), pair2.car());
                        break block1;
                    }
                    case '|': {
                        this.lexer.skipMultilineComment(pushbackReader);
                        return this._nextExpression(pushbackReader, hashMap, n, n2, n3, pair);
                    }
                }
                Value[] valueArray = null;
                pushbackReader.unread(n7);
                if (Character.isDigit((char)n7)) {
                    serializable = new Integer(Integer.parseInt(this.lexer.readToBreak(pushbackReader, Lexer.sharp_special, false, false)));
                    n7 = pushbackReader.read();
                    if (n7 == 61) {
                        object = this._nextExpression(pushbackReader, hashMap, (Integer)serializable, n3, pair);
                        break;
                    }
                    if (n7 == 35) {
                        object = hashMap.get(serializable);
                        break;
                    }
                    pushbackReader.unread(n7);
                    valueArray = new Value[((Integer)serializable).intValue()];
                }
                serializable = this.produceImmutables(n3) ? new ImmutableVector() : new SchemeVector();
                object = serializable;
                if (n != null) {
                    hashMap.put(n, serializable);
                }
                if ((object3 = this._nextExpression(pushbackReader, hashMap, n = null, n3 | 0x10, pair)) instanceof AnnotatedExpr) {
                    object = new AnnotatedExpr((Expression)serializable, ((AnnotatedExpr)object3).annotation);
                    object3 = ((AnnotatedExpr)object3).expr;
                }
                if (object3 == null && valueArray == null) {
                    ((SchemeVector)serializable).vals = ZV;
                    break;
                }
                if (object3 instanceof Pair) {
                    if (valueArray == null) {
                        valueArray = new Value[Parser.length((Pair)object3)];
                    } else if (valueArray.length < Parser.length((Pair)object3)) {
                        this.warn("veclengthtooshort", pushbackReader);
                        valueArray = new Value[Parser.length((Pair)object3)];
                    }
                } else if (object3 != null) {
                    throw new IOException(Parser.liMessage(SISCB, "invalidsharp", object3.toString()));
                }
                Pair pair3 = (Pair)object3;
                Value value = Quantity.ZERO;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (pair3 != EMPTYLIST) {
                        value = pair3.car();
                        pair3 = (Pair)pair3.cdr();
                    }
                    valueArray[i] = this.lastValue(hashMap, value);
                }
                ((SchemeVector)serializable).vals = valueArray;
                break;
            }
            default: {
                this.potentialError(n3, "unknowntoken", pushbackReader);
                object = VOID;
            }
        }
        if (n != null) {
            hashMap.put(n, object);
        }
        return object;
    }

    private Value readAfterDot(PushbackReader pushbackReader, HashMap hashMap, int n, Pair pair) throws IOException {
        Value value;
        block4: {
            Object object = this._nextExpression(pushbackReader, hashMap, null, n, pair);
            value = VOID;
            try {
                value = this.lastValue(hashMap, object);
            }
            catch (ClassCastException classCastException) {
                this.potentialError(n, "expectedexprincdr", pushbackReader);
                if (object != ENDPAIR) break block4;
                return EMPTYLIST;
            }
        }
        if (this._nextExpression(pushbackReader, hashMap, null, n, pair) == ENDPAIR) {
            return value;
        }
        this.potentialError(n, "toomanyafterdot", pushbackReader);
        while (this._nextExpression(pushbackReader, hashMap, null, n, pair) != ENDPAIR) {
        }
        return value;
    }

    public Value readList(PushbackReader pushbackReader, HashMap hashMap, Integer n, int n2, Pair pair) throws IOException {
        Pair pair2 = null;
        Pair pair3 = null;
        boolean bl = this.readingVector(n2);
        boolean bl2 = this.produceImmutables(n2);
        n2 &= 0xFFFFFFEF;
        try {
            Object object = this._nextExpression(pushbackReader, hashMap, null, n2, pair);
            if (object == ENDPAIR) {
                return EMPTYLIST;
            }
            Value value = VOID;
            try {
                value = this.lastValue(hashMap, object);
            }
            catch (ClassCastException classCastException) {
                this.potentialError(n2, "expectedexprincar", pushbackReader);
            }
            pair3 = bl2 ? new ImmutablePair(value, EMPTYLIST, false) : new Pair(value, EMPTYLIST);
            pair2 = pair3;
            if (n != null) {
                hashMap.put(n, pair3);
            }
            while ((object = this._nextExpression(pushbackReader, hashMap, null, n2, pair)) != ENDPAIR) {
                if (object == DOT) {
                    if (bl) {
                        this.potentialError(n2, "dotwhenreadingvector", pushbackReader);
                    }
                    pair3.setCdr(this.readAfterDot(pushbackReader, hashMap, n2, pair));
                    if (!bl2) break;
                    ((ImmutablePair)pair3).makeImmutable();
                    break;
                }
                try {
                    value = this.lastValue(hashMap, object);
                }
                catch (ClassCastException classCastException) {
                    this.potentialError(n2, "expectedexprincar", pushbackReader);
                    value = VOID;
                }
                Pair pair4 = bl2 ? new ImmutablePair(value, EMPTYLIST, false) : new Pair(value, EMPTYLIST);
                pair3.setCdr(pair4);
                if (bl2) {
                    ((ImmutablePair)pair3).makeImmutable();
                }
                pair3 = pair4;
            }
            if (bl2) {
                ((ImmutablePair)pair3).makeImmutable();
            }
        }
        catch (EOFException eOFException) {
            this.potentialError(n2, "unexpectedeof", pushbackReader);
            return VOID;
        }
        return pair2;
    }

    protected final boolean caseSensitive(int n) {
        return (n & 8) != 0;
    }

    protected final boolean produceAnnotations(int n) {
        return (n & 2) != 0;
    }

    protected final boolean produceImmutables(int n) {
        return (n & 1) != 0;
    }

    protected final boolean readingVector(int n) {
        return (n & 0x10) != 0;
    }

    protected final boolean permissiveParsing(int n) {
        return (n & 0x20) != 0;
    }

    public static void main(String[] stringArray) throws Exception {
        Value value;
        Parser parser = new Parser(new Lexer());
        PushbackReader pushbackReader = new PushbackReader(new InputStreamReader(System.in));
        while (EOF != (value = parser.nextExpression(pushbackReader, 32, EMPTYLIST))) {
            System.err.println(value);
        }
    }

    static {
        chars.put("space", new SchemeCharacter(' '));
        chars.put("backspace", new SchemeCharacter('\b'));
        chars.put("rubout", new SchemeCharacter('\u007f'));
        chars.put("page", new SchemeCharacter('\f'));
        chars.put("tab", new SchemeCharacter('\t'));
        chars.put("return", new SchemeCharacter('\r'));
        chars.put("newline", new SchemeCharacter('\n'));
        chars.put("nul", new SchemeCharacter('\u0000'));
    }
}

