/*
 * Decompiled with CFR 0.152.
 */
package sisc.reader;

import java.io.EOFException;
import java.io.IOException;
import java.io.PushbackReader;
import sisc.data.Pair;
import sisc.data.Quantity;
import sisc.reader.CharUtil;
import sisc.reader.Tokens;
import sisc.util.Defaults;
import sisc.util.Util;

public class Lexer
implements Tokens {
    static final char STRING_CONST = '\"';
    static final char COMMENT = ';';
    static final char LIST_OPEN_ALT = '[';
    static final char LIST_CLOSE_ALT = ']';
    static final char LIST_OPEN = '(';
    static final char LIST_CLOSE = ')';
    static final char SHARP = '#';
    static final char QUOTE = '\'';
    static final char BACKQUOTE = '`';
    static final char UNQUOTE = ',';
    static final char UNQUOTE_SPLICING = '@';
    static final char DOT = '.';
    static final char PIPE = '|';
    public static final char[] special = new char[]{'\t', '\n', '\r', ' ', '\"', '(', ')', ';', '[', ']'};
    public static final char[] sharp_special = new char[]{'\t', '\n', ' ', '\"', '#', '(', ')', '=', '[', ']'};
    public static final char[] number_prefixes = new char[]{'+', '-', '.'};
    public static final char[] hex_number_prefixes = new char[]{'+', '-', '.', 'A', 'B', 'C', 'D', 'E', 'F', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final char[] reserved = new char[]{'[', ']', '{', '|', '}'};
    public static final char[] special_and_reserved = new char[]{'\t', '\n', '\r', ' ', '\"', '(', ')', ';', '[', ']', '{', '|', '}'};
    public static final char[] special_initials = new char[]{'!', '$', '%', '&', '*', '/', ':', '<', '=', '>', '?', '^', '_', '~'};
    public static final char[] special_subsequents = new char[]{'+', '-', '.', '@'};
    public static final char[] protected_literal_barrier = new char[]{'|'};
    public static final char[] unprintable_characters = new char[0];
    public boolean strictR5RS = Defaults.STRICT_R5RS;
    public String sval;
    public Quantity nval;
    public Pair prval;

    public static final boolean isIdentifierStart(char c) {
        return Character.isLetter(c) || Lexer.in(c, special_initials);
    }

    public static final boolean isIdentifierSubsequent(char c) {
        return Lexer.isIdentifierStart(c) || Character.isDigit(c) || Lexer.in(c, special_subsequents);
    }

    public static final boolean isPrintable(char c) {
        return c >= ' ' && c <= '~' && !Lexer.in(c, unprintable_characters);
    }

    public int readIgnoringWhitespace(PushbackReader pushbackReader) throws IOException {
        char c = '\u0000';
        while (Character.isWhitespace(c = (char)this.readChar(pushbackReader))) {
        }
        return c;
    }

    public int nextToken(PushbackReader pushbackReader, int n) throws IOException {
        int n2 = this._nextToken(pushbackReader, n);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int _nextToken(PushbackReader pushbackReader, int n) throws IOException {
        PushbackReader pushbackReader2 = pushbackReader;
        synchronized (pushbackReader2) {
            int n2 = this.readIgnoringWhitespace(pushbackReader);
            switch (n2) {
                case 40: 
                case 91: {
                    return 2;
                }
                case 41: 
                case 93: {
                    return 4;
                }
                case 124: {
                    return 12;
                }
                case 39: {
                    return 5;
                }
                case 35: {
                    return 8;
                }
                case 34: {
                    this.sval = this.readToEndOfString(pushbackReader);
                    return 1;
                }
                case 59: {
                    while (this.readChar(pushbackReader, false, false, false) != 10) {
                    }
                    return this.nextToken(pushbackReader, n);
                }
                case 96: {
                    return 9;
                }
                case 44: {
                    int n3 = this.readChar(pushbackReader);
                    if (n3 == 64) {
                        return 10;
                    }
                    pushbackReader.unread(n3);
                    return 7;
                }
            }
            pushbackReader.unread(n2);
            String string = this.readToBreak(pushbackReader, special, true, false);
            if (n2 == 92) {
                string = "\\" + string;
            }
            Object object = string;
            if (Lexer.numberStart(string.charAt(0), n)) {
                object = Lexer.readNum(string, n);
            }
            if (object instanceof String) {
                this.sval = (String)object;
                if (this.sval.length() == 1 && this.sval.charAt(0) == '.') {
                    return 6;
                }
                return 3;
            }
            this.nval = (Quantity)object;
            return 0;
        }
    }

    static Object readNum(String string, int n) {
        try {
            Quantity quantity = Quantity.valueOf(string, n);
            return quantity;
        }
        catch (NumberFormatException numberFormatException) {
            return string;
        }
    }

    public int readChar(PushbackReader pushbackReader) throws IOException {
        return this.readChar(pushbackReader, true, false, true);
    }

    public int readPureChar(PushbackReader pushbackReader) throws IOException {
        return this.readChar(pushbackReader, true, false, false);
    }

    public int readChar(PushbackReader pushbackReader, boolean bl, boolean bl2, boolean bl3) throws IOException {
        int n = pushbackReader.read();
        if (n == -1) {
            throw new EOFException();
        }
        if (this.strictR5RS && bl3 && Lexer.in((char)n, reserved)) {
            throw new IOException(Util.liMessage(Util.SISCB, "reservedchar", new String(new char[]{(char)n})));
        }
        if (!bl || n != 92) {
            return n;
        }
        int n2 = CharUtil.escapeSequenceToChar(pushbackReader);
        return bl2 ? -n2 : n2;
    }

    public String readToEndOfString(PushbackReader pushbackReader) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.readPureChar(pushbackReader)) != 34) {
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    public String readToBreak(PushbackReader pushbackReader, char[] cArray, boolean bl, boolean bl2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            boolean bl3;
            char c;
            while (!Lexer.in(c = (bl3 = (n = this.readChar(pushbackReader, bl, true, true)) < 0) ? (char)(-n) : (char)n, cArray) || bl2 && bl3) {
                stringBuffer.append(c);
            }
            pushbackReader.unread(c);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public static boolean numberStart(char c, int n) {
        return Character.isDigit(c) || Lexer.in(c, n == 16 ? hex_number_prefixes : number_prefixes);
    }

    public static boolean in(char c, char[] cArray) {
        for (int i = cArray.length - 1; i > -1; --i) {
            if (c > cArray[i]) {
                return false;
            }
            if (c != cArray[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(String string, char[] cArray) {
        for (int i = 0; i < string.length(); ++i) {
            if (!Lexer.in(string.charAt(i), cArray)) continue;
            return true;
        }
        return false;
    }

    public void skipMultilineComment(PushbackReader pushbackReader) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        try {
            do {
                switch (this.readChar(pushbackReader)) {
                    case 124: {
                        if (bl) {
                            bl = false;
                            ++n;
                            break;
                        }
                        bl2 = true;
                        break;
                    }
                    case 35: {
                        if (bl2) {
                            bl2 = false;
                            --n;
                            break;
                        }
                        bl = true;
                        break;
                    }
                    default: {
                        bl = false;
                        bl2 = false;
                    }
                }
            } while (n >= 0);
        }
        catch (EOFException eOFException) {
            System.err.println(Util.warn("eofbeforeeoc"));
            throw eOFException;
        }
    }
}

