/*
 * Decompiled with CFR 0.152.
 */
package sisc.modules.io;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import sisc.data.SchemeCharacterInputPort;
import sisc.data.SchemeCharacterOutputPort;
import sisc.data.SchemeString;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.interpreter.ContinuationException;
import sisc.io.OutputPort;
import sisc.nativefun.IndexedFixableProcedure;
import sisc.nativefun.IndexedLibraryAdapter;
import sisc.reader.SourceReader;

public class StringIO
extends IndexedFixableProcedure {
    static Symbol IOB = Symbol.intern("sisc.modules.io.Messages");
    protected static final int GETOUTPUTSTRING = 0;
    protected static final int OPENINPUTSTRING = 1;
    protected static final int OPENSOURCEINPUTSTRING = 2;
    protected static final int OPENOUTPUTSTRING = 3;
    protected static final int STRINGINPORTQ = 4;
    protected static final int STRINGOUTPORTQ = 5;

    public StringIO(int n) {
        super(n);
    }

    public StringIO() {
    }

    public Value apply() throws ContinuationException {
        switch (this.id) {
            case 3: {
                return new SchemeCharacterOutputPort(new StringWriter());
            }
        }
        StringIO.throwArgSizeException();
        return VOID;
    }

    public Value apply(Value value) throws ContinuationException {
        switch (this.id) {
            case 4: {
                return StringIO.truth(value instanceof SchemeCharacterInputPort && ((SchemeCharacterInputPort)value).getReader() instanceof StringReader);
            }
            case 5: {
                return StringIO.truth(value instanceof SchemeCharacterOutputPort && ((SchemeCharacterOutputPort)value).getWriter() instanceof StringWriter);
            }
            case 0: {
                OutputPort outputPort = StringIO.outport(value);
                if (!(outputPort instanceof SchemeCharacterOutputPort) || !(((SchemeCharacterOutputPort)outputPort).getWriter() instanceof StringWriter)) {
                    StringIO.throwPrimException(StringIO.liMessage(IOB, "outputnotastringport"));
                }
                try {
                    outputPort.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                StringWriter stringWriter = (StringWriter)((SchemeCharacterOutputPort)outputPort).getWriter();
                SchemeString schemeString = new SchemeString(stringWriter.getBuffer().toString());
                stringWriter.getBuffer().setLength(0);
                return schemeString;
            }
            case 1: {
                return new SchemeCharacterInputPort(new PushbackReader(new StringReader(StringIO.string(value))));
            }
            case 2: {
                return new SchemeCharacterInputPort(new SourceReader((Reader)new StringReader(StringIO.string(value)), "<string>"));
            }
        }
        StringIO.throwArgSizeException();
        return VOID;
    }

    public static class Index
    extends IndexedLibraryAdapter {
        public Value construct(Object object, int n) {
            return new StringIO(n);
        }

        public Index() {
            this.define("get-output-string", 0);
            this.define("open-input-string", 1);
            this.define("open-output-string", 3);
            this.define("open-source-input-string", 2);
            this.define("string-input-port?", 4);
            this.define("string-output-port?", 5);
        }
    }
}

