/*
 * Decompiled with CFR 0.152.
 */
package sisc.modules.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Enumeration;
import sisc.data.Pair;
import sisc.data.Quantity;
import sisc.data.SchemeBinaryInputPort;
import sisc.data.SchemeBinaryOutputPort;
import sisc.data.SchemeCharacter;
import sisc.data.SchemeCharacterInputPort;
import sisc.data.SchemeCharacterOutputPort;
import sisc.data.SchemeString;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.exprs.AnnotatedExpr;
import sisc.interpreter.Context;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.interpreter.SchemeException;
import sisc.io.AutoflushOutputStream;
import sisc.io.AutoflushWriter;
import sisc.io.Charset;
import sisc.io.InputPort;
import sisc.io.OutputPort;
import sisc.io.Port;
import sisc.io.PortValueWriter;
import sisc.io.SharedValueWriter;
import sisc.nativefun.IndexedLibraryAdapter;
import sisc.nativefun.IndexedProcedure;
import sisc.reader.SourceReader;
import sisc.util.Util;

public class IO
extends IndexedProcedure {
    public static Symbol IOB = Symbol.intern("sisc.modules.io.Messages");
    protected static final int ABSPATHQ = 0;
    protected static final int CHARREADY = 3;
    protected static final int CLOSEINPUTPORT = 4;
    protected static final int CLOSEOUTPUTPORT = 5;
    protected static final int DISPLAY = 8;
    protected static final int FILEEXISTSQ = 9;
    protected static final int FINDRESOURCE = 6;
    protected static final int FINDRESOURCES = 2;
    protected static final int FLUSHOUTPUTPORT = 10;
    protected static final int INPORTQ = 12;
    protected static final int INPORTLOCATION = 13;
    protected static final int LOAD = 14;
    protected static final int LOADEXPANDED = 24;
    protected static final int MAKEPATH = 15;
    protected static final int NORMALIZEURL = 16;
    protected static final int OPENAUTOFLUSHSTREAM = 35;
    protected static final int OPENAUTOFLUSHWRITER = 36;
    protected static final int OPENBUFFEREDCHARINPORT = 32;
    protected static final int OPENBUFFEREDCHAROUTPORT = 33;
    protected static final int OPENCHARINPUTPORT = 31;
    protected static final int OPENCHAROUTPUTPORT = 34;
    protected static final int OPENINPUTFILE = 17;
    protected static final int OPENOUTPUTFILE = 19;
    protected static final int OPENSOURCEINPUTFILE = 20;
    protected static final int OUTPORTQ = 22;
    protected static final int PEEKBYTE = 30;
    protected static final int PEEKCHAR = 23;
    protected static final int PORTQ = 27;
    protected static final int READ = 21;
    protected static final int READBYTE = 29;
    protected static final int READCHAR = 18;
    protected static final int READSTRING = 25;
    protected static final int READCODE = 11;
    protected static final int WRITE = 1;
    protected static final int WRITEBYTE = 28;
    protected static final int WRITECHAR = 7;
    protected static final int WRITESTRING = 26;

    public IO(int n) {
        super(n);
    }

    public IO() {
    }

    public static void throwIOException(Interpreter interpreter, String string, IOException iOException) throws ContinuationException {
        if (interpreter.acc == null) {
            IO.error(interpreter, string, IO.list(new Pair(JEXCEPTION, IO.javaWrap(iOException))));
        } else if (interpreter.acc.getName() != null) {
            IO.error(interpreter, (Value)interpreter.acc.getName(), string, IO.list(new Pair(JEXCEPTION, IO.javaWrap(iOException))));
        } else {
            IO.error(interpreter, string, IO.list(new Pair(JEXCEPTION, IO.javaWrap(iOException))));
        }
    }

    private static void maybeThrowErrorWithExprLocation(SchemeException schemeException, Value value) {
        if (!(value instanceof AnnotatedExpr)) {
            return;
        }
        AnnotatedExpr annotatedExpr = (AnnotatedExpr)value;
        if (!(annotatedExpr.annotation instanceof Pair)) {
            return;
        }
        Pair pair = (Pair)annotatedExpr.annotation;
        Value value2 = IO.assq(SOURCE_FILE, pair);
        Value value3 = IO.assq(SOURCE_LINE, pair);
        Value value4 = IO.assq(SOURCE_COLUMN, pair);
        if (value2 == FALSE || value3 == FALSE || value4 == FALSE) {
            return;
        }
        IO.throwNestedPrimException(IO.liMessage(IOB, "evalat", IO.string(IO.pair(value2).cdr()), IO.num(IO.pair(value3).cdr()).intValue(), IO.num(IO.pair(value4).cdr()).intValue()), schemeException);
    }

    private static Value readChar(Interpreter interpreter, SchemeCharacterInputPort schemeCharacterInputPort) throws ContinuationException {
        try {
            int n = schemeCharacterInputPort.getReader().read();
            if (n == -1) {
                return EOF;
            }
            return new SchemeCharacter((char)n);
        }
        catch (IOException iOException) {
            IO.throwIOException(interpreter, IO.liMessage(IOB, "errorreading", schemeCharacterInputPort.toString(), iOException.getMessage()), iOException);
            return null;
        }
    }

    private static Value peekChar(Interpreter interpreter, SchemeCharacterInputPort schemeCharacterInputPort) throws ContinuationException {
        try {
            PushbackReader pushbackReader = (PushbackReader)schemeCharacterInputPort.getReader();
            Value value = IO.readChar(interpreter, schemeCharacterInputPort);
            if (value instanceof SchemeCharacter) {
                try {
                    pushbackReader.unread(((SchemeCharacter)value).c);
                }
                catch (IOException iOException) {
                    IO.throwIOException(interpreter, IO.liMessage(IOB, "errorreading", schemeCharacterInputPort.toString()), iOException);
                }
            }
            return value;
        }
        catch (ClassCastException classCastException) {
            IO.throwPrimException(IO.liMessage(IOB, "peeknotsupported", schemeCharacterInputPort.toString()));
            return VOID;
        }
    }

    private static Value readByte(Interpreter interpreter, SchemeBinaryInputPort schemeBinaryInputPort) throws ContinuationException {
        try {
            int n = schemeBinaryInputPort.getInputStream().read();
            if (n == -1) {
                return EOF;
            }
            return Quantity.valueOf(n);
        }
        catch (IOException iOException) {
            IO.throwIOException(interpreter, IO.liMessage(IOB, "errorreading", schemeBinaryInputPort.toString(), iOException.getMessage()), iOException);
            return null;
        }
    }

    private static Value peekByte(Interpreter interpreter, SchemeBinaryInputPort schemeBinaryInputPort) throws ContinuationException {
        try {
            PushbackInputStream pushbackInputStream = (PushbackInputStream)schemeBinaryInputPort.getInputStream();
            Value value = IO.readByte(interpreter, schemeBinaryInputPort);
            if (value instanceof Quantity) {
                try {
                    pushbackInputStream.unread(((Quantity)value).indexValue());
                }
                catch (IOException iOException) {
                    IO.throwIOException(interpreter, IO.liMessage(IOB, "errorreading", schemeBinaryInputPort.toString()), iOException);
                }
            }
            return value;
        }
        catch (ClassCastException classCastException) {
            IO.throwPrimException(IO.liMessage(IOB, "peeknotsupported", schemeBinaryInputPort.toString()));
            return VOID;
        }
    }

    private static Value read(Interpreter interpreter, SchemeCharacterInputPort schemeCharacterInputPort, int n) throws ContinuationException {
        try {
            return interpreter.dynenv.parser.nextExpression((PushbackReader)schemeCharacterInputPort.getReader(), n, interpreter.dynenv.sourceAnnotations);
        }
        catch (EOFException eOFException) {
            return EOF;
        }
        catch (IOException iOException) {
            IO.throwIOException(interpreter, IO.liMessage(IOB, "errorreading", schemeCharacterInputPort.toString(), iOException.getMessage()), iOException);
        }
        catch (ClassCastException classCastException) {
            IO.throwPrimException(IO.liMessage(IOB, "peeknotsupported", schemeCharacterInputPort.toString()));
        }
        return null;
    }

    public static Value read(Interpreter interpreter, SchemeCharacterInputPort schemeCharacterInputPort) throws ContinuationException {
        return IO.read(interpreter, schemeCharacterInputPort, (interpreter.dynenv.caseSensitive ? 8 : 0) | (interpreter.dynenv.permissiveParsing ? 32 : 0));
    }

    public static Value readCode(Interpreter interpreter, SchemeCharacterInputPort schemeCharacterInputPort) throws ContinuationException {
        return IO.read(interpreter, schemeCharacterInputPort, 3 | (interpreter.dynenv.caseSensitive ? 8 : 0) | (interpreter.dynenv.permissiveParsing ? 32 : 0));
    }

    public Value displayOrWrite(Interpreter interpreter, SchemeCharacterOutputPort schemeCharacterOutputPort, Value value, boolean bl) throws ContinuationException {
        try {
            PortValueWriter portValueWriter;
            PortValueWriter portValueWriter2 = portValueWriter = interpreter.dynenv.printShared ? new SharedValueWriter(schemeCharacterOutputPort.getWriter(), interpreter.dynenv.vectorLengthPrefixing, interpreter.dynenv.caseSensitive) : new PortValueWriter(schemeCharacterOutputPort.getWriter(), interpreter.dynenv.vectorLengthPrefixing, interpreter.dynenv.caseSensitive);
            if (bl) {
                portValueWriter.display(value);
            } else {
                portValueWriter.write(value);
            }
        }
        catch (IOException iOException) {
            IO.throwIOException(interpreter, IO.liMessage(IOB, "errorwriting", schemeCharacterOutputPort.toString(), iOException.getMessage()), iOException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return VOID;
    }

    public static URL urlClean(URL uRL) {
        if (uRL.getProtocol().equals("file") && (uRL.getRef() != null || uRL.getQuery() != null)) {
            StringBuffer stringBuffer = new StringBuffer(uRL.getProtocol());
            stringBuffer.append(':');
            stringBuffer.append(uRL.getPath());
            if (uRL.getRef() != null) {
                stringBuffer.append("%23");
                stringBuffer.append(URLEncoder.encode(uRL.getRef()));
            }
            if (uRL.getQuery() != null) {
                stringBuffer.append("%3F");
                stringBuffer.append(URLEncoder.encode(uRL.getQuery()));
            }
            try {
                uRL = new URL(stringBuffer.toString());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return uRL;
    }

    public static SchemeCharacterInputPort openCharInFile(Interpreter interpreter, URL uRL, Charset charset) throws ContinuationException {
        try {
            return new SchemeCharacterInputPort(new SourceReader((Reader)new BufferedReader(charset.newInputStreamReader(IO.getURLInputStream(uRL))), uRL.toString()));
        }
        catch (IOException iOException) {
            IO.throwIOException(interpreter, IO.liMessage(IOB, "erroropening", uRL.toString()), iOException);
            return null;
        }
    }

    public static SchemeCharacterOutputPort openCharOutFile(Interpreter interpreter, URL uRL, Charset charset, boolean bl) throws ContinuationException {
        try {
            Writer writer = new OutputStreamWriter(IO.getURLOutputStream(uRL), charset.getName());
            if (bl) {
                System.err.println(IO.warn("autoflushdeprecated"));
                writer = new AutoflushWriter(writer);
            }
            return new SchemeCharacterOutputPort(writer);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            IO.throwIOException(interpreter, IO.liMessage(IOB, "erroropening", uRL.toString()), iOException);
            return null;
        }
    }

    public static InputStream getURLInputStream(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoInput(true);
        uRLConnection.setDoOutput(false);
        return uRLConnection.getInputStream();
    }

    public static OutputStream getURLOutputStream(URL uRL) throws IOException {
        if (uRL.getProtocol().equals("file")) {
            return new FileOutputStream(uRL.getPath());
        }
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoInput(false);
        uRLConnection.setDoOutput(true);
        return uRLConnection.getOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(Interpreter interpreter, URL uRL, boolean bl) throws ContinuationException {
        Object object;
        SchemeCharacterInputPort schemeCharacterInputPort = null;
        SourceReader sourceReader = null;
        try {
            object = uRL.openConnection();
            ((URLConnection)object).setDoInput(true);
            ((URLConnection)object).setDoOutput(false);
            sourceReader = new SourceReader((Reader)new InputStreamReader(((URLConnection)object).getInputStream(), Util.charsetFromString(((URLConnection)object).getContentEncoding()).getName()), uRL.toString());
            schemeCharacterInputPort = new SchemeCharacterInputPort(sourceReader);
        }
        catch (IOException iOException) {
            IO.throwIOException(interpreter, IO.liMessage(IOB, "erroropening", uRL.toString()), iOException);
        }
        object = Context.enter(interpreter.dynenv);
        try {
            Value value = null;
            do {
                int n = sourceReader.line;
                int n2 = sourceReader.column;
                value = IO.readCode(interpreter, schemeCharacterInputPort);
                if (value == EOF) continue;
                try {
                    if (bl) {
                        ((Interpreter)object).interpret(((Interpreter)object).compile(value));
                        continue;
                    }
                    ((Interpreter)object).eval(value, interpreter.tpl);
                }
                catch (SchemeException schemeException) {
                    IO.maybeThrowErrorWithExprLocation(schemeException, value);
                    IO.throwNestedPrimException(IO.liMessage(IOB, "evalat", sourceReader.sourceFile, n, n2), schemeException);
                }
            } while (value != EOF);
        }
        finally {
            Context.exit();
        }
    }

    public Value doApply(Interpreter interpreter) throws ContinuationException {
        switch (interpreter.vlr.length) {
            case 0: {
                switch (this.id) {
                    case 3: {
                        try {
                            return IO.truth(interpreter.dynenv.getCurrentInReader().ready());
                        }
                        catch (IOException iOException) {
                            return FALSE;
                        }
                    }
                    case 10: {
                        try {
                            interpreter.dynenv.getCurrentOutWriter().flush();
                        }
                        catch (IOException iOException) {
                            IO.throwIOException(interpreter, IO.liMessage(IOB, "errorflushing", interpreter.dynenv.out.toString()), iOException);
                        }
                        return VOID;
                    }
                    case 23: {
                        return IO.peekChar(interpreter, IO.charinport(interpreter.dynenv.getCurrentInPort()));
                    }
                    case 30: {
                        return IO.peekByte(interpreter, IO.bininport(interpreter.dynenv.getCurrentInPort()));
                    }
                    case 21: {
                        return IO.read(interpreter, IO.charinport(interpreter.dynenv.getCurrentInPort()));
                    }
                    case 29: {
                        return IO.readByte(interpreter, IO.bininport(interpreter.dynenv.getCurrentInPort()));
                    }
                    case 18: {
                        return IO.readChar(interpreter, IO.charinport(interpreter.dynenv.getCurrentInPort()));
                    }
                    case 11: {
                        return IO.readCode(interpreter, IO.charinport(interpreter.dynenv.getCurrentInPort()));
                    }
                }
                IO.throwArgSizeException();
            }
            case 1: {
                switch (this.id) {
                    case 27: {
                        return IO.truth(interpreter.vlr[0] instanceof Port);
                    }
                    case 12: {
                        return IO.truth(interpreter.vlr[0] instanceof InputPort);
                    }
                    case 22: {
                        return IO.truth(interpreter.vlr[0] instanceof OutputPort);
                    }
                    case 3: {
                        SchemeCharacterInputPort schemeCharacterInputPort = IO.charinport(interpreter.vlr[0]);
                        try {
                            return IO.truth(schemeCharacterInputPort.ready());
                        }
                        catch (IOException iOException) {
                            return FALSE;
                        }
                    }
                    case 8: {
                        return this.displayOrWrite(interpreter, IO.charoutport(interpreter.dynenv.getCurrentOutPort()), interpreter.vlr[0], true);
                    }
                    case 1: {
                        return this.displayOrWrite(interpreter, IO.charoutport(interpreter.dynenv.getCurrentOutPort()), interpreter.vlr[0], false);
                    }
                    case 30: {
                        return IO.peekByte(interpreter, IO.bininport(interpreter.vlr[0]));
                    }
                    case 23: {
                        return IO.peekChar(interpreter, IO.charinport(interpreter.vlr[0]));
                    }
                    case 21: {
                        SchemeCharacterInputPort schemeCharacterInputPort = IO.charinport(interpreter.vlr[0]);
                        return IO.read(interpreter, schemeCharacterInputPort);
                    }
                    case 29: {
                        SchemeBinaryInputPort schemeBinaryInputPort = IO.bininport(interpreter.vlr[0]);
                        return IO.readByte(interpreter, schemeBinaryInputPort);
                    }
                    case 18: {
                        SchemeCharacterInputPort schemeCharacterInputPort = IO.charinport(interpreter.vlr[0]);
                        return IO.readChar(interpreter, schemeCharacterInputPort);
                    }
                    case 11: {
                        SchemeCharacterInputPort schemeCharacterInputPort = IO.charinport(interpreter.vlr[0]);
                        return IO.readCode(interpreter, schemeCharacterInputPort);
                    }
                    case 35: {
                        System.err.println(IO.warn("autoflushdeprecated"));
                        return new SchemeBinaryOutputPort(new AutoflushOutputStream(IO.binoutstream(interpreter.vlr[0])));
                    }
                    case 36: {
                        System.err.println(IO.warn("autoflushdeprecated"));
                        return new SchemeCharacterOutputPort(new AutoflushWriter(IO.charoutwriter(interpreter.vlr[0])));
                    }
                    case 31: {
                        return new SchemeCharacterInputPort(new PushbackReader(new BufferedReader(interpreter.dynenv.getCharacterSet().newInputStreamReader(IO.bininstream(interpreter.vlr[0])))));
                    }
                    case 34: {
                        return new SchemeCharacterOutputPort(new BufferedWriter(interpreter.dynenv.getCharacterSet().newOutputStreamWriter(IO.binoutstream(interpreter.vlr[0]))));
                    }
                    case 20: {
                        URL uRL = IO.url(interpreter.vlr[0]);
                        return IO.openCharInFile(interpreter, uRL, interpreter.dynenv.characterSet);
                    }
                    case 17: {
                        URL uRL = IO.url(interpreter.vlr[0]);
                        return IO.openCharInFile(interpreter, uRL, interpreter.dynenv.characterSet);
                    }
                    case 19: {
                        URL uRL = IO.url(interpreter.vlr[0]);
                        return IO.openCharOutFile(interpreter, uRL, interpreter.dynenv.characterSet, false);
                    }
                    case 32: {
                        return new SchemeCharacterInputPort(new BufferedReader(IO.charinreader(interpreter.vlr[0])));
                    }
                    case 33: {
                        return new SchemeCharacterOutputPort(new BufferedWriter(IO.charoutwriter(interpreter.vlr[0])));
                    }
                    case 10: {
                        OutputPort outputPort = IO.outport(interpreter.vlr[0]);
                        try {
                            outputPort.flush();
                        }
                        catch (IOException iOException) {
                            IO.throwIOException(interpreter, IO.liMessage(IOB, "errorflushing", outputPort.toString()), iOException);
                        }
                        return VOID;
                    }
                    case 4: {
                        InputPort inputPort = IO.inport(interpreter.vlr[0]);
                        try {
                            if (inputPort != interpreter.dynenv.in) {
                                inputPort.close();
                            }
                        }
                        catch (IOException iOException) {
                            IO.throwIOException(interpreter, IO.liMessage(IOB, "errorclosing", inputPort.toString()), iOException);
                        }
                        return VOID;
                    }
                    case 5: {
                        OutputPort outputPort = IO.outport(interpreter.vlr[0]);
                        try {
                            if (outputPort != interpreter.dynenv.out) {
                                outputPort.close();
                            }
                        }
                        catch (IOException iOException) {
                            IO.throwIOException(interpreter, IO.liMessage(IOB, "errorclosing", outputPort.toString()), iOException);
                        }
                        return VOID;
                    }
                    case 13: {
                        Reader reader = IO.charinreader(interpreter.vlr[0]);
                        if (reader instanceof SourceReader) {
                            SourceReader sourceReader = (SourceReader)reader;
                            return IO.sourceAnnotations(sourceReader.sourceFile, sourceReader.line, sourceReader.column, interpreter.dynenv.sourceAnnotations);
                        }
                        return FALSE;
                    }
                    case 14: {
                        IO.load(interpreter, IO.url(interpreter.vlr[0]), false);
                        return VOID;
                    }
                    case 24: {
                        IO.load(interpreter, IO.url(interpreter.vlr[0]), true);
                        return VOID;
                    }
                    case 7: {
                        try {
                            interpreter.dynenv.getCurrentOutWriter().write(IO.character(interpreter.vlr[0]));
                        }
                        catch (IOException iOException) {
                            IO.throwIOException(interpreter, IO.liMessage(IOB, "errorwriting", interpreter.dynenv.out.toString(), iOException.getMessage()), iOException);
                        }
                        return VOID;
                    }
                    case 28: {
                        try {
                            IO.binoutstream(interpreter.dynenv.getCurrentOutPort()).write(IO.num(interpreter.vlr[0]).indexValue());
                        }
                        catch (IOException iOException) {
                            IO.throwIOException(interpreter, IO.liMessage(IOB, "errorwriting", interpreter.dynenv.out.toString(), iOException.getMessage()), iOException);
                        }
                        return VOID;
                    }
                    case 9: {
                        try {
                            IO.url(interpreter.vlr[0]).openConnection().getInputStream().close();
                            return TRUE;
                        }
                        catch (IOException iOException) {
                            return FALSE;
                        }
                    }
                    case 6: {
                        URL uRL = Util.currentClassLoader().getResource(IO.string(interpreter.vlr[0]));
                        if (uRL == null) {
                            return FALSE;
                        }
                        return new SchemeString(uRL.toString());
                    }
                    case 2: {
                        Enumeration<URL> enumeration;
                        try {
                            enumeration = Util.currentClassLoader().getResources(IO.string(interpreter.vlr[0]));
                        }
                        catch (IOException iOException) {
                            return EMPTYLIST;
                        }
                        if (!enumeration.hasMoreElements()) {
                            return EMPTYLIST;
                        }
                        Pair pair = new Pair();
                        while (true) {
                            pair.setCar(new SchemeString((String)((Object)enumeration.nextElement())));
                            if (!enumeration.hasMoreElements()) break;
                            pair.setCdr(new Pair());
                            pair = (Pair)pair.cdr();
                        }
                        return pair;
                    }
                    case 0: {
                        String string = IO.string(interpreter.vlr[0]);
                        if (string.startsWith("file:")) {
                            string = string.substring(5);
                        }
                        File file = new File(string);
                        return IO.truth(file.isAbsolute());
                    }
                    case 16: {
                        URL uRL = IO.urlClean(IO.url(interpreter.vlr[0]));
                        return new SchemeString(uRL.toString());
                    }
                }
                IO.throwArgSizeException();
            }
            case 2: {
                switch (this.id) {
                    case 7: {
                        Writer writer = IO.charoutwriter(interpreter.vlr[1]);
                        try {
                            writer.write(IO.character(interpreter.vlr[0]));
                        }
                        catch (IOException iOException) {
                            IO.throwIOException(interpreter, IO.liMessage(IOB, "errorwriting", writer.toString(), iOException.getMessage()), iOException);
                        }
                        return VOID;
                    }
                    case 28: {
                        OutputStream outputStream = IO.binoutstream(interpreter.vlr[1]);
                        try {
                            outputStream.write(IO.num(interpreter.vlr[0]).indexValue());
                        }
                        catch (IOException iOException) {
                            IO.throwIOException(interpreter, IO.liMessage(IOB, "errorwriting", outputStream.toString(), iOException.getMessage()), iOException);
                        }
                        return VOID;
                    }
                    case 8: {
                        return this.displayOrWrite(interpreter, IO.charoutport(interpreter.vlr[1]), interpreter.vlr[0], true);
                    }
                    case 1: {
                        return this.displayOrWrite(interpreter, IO.charoutport(interpreter.vlr[1]), interpreter.vlr[0], false);
                    }
                    case 31: {
                        try {
                            return new SchemeCharacterInputPort(new PushbackReader(new BufferedReader(Charset.forName(IO.string(interpreter.vlr[1])).newInputStreamReader(IO.bininstream(interpreter.vlr[0])))));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            IO.throwIOException(interpreter, IO.liMessage(IOB, "unsupencoding", IO.string(interpreter.vlr[1])), new IOException(unsupportedEncodingException.getMessage()));
                        }
                    }
                    case 34: {
                        try {
                            return new SchemeCharacterOutputPort(new BufferedWriter(Charset.forName(IO.string(interpreter.vlr[1])).newOutputStreamWriter(IO.binoutstream(interpreter.vlr[0]))));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            IO.throwIOException(interpreter, IO.liMessage(IOB, "unsupencoding", IO.string(interpreter.vlr[1])), new IOException(unsupportedEncodingException.getMessage()));
                        }
                    }
                    case 17: {
                        URL uRL = IO.url(interpreter.vlr[0]);
                        return IO.openCharInFile(interpreter, uRL, Util.charsetFromString(IO.string(interpreter.vlr[1])));
                    }
                    case 19: {
                        URL uRL = IO.url(interpreter.vlr[0]);
                        boolean bl = false;
                        Charset charset = interpreter.dynenv.characterSet;
                        if (interpreter.vlr[1] instanceof SchemeString) {
                            charset = Util.charsetFromString(IO.string(interpreter.vlr[1]));
                        } else {
                            bl = IO.truth(interpreter.vlr[1]);
                        }
                        return IO.openCharOutFile(interpreter, uRL, charset, bl);
                    }
                    case 32: {
                        return new SchemeCharacterInputPort(new BufferedReader(IO.charinreader(interpreter.vlr[0]), IO.num(interpreter.vlr[1]).indexValue()));
                    }
                    case 33: {
                        return new SchemeCharacterOutputPort(new BufferedWriter(IO.charoutwriter(interpreter.vlr[0]), IO.num(interpreter.vlr[1]).indexValue()));
                    }
                    case 16: {
                        return new SchemeString(IO.urlClean(IO.url(interpreter.vlr[0], interpreter.vlr[1])).toString());
                    }
                }
                IO.throwArgSizeException();
            }
            case 3: {
                switch (this.id) {
                    case 25: {
                        try {
                            int n = IO.str(interpreter.vlr[0]).readFromReader(interpreter.dynenv.getCurrentInReader(), IO.num(interpreter.vlr[1]).intValue(), IO.num(interpreter.vlr[2]).intValue());
                            if (n < 0) {
                                return EOF;
                            }
                            return Quantity.valueOf(n);
                        }
                        catch (IOException iOException) {
                            IO.throwIOException(interpreter, iOException.getMessage(), iOException);
                            return VOID;
                        }
                    }
                    case 26: {
                        try {
                            IO.str(interpreter.vlr[0]).writeToWriter(interpreter.dynenv.getCurrentOutWriter(), IO.num(interpreter.vlr[1]).intValue(), IO.num(interpreter.vlr[2]).intValue());
                        }
                        catch (IOException iOException) {
                            IO.throwIOException(interpreter, iOException.getMessage(), iOException);
                        }
                        return VOID;
                    }
                    case 19: {
                        URL uRL = IO.url(interpreter.vlr[0]);
                        return IO.openCharOutFile(interpreter, uRL, Util.charsetFromString(IO.string(interpreter.vlr[1])), IO.truth(interpreter.vlr[2]));
                    }
                }
                IO.throwArgSizeException();
            }
            case 4: {
                switch (this.id) {
                    case 25: {
                        try {
                            int n = IO.str(interpreter.vlr[0]).readFromReader(IO.charinreader(interpreter.vlr[3]), IO.num(interpreter.vlr[1]).intValue(), IO.num(interpreter.vlr[2]).intValue());
                            if (n < 0) {
                                return EOF;
                            }
                            return Quantity.valueOf(n);
                        }
                        catch (IOException iOException) {
                            IO.throwIOException(interpreter, iOException.getMessage(), iOException);
                            return VOID;
                        }
                    }
                    case 26: {
                        try {
                            IO.str(interpreter.vlr[0]).writeToWriter(IO.charoutwriter(interpreter.vlr[3]), IO.num(interpreter.vlr[1]).intValue(), IO.num(interpreter.vlr[2]).intValue());
                        }
                        catch (IOException iOException) {
                            IO.throwIOException(interpreter, iOException.getMessage(), iOException);
                        }
                        return VOID;
                    }
                }
                IO.throwArgSizeException();
            }
        }
        IO.throwArgSizeException();
        return VOID;
    }

    public static class Index
    extends IndexedLibraryAdapter {
        public Value construct(Object object, int n) {
            return new IO(n);
        }

        public Index() {
            this.define("absolute-path?", 0);
            this.define("char-ready?", 3);
            this.define("close-input-port", 4);
            this.define("close-output-port", 5);
            this.define("display", 8);
            this.define("file-exists?", 9);
            this.define("find-resource", 6);
            this.define("find-resources", 2);
            this.define("flush-output-port", 10);
            this.define("input-port?", 12);
            this.define("input-port-location", 13);
            this.define("load", 14);
            this.define("load-expanded", 24);
            this.define("normalize-url", 16);
            this.define("open-autoflush-binary-output-port", 35);
            this.define("open-autoflush-character-output-port", 36);
            this.define("open-buffered-character-input-port", 32);
            this.define("open-buffered-character-output-port", 33);
            this.define("open-character-input-port", 31);
            this.define("open-character-output-port", 34);
            this.define("open-input-file", 17);
            this.define("open-output-file", 19);
            this.define("open-source-input-file", 20);
            this.define("output-port?", 22);
            this.define("peek-byte", 30);
            this.define("peek-char", 23);
            this.define("port?", 27);
            this.define("read", 21);
            this.define("read-byte", 29);
            this.define("read-char", 18);
            this.define("read-code", 11);
            this.define("read-string", 25);
            this.define("write", 1);
            this.define("write-byte", 28);
            this.define("write-char", 7);
            this.define("write-string", 26);
        }
    }
}

