/*
 * Decompiled with CFR 0.152.
 */
package sisc.modules;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import sisc.compiler.Compiler;
import sisc.compiler.Syntax;
import sisc.data.Box;
import sisc.data.Closure;
import sisc.data.Expression;
import sisc.data.ImmutableException;
import sisc.data.ImmutablePair;
import sisc.data.ImmutableString;
import sisc.data.ImmutableVector;
import sisc.data.Pair;
import sisc.data.Procedure;
import sisc.data.Quantity;
import sisc.data.SchemeBoolean;
import sisc.data.SchemeCharacter;
import sisc.data.SchemeString;
import sisc.data.SchemeVector;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.data.Values;
import sisc.env.ConfigParameter;
import sisc.env.MemorySymEnv;
import sisc.env.NativeParameter;
import sisc.env.Parameter;
import sisc.env.SchemeParameter;
import sisc.env.SymbolicEnvironment;
import sisc.exprs.ApplyValuesContEval;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.nativefun.IndexedFixableProcedure;
import sisc.nativefun.IndexedLibraryAdapter;
import sisc.nativefun.IndexedProcedure;
import sisc.nativefun.NativeLibrary;
import sisc.util.ExpressionVisitee;
import sisc.util.ExpressionVisitor;
import sisc.util.InternedValue;
import sisc.util.SignalHook;
import sisc.util.Util;

public abstract class Primitives
extends Util {
    static final String GENSYM_MAGIC_PREFIX = "%%_";
    static final char[] b64cs = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-_".toCharArray();
    private static final Expression CALLEC_APPEVAL = Primitives.annotatedAppEval("call-with-escape-continuation");
    private static final Expression CALLCC_APPEVAL = Primitives.annotatedAppEval("call-with-current-continuation");
    private static final Expression CALLFC_APPEVAL = Primitives.annotatedAppEval("call-with-failure-continuation");
    private static final Expression WITHFC_APPEVAL = Primitives.annotatedAppEval("with-failure-continuation");
    private static final Expression WITHENV_APPEVAL = Primitives.annotatedAppEval("_with-environment");
    private static final Expression CALLWITHVALUES_APPEVAL = Primitives.annotatedAppEval("call-with-values");
    private static final Expression APPLY_APPEVAL = Primitives.annotatedAppEval("apply");
    static final int ACOS = 23;
    static final int ADD = 114;
    static final int APPLY = 121;
    static final int ASHL = 102;
    static final int ASHR = 103;
    static final int ASIN = 22;
    static final int ATAN = 93;
    static final int BOOLEANQ = 32;
    static final int BOX = 56;
    static final int BOXQ = 58;
    static final int CALLCC = 54;
    static final int CALLEC = 126;
    static final int CALLFC = 55;
    static final int CALLWITHVALUES = 106;
    static final int CAR = 15;
    static final int CDR = 16;
    static final int CEILING = 49;
    static final int CHAR2INTEGER = 43;
    static final int CHARACTERQ = 30;
    static final int CHAREQUAL = 140;
    static final int CIRCULARQ = 62;
    static final int CLASSPATHEXTENSION = 142;
    static final int CLASSPATHEXTENSIONAPPEND = 143;
    static final int COMPACTSTRINGREP = 7;
    static final int COMPILE = 144;
    static final int COMPLEXQ = 37;
    static final int CONS = 85;
    static final int CONSIMMUTABLE = 131;
    static final int COS = 20;
    static final int CURRENTWIND = 70;
    static final int DENOMINATOR = 67;
    static final int DIV = 115;
    static final int ENVIRONMENTQ = 34;
    static final int EQ = 83;
    static final int EQUAL = 86;
    static final int EQV = 84;
    static final int EXACT2INEXACT = 46;
    static final int EXACTQ = 38;
    static final int EXP = 25;
    static final int EXPTYPE = 129;
    static final int FLOOR = 48;
    static final int GCD = 92;
    static final int GENSYM = 0;
    static final int GENSYMQ = 137;
    static final int GETSIDECAR = 124;
    static final int PARENTENVIRONMENT = 148;
    static final int GETENV = 123;
    static final int GETENVIRONMENT = 18;
    static final int GETPROP = 109;
    static final int GRT = 118;
    static final int HASHCODE = 136;
    static final int IMAGPART = 69;
    static final int IMMUTABLEPAIRQ = 132;
    static final int IMMUTABLEVECTORQ = 133;
    static final int INEXACT2EXACT = 47;
    static final int INEXACTQ = 39;
    static final int INTEGER2CHAR = 52;
    static final int INTEGERQ = 36;
    static final int INTERACTIONENVIRONMENT = 1;
    static final int INTERN = 138;
    static final int LCM = 91;
    static final int LENGTH = 59;
    static final int LIST = 120;
    static final int LIST2VECTOR = 44;
    static final int LOADNL = 77;
    static final int LOG = 24;
    static final int LT = 117;
    static final int MAKECHILDENVIRONMENT = 147;
    static final int MAKEPARAM = 63;
    static final int MAKENATIVEPARAM = 12;
    static final int MAKECONFIGPARAM = 122;
    static final int MAKERECTANGULAR = 101;
    static final int MAKESTRING = 99;
    static final int MAKEVECTOR = 65;
    static final int MAKEIMMUTABLEVECTOR = 130;
    static final int MAXFLOATPRECISION = 9;
    static final int MINFLOATPRECISION = 10;
    static final int MUL = 11;
    static final int NEQ = 116;
    static final int NLBINDING = 104;
    static final int NLBINDINGNAMES = 76;
    static final int NLNAME = 74;
    static final int NLVERSION = 75;
    static final int NULLENVIRONMENT = 73;
    static final int NULLQ = 14;
    static final int NUMBER2STRING = 80;
    static final int NUMBERQ = 27;
    static final int NUMERATOR = 66;
    static final int PAIRQ = 17;
    static final int PARAMETERQ = 40;
    static final int PERMITINTERRUPTS = 8;
    static final int PORTQ = 141;
    static final int PROCEDUREQ = 35;
    static final int PUTPROP = 110;
    static final int QUOTIENT = 90;
    static final int REALPART = 68;
    static final int REMAINDER = 89;
    static final int REMPROP = 107;
    static final int REPORTENVIRONMENT = 72;
    static final int ROUND = 50;
    static final int SEALIMMUTABLEPAIR = 134;
    static final int SEALIMMUTABLEVECTOR = 135;
    static final int SETBOX = 94;
    static final int SETCAR = 87;
    static final int SETCDR = 88;
    static final int SETENVIRONMENT = 108;
    static final int SIGHOOK = 127;
    static final int SIGUNHOOK = 128;
    static final int SIN = 19;
    static final int SISCINITIAL = 2;
    static final int SLEEP = 78;
    static final int SQRT = 26;
    static final int STRING2NUMBER = 79;
    static final int STRING2SYMBOL = 42;
    static final int STRING2UNINTERNEDSYMBOL = 71;
    static final int STRINGAPPEND = 100;
    static final int STRINGFILL = 98;
    static final int STRINGLENGTH = 60;
    static final int STRINGQ = 31;
    static final int STRINGEQUAL = 139;
    static final int STRINGREF = 95;
    static final int STRINGSET = 111;
    static final int SUB = 119;
    static final int SYMBOL2STRING = 41;
    static final int SYMBOLQ = 29;
    static final int SYNTOKEN2STRING = 125;
    static final int SYNTOKENQ = 6;
    static final int SYSTIME = 3;
    static final int TAN = 21;
    static final int TIMEZONEOFFSET = 4;
    static final int TRUNCATE = 51;
    static final int UNBOX = 57;
    static final int VECTOR2LIST = 45;
    static final int VECTORFILL = 113;
    static final int VECTORFINDLASTUNIQUE = 53;
    static final int VECTORLENGTH = 61;
    static final int VECTORQ = 28;
    static final int VECTORREF = 96;
    static final int VECTORSET = 112;
    static final int VOIDQ = 33;
    static final int WITHENVIRONMENT = 146;
    static final int WITHFC = 105;
    static final int _VOID = 5;
    static /* synthetic */ Class class$sisc$modules$Primitives;
    static /* synthetic */ Class class$sisc$modules$Primitives$Simple;
    static /* synthetic */ Class class$sisc$modules$Primitives$Complex;

    private static Expression annotatedAppEval(String string) {
        return Primitives.annotatedAppEval(class$sisc$modules$Primitives == null ? (class$sisc$modules$Primitives = Primitives.class$("sisc.modules.Primitives")) : class$sisc$modules$Primitives, string);
    }

    protected static String base64encode(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        while (l != 0L) {
            stringBuffer.append(b64cs[(int)l & 0x3F]);
            l >>>= 6;
        }
        return stringBuffer.toString();
    }

    public static SchemeBoolean numQuery(Value value, int n) throws ContinuationException {
        return Primitives.truth(value instanceof Quantity && ((Quantity)value).is(n));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Complex
    extends IndexedProcedure {
        public Complex() {
        }

        Complex(int n) {
            super(n);
        }

        public final Value doApply(Interpreter interpreter) throws ContinuationException {
            return this.doApply(interpreter, interpreter.vlr);
        }

        public final Value doApply(Interpreter interpreter, Value[] valueArray) throws ContinuationException {
            int n = valueArray.length;
            switch (n) {
                case 0: {
                    switch (this.id) {
                        case 142: {
                            URL[] uRLArray = interpreter.dynenv.getClassPath();
                            Pair pair = EMPTYLIST;
                            for (int i = uRLArray.length - 1; i >= 0; --i) {
                                pair = new Pair(new SchemeString(uRLArray[i].toString()), pair);
                            }
                            return pair;
                        }
                        case 7: {
                            return Complex.truth(SchemeString.compactRepresentation);
                        }
                        case 70: {
                            return interpreter.dynenv.wind;
                        }
                        case 0: {
                            long l = interpreter.tctx.nextUnique();
                            return Symbol.intern(Primitives.GENSYM_MAGIC_PREFIX + Primitives.base64encode(l));
                        }
                        case 1: {
                            return interpreter.tpl.asValue();
                        }
                        case 2: {
                            try {
                                return new MemorySymEnv(interpreter.lookupContextEnv(Util.SISC_SPECIFIC));
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                Complex.throwPrimException(Complex.liMessage(SISCB, "nosiscspecificenv"));
                            }
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.id) {
                        case 143: {
                            for (Pair pair = Complex.pair(valueArray[0]); pair != EMPTYLIST; pair = (Pair)pair.cdr()) {
                                interpreter.dynenv.extendClassPath(Complex.url(pair.car()));
                            }
                            return VOID;
                        }
                        case 134: {
                            Complex.immutablePair(valueArray[0]).makeImmutable();
                            return VOID;
                        }
                        case 135: {
                            Complex.immutableVector(valueArray[0]).makeImmutable();
                            return VOID;
                        }
                        case 7: {
                            SchemeString.compactRepresentation = Complex.truth(valueArray[0]);
                            return VOID;
                        }
                        case 80: {
                            return new SchemeString(Complex.num(valueArray[0]).toString());
                        }
                        case 18: {
                            try {
                                return interpreter.getCtx().lookupContextEnv(Complex.symbol(valueArray[0])).asValue();
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                Complex.throwPrimException(Complex.liMessage(SISCB, "noenv", valueArray[0].synopsis()));
                                return VOID;
                            }
                        }
                        case 148: {
                            SymbolicEnvironment symbolicEnvironment = Complex.env(valueArray[0]);
                            SymbolicEnvironment symbolicEnvironment2 = symbolicEnvironment.getParent();
                            if (symbolicEnvironment2 == null) {
                                return FALSE;
                            }
                            return symbolicEnvironment2.asValue();
                        }
                        case 124: {
                            return interpreter.tpl.getSidecarEnvironment(Complex.symbol(valueArray[0])).asValue();
                        }
                        case 123: {
                            String string = interpreter.getCtx().getProperty(Complex.string(valueArray[0]));
                            if (string == null) {
                                return FALSE;
                            }
                            return new SchemeString(string);
                        }
                        case 0: {
                            long l = interpreter.tctx.nextUnique();
                            return Symbol.intern(Primitives.GENSYM_MAGIC_PREFIX + Primitives.base64encode(l));
                        }
                        case 144: {
                            return new Closure(false, 0, interpreter.compile(valueArray[0]), ZV, new int[0]);
                        }
                        case 126: {
                            Value value = valueArray[0];
                            interpreter.setupTailCall(CALLEC_APPEVAL, interpreter.captureEscapingContinuation());
                            return value;
                        }
                        case 54: {
                            Value value = valueArray[0];
                            interpreter.setupTailCall(CALLCC_APPEVAL, interpreter.captureContinuation());
                            return value;
                        }
                        case 55: {
                            Value value = valueArray[0];
                            interpreter.setupTailCall(CALLFC_APPEVAL, interpreter.fk.capture(interpreter));
                            return value;
                        }
                        case 70: {
                            interpreter.dynenv.wind = valueArray[0];
                            return VOID;
                        }
                        case 77: {
                            try {
                                Class<?> clazz = Class.forName(Complex.string(valueArray[0]), true, Util.currentClassLoader());
                                return (NativeLibrary)clazz.newInstance();
                            }
                            catch (Exception exception) {
                                Complex.throwPrimException(exception.getMessage());
                            }
                        }
                        case 109: {
                            int n2 = interpreter.tpl.getLoc(Complex.symbol(valueArray[0]));
                            if (n2 == -1) {
                                return FALSE;
                            }
                            return interpreter.tpl.lookup(n2);
                        }
                        case 79: {
                            String string = Complex.string(valueArray[0]);
                            try {
                                return (Quantity)interpreter.dynenv.parser.nextExpression(new PushbackReader(new StringReader(string)));
                            }
                            catch (ClassCastException classCastException) {
                                return FALSE;
                            }
                            catch (NumberFormatException numberFormatException) {
                                return FALSE;
                            }
                            catch (IOException iOException) {
                                return FALSE;
                            }
                        }
                        case 76: {
                            Value[] valueArray2 = Complex.nlib(valueArray[0]).getLibraryBindingNames(interpreter);
                            return Complex.valArrayToList(valueArray2, 0, valueArray2.length);
                        }
                        case 1: {
                            Value value = interpreter.getCtx().toplevel_env.asValue();
                            interpreter.getCtx().toplevel_env = Complex.env(valueArray[0]);
                            return value;
                        }
                        case 72: {
                            if (FIVE.equals(Complex.num(valueArray[0]))) {
                                try {
                                    return new MemorySymEnv(interpreter.lookupContextEnv(Util.REPORT));
                                }
                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                    Complex.throwPrimException(Complex.liMessage(SISCB, "noreportenv"));
                                }
                            } else {
                                Complex.throwPrimException(Complex.liMessage(SISCB, "unsupportedstandardver"));
                            }
                        }
                        case 73: {
                            switch (Complex.num(valueArray[0]).indexValue()) {
                                case 5: {
                                    MemorySymEnv memorySymEnv = new MemorySymEnv();
                                    Compiler.addSpecialForms(memorySymEnv);
                                    return memorySymEnv;
                                }
                                case 0: {
                                    return new MemorySymEnv();
                                }
                            }
                            Complex.throwPrimException(Complex.liMessage(SISCB, "unsupportedstandardver"));
                            return VOID;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.id) {
                        case 104: {
                            return Complex.nlib(valueArray[0]).getBindingValue(interpreter, Complex.symbol(valueArray[1]));
                        }
                        case 144: {
                            return new Closure(false, 0, interpreter.compile(valueArray[0], Complex.env(valueArray[1])), ZV, new int[0]);
                        }
                        case 146: {
                            Procedure procedure = Complex.proc(valueArray[1]);
                            interpreter.tpl = Complex.env(valueArray[0]);
                            interpreter.setupTailCall(WITHENV_APPEVAL, ZV);
                            return procedure;
                        }
                        case 105: {
                            Procedure procedure = Complex.proc(valueArray[1]);
                            Procedure procedure2 = Complex.proc(valueArray[0]);
                            interpreter.setFailureContinuation(new ApplyValuesContEval(procedure2));
                            interpreter.setupTailCall(WITHFC_APPEVAL, ZV);
                            return procedure;
                        }
                        case 106: {
                            Procedure procedure = Complex.proc(valueArray[0]);
                            Procedure procedure3 = Complex.proc(valueArray[1]);
                            interpreter.pushExpr(new ApplyValuesContEval(procedure3));
                            interpreter.setupTailCall(CALLWITHVALUES_APPEVAL, ZV);
                            return procedure;
                        }
                        case 109: {
                            Value value = null;
                            value = valueArray[1] instanceof SymbolicEnvironment ? Complex.env(valueArray[1]).lookup(Complex.symbol(valueArray[0])) : interpreter.tpl.getSidecarEnvironment(Complex.symbol(valueArray[1])).lookup(Complex.symbol(valueArray[0]));
                            return value == null ? FALSE : value;
                        }
                        case 107: {
                            if (valueArray[1] instanceof SymbolicEnvironment) {
                                Complex.env(valueArray[1]).undefine(Complex.symbol(valueArray[0]));
                            } else {
                                interpreter.tpl.getSidecarEnvironment(Complex.symbol(valueArray[1])).undefine(Complex.symbol(valueArray[0]));
                            }
                            return VOID;
                        }
                        case 110: {
                            interpreter.tpl.define(Complex.symbol(valueArray[0]), valueArray[1]);
                            return VOID;
                        }
                        case 94: {
                            try {
                                Complex.box(valueArray[0]).set(valueArray[1]);
                            }
                            catch (ImmutableException immutableException) {
                                Complex.throwPrimException(Complex.liMessage(SISCB, "isimmutable", "box", valueArray[0].synopsis()));
                            }
                            return VOID;
                        }
                        case 87: {
                            Complex.truePair(valueArray[0]).setCar(valueArray[1]);
                            return VOID;
                        }
                        case 88: {
                            Complex.truePair(valueArray[0]).setCdr(valueArray[1]);
                            return VOID;
                        }
                        case 108: {
                            interpreter.getCtx().defineContextEnv(Complex.symbol(valueArray[0]), Complex.env(valueArray[1]));
                            return VOID;
                        }
                        case 127: {
                            SignalHook.addHandler(Complex.string(valueArray[0]), Complex.proc(valueArray[1]), interpreter.dynenv);
                            return VOID;
                        }
                        case 128: {
                            SignalHook.removeHandler(Complex.string(valueArray[0]), Complex.proc(valueArray[1]), interpreter.dynenv);
                            return VOID;
                        }
                        case 124: {
                            return Complex.env(valueArray[1]).getSidecarEnvironment(Complex.symbol(valueArray[0])).asValue();
                        }
                        case 79: {
                            try {
                                int n3 = Complex.num(valueArray[1]).indexValue();
                                if (interpreter.dynenv.parser.lexer.strictR5RS && n3 != 10 && n3 != 16 && n3 != 2 && n3 != 8) {
                                    Complex.throwPrimException(Complex.liMessage(SISCB, "invalidradix"));
                                }
                                return (Quantity)interpreter.dynenv.parser.nextExpression(new PushbackReader(new StringReader(Complex.string(valueArray[0]))), n3, 0);
                            }
                            catch (NumberFormatException numberFormatException) {
                                return FALSE;
                            }
                            catch (IOException iOException) {
                                return FALSE;
                            }
                        }
                        case 80: {
                            int n4 = Complex.num(valueArray[1]).indexValue();
                            if (interpreter.dynenv.parser.lexer.strictR5RS && n4 != 10 && n4 != 16 && n4 != 2 && n4 != 8) {
                                Complex.throwPrimException(Complex.liMessage(SISCB, "invalidradix"));
                            }
                            return new SchemeString(Complex.num(valueArray[0]).toString(n4));
                        }
                        case 98: {
                            SchemeString schemeString = Complex.str(valueArray[0]);
                            char c = Complex.character(valueArray[1]);
                            for (int i = 0; i < schemeString.length(); ++i) {
                                schemeString.set(i, c);
                            }
                            return VOID;
                        }
                        case 113: {
                            Complex.vec(valueArray[0]).fill(valueArray[1]);
                            return VOID;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (this.id) {
                        case 111: {
                            int n5 = Complex.num(valueArray[1]).indexValue();
                            try {
                                Complex.str(valueArray[0]).set(n5, Complex.character(valueArray[2]));
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                Complex.throwPrimException(Complex.liMessage(SISCB, "indexoob", new Object[]{new Integer(n5), valueArray[0].synopsis()}));
                            }
                            return VOID;
                        }
                        case 112: {
                            int n6 = Complex.num(valueArray[1]).indexValue();
                            try {
                                Complex.vec(valueArray[0]).set(n6, valueArray[2]);
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                Complex.throwPrimException(Complex.liMessage(SISCB, "indexoob", new Object[]{new Integer(n6), valueArray[0].synopsis()}));
                            }
                            return VOID;
                        }
                        case 109: {
                            Value value = null;
                            value = valueArray[1] instanceof SymbolicEnvironment ? Complex.env(valueArray[1]).lookup(Complex.symbol(valueArray[0])) : interpreter.tpl.getSidecarEnvironment(Complex.symbol(valueArray[1])).lookup(Complex.symbol(valueArray[0]));
                            return value == null ? valueArray[2] : value;
                        }
                        case 110: {
                            Symbol symbol = Complex.symbol(valueArray[0]);
                            Value value = valueArray[2];
                            SymbolicEnvironment symbolicEnvironment = valueArray[1] instanceof SymbolicEnvironment ? (SymbolicEnvironment)((Object)valueArray[1]) : interpreter.tpl.getSidecarEnvironment((Symbol)valueArray[1]);
                            Complex.updateName(value, symbol);
                            symbolicEnvironment.define(symbol, value);
                            return VOID;
                        }
                    }
                }
            }
            switch (this.id) {
                case 121: {
                    Procedure procedure = Complex.proc(valueArray[0]);
                    int n7 = n - 2;
                    Pair pair = Complex.pair(valueArray[n7 + 1]);
                    Value[] valueArray3 = interpreter.createValues(n7 + Complex.length(pair));
                    for (int i = 0; i < n7; ++i) {
                        valueArray3[i] = valueArray[i + 1];
                    }
                    while (pair != EMPTYLIST) {
                        valueArray3[i++] = pair.car();
                        pair = (Pair)pair.cdr();
                    }
                    interpreter.setupTailCall(APPLY_APPEVAL, valueArray3);
                    return procedure;
                }
            }
            Complex.throwArgSizeException();
            return VOID;
        }
    }

    public static class Simple
    extends IndexedFixableProcedure {
        public Simple() {
        }

        Simple(int n) {
            super(n);
        }

        public final Value apply() throws ContinuationException {
            switch (this.id) {
                case 114: {
                    return Quantity.ZERO;
                }
                case 9: {
                    return Quantity.valueOf(maxFloatPrecision);
                }
                case 10: {
                    return Quantity.valueOf(minFloatPrecision);
                }
                case 11: {
                    return Quantity.ONE;
                }
                case 8: {
                    return Simple.truth(permitInterrupts);
                }
                case 3: {
                    return Quantity.valueOf(System.currentTimeMillis());
                }
                case 4: {
                    Calendar calendar = Calendar.getInstance();
                    return Quantity.valueOf((calendar.get(15) + calendar.get(16)) / 1000);
                }
                case 5: {
                    return VOID;
                }
                case 120: {
                    return EMPTYLIST;
                }
                case 100: {
                    return new SchemeString("");
                }
            }
            Simple.throwArgSizeException();
            return VOID;
        }

        public final Value apply(Value value) throws ContinuationException {
            switch (this.id) {
                case 14: {
                    return Simple.truth(value == EMPTYLIST);
                }
                case 15: {
                    return Simple.truePair(value).car();
                }
                case 16: {
                    return Simple.truePair(value).cdr();
                }
                case 17: {
                    return Simple.truth(value instanceof Pair && value != EMPTYLIST);
                }
                case 132: {
                    return Simple.truth(value instanceof ImmutablePair && ((ImmutablePair)value).isImmutable());
                }
                case 133: {
                    return Simple.truth(value instanceof ImmutableVector);
                }
                case 11: 
                case 114: {
                    return Simple.num(value);
                }
                case 119: {
                    return Simple.num(value).negate();
                }
                case 115: {
                    return Quantity.ONE.div(Simple.num(value));
                }
                case 19: {
                    return Simple.num(value).sin();
                }
                case 20: {
                    return Simple.num(value).cos();
                }
                case 21: {
                    return Simple.num(value).tan();
                }
                case 22: {
                    return Simple.num(value).asin();
                }
                case 23: {
                    return Simple.num(value).acos();
                }
                case 93: {
                    return Simple.num(value).atan();
                }
                case 24: {
                    return Simple.num(value).log();
                }
                case 25: {
                    return Simple.num(value).exp();
                }
                case 26: {
                    return Simple.num(value).sqrt();
                }
                case 27: {
                    return Simple.truth(value instanceof Quantity);
                }
                case 28: {
                    return Simple.truth(value instanceof SchemeVector);
                }
                case 29: {
                    return Simple.truth(value instanceof Symbol);
                }
                case 6: {
                    return Simple.truth(value instanceof Syntax);
                }
                case 30: {
                    return Simple.truth(value instanceof SchemeCharacter);
                }
                case 31: {
                    return Simple.truth(value instanceof SchemeString);
                }
                case 32: {
                    return Simple.truth(value instanceof SchemeBoolean);
                }
                case 33: {
                    return Simple.truth(value == VOID);
                }
                case 34: {
                    return Simple.truth(value instanceof SymbolicEnvironment);
                }
                case 35: {
                    return Simple.truth(value instanceof Procedure);
                }
                case 36: {
                    return Primitives.numQuery(value, 32);
                }
                case 37: {
                    return Primitives.numQuery(value, 16);
                }
                case 38: {
                    return Primitives.numQuery(value, 2);
                }
                case 39: {
                    return Primitives.numQuery(value, 4);
                }
                case 40: {
                    return Simple.truth(value instanceof Parameter);
                }
                case 137: {
                    return Simple.truth(Simple.symbol((Value)value).symval.startsWith(Primitives.GENSYM_MAGIC_PREFIX));
                }
                case 41: {
                    return new ImmutableString(Simple.symbol((Value)value).symval);
                }
                case 125: {
                    return new ImmutableString(((Syntax)value).toString());
                }
                case 42: {
                    return Symbol.intern(Simple.string(value));
                }
                case 43: {
                    return Quantity.valueOf(Simple.character(value));
                }
                case 44: {
                    return new SchemeVector(Util.pairToValues(Simple.pair(value)));
                }
                case 45: {
                    Value[] valueArray = Simple.vec((Value)value).vals;
                    return Simple.valArrayToList(valueArray, 0, valueArray.length);
                }
                case 46: {
                    return Simple.num(value).toInexact();
                }
                case 47: {
                    return Simple.num(value).toExact();
                }
                case 48: {
                    return Simple.num(value).floor();
                }
                case 49: {
                    return Simple.num(value).ceiling();
                }
                case 50: {
                    return Simple.num(value).round();
                }
                case 51: {
                    return Simple.num(value).truncate();
                }
                case 52: {
                    return new SchemeCharacter((char)Simple.num(value).indexValue());
                }
                case 53: {
                    return Quantity.valueOf(Simple.vec(value).findEnd());
                }
                case 56: {
                    return new Box(value);
                }
                case 57: {
                    return Simple.box((Value)value).val;
                }
                case 58: {
                    return Simple.truth(value instanceof Box);
                }
                case 59: {
                    return Quantity.valueOf(Simple.length(Simple.pair(value)));
                }
                case 60: {
                    return Quantity.valueOf(Simple.str(value).length());
                }
                case 61: {
                    return Quantity.valueOf(Simple.vec((Value)value).vals.length);
                }
                case 62: {
                    return Simple.truth(new CircularityDetector().isCircular(value));
                }
                case 63: {
                    return new SchemeParameter(value);
                }
                case 12: {
                    return new NativeParameter(Simple.string(value));
                }
                case 99: {
                    return new SchemeString(new char[Simple.num(value).indexValue()]);
                }
                case 65: {
                    return new SchemeVector(Simple.num(value).indexValue());
                }
                case 130: {
                    return new ImmutableVector(Simple.num(value).indexValue(), false);
                }
                case 66: {
                    return Simple.num(value).numerator();
                }
                case 67: {
                    return Simple.num(value).denominator();
                }
                case 68: {
                    return Simple.num(value).realpart();
                }
                case 69: {
                    return Simple.num(value).imagpart();
                }
                case 71: {
                    return Symbol.getUnique(Simple.string(value));
                }
                case 147: {
                    SymbolicEnvironment symbolicEnvironment = Simple.env(value);
                    MemorySymEnv memorySymEnv = new MemorySymEnv(symbolicEnvironment);
                    Compiler.addSpecialForms(memorySymEnv);
                    return memorySymEnv;
                }
                case 73: {
                    switch (Simple.num(value).indexValue()) {
                        case 5: {
                            MemorySymEnv memorySymEnv = new MemorySymEnv();
                            Compiler.addSpecialForms(memorySymEnv);
                            return memorySymEnv;
                        }
                        case 0: {
                            return new MemorySymEnv();
                        }
                    }
                    Simple.throwPrimException(Simple.liMessage(SISCB, "unsupportedstandardver"));
                    return VOID;
                }
                case 74: {
                    return Symbol.get(Simple.nlib(value).getLibraryName());
                }
                case 75: {
                    return Quantity.valueOf(Simple.nlib(value).getLibraryVersion());
                }
                case 78: {
                    try {
                        Thread.sleep(Simple.num(value).longValue());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return VOID;
                }
                case 100: {
                    return Simple.str(value).copy();
                }
                case 120: {
                    return new Pair(value, EMPTYLIST);
                }
                case 136: {
                    return Quantity.valueOf(value.hashCode());
                }
            }
            Simple.throwArgSizeException();
            return VOID;
        }

        public final Value apply(Value value, Value value2) throws ContinuationException {
            switch (this.id) {
                case 83: {
                    return Simple.truth(value == value2);
                }
                case 84: {
                    return Simple.truth(value.eqv(value2));
                }
                case 85: {
                    return new Pair(value, value2);
                }
                case 131: {
                    return new ImmutablePair(value, value2, false);
                }
                case 86: {
                    return Simple.truth(value.valueEqual(value2));
                }
                case 129: {
                    return Quantity.valueOf(Compiler.getExpType(Simple.env(value), value2));
                }
                case 140: {
                    return Simple.truth(Simple.character(value) == Simple.character(value2));
                }
                case 114: {
                    return Simple.num(value).add(Simple.num(value2));
                }
                case 11: {
                    return Simple.num(value).mul(Simple.num(value2));
                }
                case 119: {
                    return Simple.num(value).sub(Simple.num(value2));
                }
                case 115: {
                    return Simple.num(value).div(Simple.num(value2));
                }
                case 116: {
                    return Simple.truth(Simple.num(value).comp(Simple.num(value2), 0));
                }
                case 89: {
                    return Simple.num(value).remainder(Simple.num(value2));
                }
                case 90: {
                    return Simple.num(value).quotient(Simple.num(value2));
                }
                case 91: {
                    return Simple.num(value).lcm(Simple.num(value2));
                }
                case 92: {
                    return Simple.num(value).gcd(Simple.num(value2));
                }
                case 93: {
                    return Simple.num(value).atan(Simple.num(value2));
                }
                case 95: {
                    int n = Simple.num(value2).indexValue();
                    try {
                        return new SchemeCharacter(Simple.str(value).charAt(n));
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        Simple.throwPrimException(Simple.liMessage(SISCB, "indexoob", new Object[]{new Integer(n), value.synopsis()}));
                    }
                }
                case 96: {
                    int n = Simple.num(value2).indexValue();
                    try {
                        return Simple.vec((Value)value).vals[n];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        Simple.throwPrimException(Simple.liMessage(SISCB, "indexoob", new Object[]{new Integer(n), value.synopsis()}));
                    }
                }
                case 139: {
                    return Simple.truth(Simple.str(value).valueEqual(Simple.str(value2)));
                }
                case 65: {
                    return new SchemeVector(Simple.num(value).indexValue(), value2);
                }
                case 99: {
                    char[] cArray = new char[Simple.num(value).indexValue()];
                    char c = Simple.character(value2);
                    for (int i = 0; i < cArray.length; ++i) {
                        cArray[i] = c;
                    }
                    return new SchemeString(cArray);
                }
                case 100: {
                    SchemeString schemeString = Simple.str(value);
                    SchemeString schemeString2 = Simple.str(value2);
                    StringBuffer stringBuffer = new StringBuffer(schemeString.length() + schemeString2.length());
                    schemeString.appendTo(stringBuffer);
                    schemeString2.appendTo(stringBuffer);
                    return new SchemeString(stringBuffer.toString());
                }
                case 101: {
                    return Quantity.valueOf(Simple.num(value), Simple.num(value2));
                }
                case 102: {
                    return Quantity.valueOf(Simple.num(value).integer().shiftLeft(Simple.num(value2).indexValue()));
                }
                case 103: {
                    return Quantity.valueOf(Simple.num(value).integer().shiftRight(Simple.num(value2).indexValue()));
                }
                case 122: {
                    return new ConfigParameter(Simple.string(value), value2);
                }
                case 120: {
                    return Simple.list(value, value2);
                }
                case 117: {
                    return Simple.truth(Simple.num(value).comp(Simple.num(value2), -1));
                }
                case 118: {
                    return Simple.truth(Simple.num(value).comp(Simple.num(value2), 1));
                }
                case 138: {
                    InternedValue internedValue = InternedValue.intern(Simple.symbol(value), value2);
                    if (internedValue == null) {
                        Simple.throwPrimException(Simple.liMessage(SISCB, "internconflict", Simple.symval(value), value2.synopsis()));
                    }
                    return new Values(new Value[]{internedValue.getName(), internedValue.getValue()});
                }
            }
            Simple.throwArgSizeException();
            return VOID;
        }

        public final Value apply(Value value, Value value2, Value value3) throws ContinuationException {
            switch (this.id) {
                case 140: {
                    return Simple.truth(Simple.character(value) == Simple.character(value2) && Simple.character(value2) == Simple.character(value3));
                }
                case 100: {
                    SchemeString schemeString = Simple.str(value);
                    SchemeString schemeString2 = Simple.str(value2);
                    SchemeString schemeString3 = Simple.str(value3);
                    StringBuffer stringBuffer = new StringBuffer(schemeString.length() + schemeString2.length() + schemeString3.length());
                    schemeString.appendTo(stringBuffer);
                    schemeString2.appendTo(stringBuffer);
                    schemeString3.appendTo(stringBuffer);
                    return new SchemeString(stringBuffer.toString());
                }
                case 139: {
                    return Simple.truth(Simple.str(value).valueEqual(Simple.str(value2)) && Simple.str(value2).valueEqual(Simple.str(value3)));
                }
                case 120: {
                    return Simple.list(value, value2, value3);
                }
                case 114: {
                    return Simple.num(value).add(Simple.num(value2)).add(Simple.num(value3));
                }
                case 11: {
                    return Simple.num(value).mul(Simple.num(value2)).mul(Simple.num(value3));
                }
                case 119: {
                    return Simple.num(value).sub(Simple.num(value2)).sub(Simple.num(value3));
                }
                case 116: {
                    Quantity quantity = Simple.num(value2);
                    return Simple.truth(Simple.num(value).comp(quantity, 0) && quantity.comp(Simple.num(value3), 0));
                }
                case 117: {
                    Quantity quantity = Simple.num(value2);
                    return Simple.truth(Simple.num(value).comp(quantity, -1) && quantity.comp(Simple.num(value3), -1));
                }
                case 118: {
                    Quantity quantity = Simple.num(value2);
                    return Simple.truth(Simple.num(value).comp(quantity, 1) && quantity.comp(Simple.num(value3), 1));
                }
                case 115: {
                    return Simple.num(value).div(Simple.num(value2).mul(Simple.num(value3)));
                }
                case 83: {
                    return Simple.truth(value == value2 && value2 == value3);
                }
                case 84: {
                    return Simple.truth(value.eqv(value2));
                }
                case 86: {
                    return Simple.truth(value.valueEqual(value2) && value2.valueEqual(value3));
                }
            }
            Simple.throwArgSizeException();
            return VOID;
        }

        public final Value apply(Value[] valueArray) throws ContinuationException {
            int n = valueArray.length;
            Quantity quantity = null;
            switch (this.id) {
                case 120: {
                    return Simple.valArrayToList(valueArray, 0, n);
                }
                case 114: {
                    int n2 = n - 1;
                    quantity = Simple.num(valueArray[n2]);
                    while (--n2 >= 0) {
                        quantity = quantity.add(Simple.num(valueArray[n2]));
                    }
                    return quantity;
                }
                case 11: {
                    int n3 = n - 1;
                    quantity = Simple.num(valueArray[n3]);
                    while (--n3 >= 0) {
                        quantity = quantity.mul(Simple.num(valueArray[n3]));
                    }
                    return quantity;
                }
                case 119: {
                    quantity = Simple.num(valueArray[0]);
                    for (int i = 1; i < n; ++i) {
                        quantity = quantity.sub(Simple.num(valueArray[i]));
                    }
                    return quantity;
                }
                case 116: {
                    quantity = Simple.num(valueArray[0]);
                    for (int i = n - 1; i > 0; --i) {
                        if (quantity.comp(Simple.num(valueArray[i]), 0)) continue;
                        return FALSE;
                    }
                    return TRUE;
                }
                case 117: {
                    quantity = Simple.num(valueArray[0]);
                    for (int i = 1; i < n; ++i) {
                        Quantity quantity2 = Simple.num(valueArray[i]);
                        if (!quantity.comp(quantity2, -1)) {
                            return FALSE;
                        }
                        quantity = quantity2;
                    }
                    return TRUE;
                }
                case 118: {
                    quantity = Simple.num(valueArray[0]);
                    for (int i = 1; i < n; ++i) {
                        Quantity quantity3 = Simple.num(valueArray[i]);
                        if (!quantity.comp(quantity3, 1)) {
                            return FALSE;
                        }
                        quantity = quantity3;
                    }
                    return TRUE;
                }
                case 115: {
                    int n4 = n - 1;
                    quantity = Simple.num(valueArray[n4]);
                    while (--n4 >= 1) {
                        quantity = quantity.mul(Simple.num(valueArray[n4]));
                    }
                    return Simple.num(valueArray[0]).div(quantity);
                }
                case 100: {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < n; ++i) {
                        Simple.str(valueArray[i]).appendTo(stringBuffer);
                    }
                    return new SchemeString(stringBuffer.toString());
                }
                case 139: {
                    SchemeString schemeString = Simple.str(valueArray[0]);
                    for (int i = 1; i < n; ++i) {
                        SchemeString schemeString2 = Simple.str(valueArray[i]);
                        if (schemeString.valueEqual(schemeString2)) continue;
                        return FALSE;
                    }
                    return TRUE;
                }
                case 140: {
                    char c = Simple.character(valueArray[0]);
                    for (int i = 1; i < n; ++i) {
                        char c2 = Simple.character(valueArray[i]);
                        if (c == c2) continue;
                        return FALSE;
                    }
                    return TRUE;
                }
            }
            Simple.throwArgSizeException();
            return VOID;
        }
    }

    public static class Index
    extends IndexedLibraryAdapter {
        public Value construct(Object object, int n) {
            if (object == null || object == (class$sisc$modules$Primitives$Simple == null ? (class$sisc$modules$Primitives$Simple = Primitives.class$("sisc.modules.Primitives$Simple")) : class$sisc$modules$Primitives$Simple)) {
                return new Simple(n);
            }
            return new Complex(n);
        }

        public Index() {
            this.define("apply", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 121);
            this.define("call-with-current-continuation", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 54);
            this.define("call-with-escape-continuation", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 126);
            this.define("call-with-failure-continuation", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 55);
            this.define("call-with-values", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 106);
            this.define("compact-string-rep", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 7);
            this.define("compile", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 144);
            this.define("current-wind", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 70);
            this.define("gensym", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 0);
            this.define("gensym?", 137);
            this.define("getenv", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 123);
            this.define("getprop", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 109);
            this.define("get-sidecar-environment", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 124);
            this.define("get-symbolic-environment", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 18);
            this.define("set-symbolic-environment!", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 108);
            this.define("interaction-environment", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 1);
            this.define("load-native-library", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 77);
            this.define("native-library-binding", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 104);
            this.define("native-library-binding-names", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 76);
            this.define("number->string", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 80);
            this.define("parent-environment", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 148);
            this.define("putprop", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 110);
            this.define("remprop", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 107);
            this.define("scheme-report-environment", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 72);
            this.define("seal-immutable-pair!", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 134);
            this.define("seal-immutable-vector!", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 135);
            this.define("sisc-initial-environment", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 2);
            this.define("string-fill!", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 98);
            this.define("string-set!", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 111);
            this.define("string->number", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 79);
            this.define("vector-fill!", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 113);
            this.define("vector-set!", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 112);
            this.define("with-failure-continuation", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 105);
            this.define("_with-environment", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 146);
            this.define("class-path-extension", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 142);
            this.define("class-path-extension-append!", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 143);
            this.define("list", 120);
            this.define("*", 11);
            this.define("+", 114);
            this.define("-", 119);
            this.define("/", 115);
            this.define("<", 117);
            this.define("=", 116);
            this.define(">", 118);
            this.define("_gcd", 92);
            this.define("_lcm", 91);
            this.define("string-append", 100);
            this.define("acos", 23);
            this.define("ashl", 102);
            this.define("ashr", 103);
            this.define("asin", 22);
            this.define("atan", 93);
            this.define("boolean?", 32);
            this.define("box", 56);
            this.define("box?", 58);
            this.define("car", 15);
            this.define("cdr", 16);
            this.define("ceiling", 49);
            this.define("char->integer", 43);
            this.define("char?", 30);
            this.define("char=?", 140);
            this.define("circular?", 62);
            this.define("complex?", 37);
            this.define("cons", 85);
            this.define("cons-immutable", 131);
            this.define("cos", 20);
            this.define("denominator", 67);
            this.define("environment?", 34);
            this.define("eq?", 83);
            this.define("eqv?", 84);
            this.define("equal?", 86);
            this.define("exact->inexact", 46);
            this.define("exact?", 38);
            this.define("_expression-type", 129);
            this.define("exp", 25);
            this.define("find-last-unique-vector-element", 53);
            this.define("floor", 48);
            this.define("hash-code", 136);
            this.define("imag-part", 69);
            this.define("immutable-pair?", 132);
            this.define("immutable-vector?", 133);
            this.define("inexact->exact", 47);
            this.define("inexact?", 39);
            this.define("integer->char", 52);
            this.define("_integer?", 36);
            this.define("intern", 138);
            this.define("length", 59);
            this.define("list->vector", 44);
            this.define("log", 24);
            this.define("_make-parameter", 63);
            this.define("_make-native-parameter", 12);
            this.define("_make-config-parameter", 122);
            this.define("make-child-environment", 147);
            this.define("make-rectangular", 101);
            this.define("make-string", 99);
            this.define("make-vector", 65);
            this.define("make-immutable-vector", 130);
            this.define("native-library-name", 74);
            this.define("native-library-version", 75);
            this.define("max-float-precision", 9);
            this.define("min-float-precision", 10);
            this.define("null-environment", 73);
            this.define("null?", 14);
            this.define("number?", 27);
            this.define("numerator", 66);
            this.define("pair?", 17);
            this.define("parameter?", 40);
            this.define("permit-interrupts", 8);
            this.define("procedure?", 35);
            this.define("quotient", 90);
            this.define("real-part", 68);
            this.define("remainder", 89);
            this.define("round", 50);
            this.define("set-box!", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 94);
            this.define("set-car!", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 87);
            this.define("set-cdr!", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 88);
            this.define("_signal-hook!", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 127);
            this.define("_signal-unhook!", class$sisc$modules$Primitives$Complex == null ? (class$sisc$modules$Primitives$Complex = Primitives.class$("sisc.modules.Primitives$Complex")) : class$sisc$modules$Primitives$Complex, 128);
            this.define("sin", 19);
            this.define("sqrt", 26);
            this.define("sleep", 78);
            this.define("string->symbol", 42);
            this.define("string->uninterned-symbol", 71);
            this.define("string-length", 60);
            this.define("string=?", 139);
            this.define("string-ref", 95);
            this.define("string?", 31);
            this.define("symbol->string", 41);
            this.define("symbol?", 29);
            this.define("syntactic-token?", 6);
            this.define("syntactic-token->string", 125);
            this.define("system-time", 3);
            this.define("tan", 21);
            this.define("time-zone-offset", 4);
            this.define("truncate", 51);
            this.define("unbox", 57);
            this.define("vector->list", 45);
            this.define("vector-length", 61);
            this.define("vector-ref", 96);
            this.define("vector?", 28);
            this.define("void", 5);
            this.define("void?", 33);
        }
    }

    public static class CircularityDetector
    implements ExpressionVisitor {
        private Map trailMap = new HashMap(1);
        private LinkedList trail = new LinkedList();
        private ExpressionVisitee element;
        private LinkedList components;

        public boolean isCircular(ExpressionVisitee expressionVisitee) {
            this.element = expressionVisitee;
            this.components = null;
            boolean bl = this.isCircular();
            this.element = null;
            this.components = null;
            this.trailMap.clear();
            this.trail.clear();
            return bl;
        }

        private boolean isCircular() {
            while (this.element.visit(this)) {
                if (this.components == null) {
                    while (true) {
                        if (this.trail.isEmpty()) {
                            return false;
                        }
                        this.element = (ExpressionVisitee)this.trail.getLast();
                        this.components = (LinkedList)this.trailMap.get(this.element);
                        if (this.components.isEmpty()) {
                            this.trail.removeLast();
                            this.trailMap.remove(this.element);
                            continue;
                        }
                        break;
                    }
                } else {
                    this.trailMap.put(this.element, this.components);
                    this.trail.addLast(this.element);
                }
                this.element = (ExpressionVisitee)this.components.removeFirst();
                this.components = null;
            }
            return true;
        }

        public boolean visit(ExpressionVisitee expressionVisitee) {
            if (expressionVisitee == null) {
                return true;
            }
            if (this.element.equals(expressionVisitee) || this.trailMap.containsKey(expressionVisitee)) {
                return false;
            }
            if (this.components == null) {
                this.components = new LinkedList();
            }
            this.components.addLast(expressionVisitee);
            return true;
        }
    }
}

