/*
 * Decompiled with CFR 0.152.
 */
package sisc.io.custom;

import java.io.IOException;
import java.io.InputStream;
import sisc.data.Pair;
import sisc.data.Procedure;
import sisc.data.Quantity;
import sisc.data.Value;
import sisc.io.custom.CustomPortProxy;
import sisc.io.custom.IOUtils;
import sisc.modules.io.Buffer;
import sisc.util.Util;

public class SchemeInputStream
extends InputStream
implements CustomPortProxy {
    Procedure read;
    Procedure readBlock;
    Procedure available;
    Procedure close;
    Value host;

    public SchemeInputStream(Procedure procedure, Procedure procedure2, Procedure procedure3, Procedure procedure4) {
        this.read = procedure;
        this.readBlock = procedure2;
        this.available = procedure3;
        this.close = procedure4;
    }

    public int read() throws IOException {
        return Util.num(IOUtils.bridge(this.read, this.getHost())).intValue();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return Util.num(IOUtils.bridge(this.readBlock, new Value[]{this.getHost(), new Buffer(byArray), Quantity.valueOf(n), Quantity.valueOf(n2)})).intValue();
    }

    public int available() throws IOException {
        return Util.num(IOUtils.bridge(this.available, this.getHost())).intValue();
    }

    public void close() throws IOException {
        IOUtils.bridge(this.close, this.getHost());
    }

    public Pair getProcs() {
        return Util.list(this.read, this.readBlock, this.available, this.close);
    }

    public Value getHost() {
        return this.host;
    }

    public void setHost(Value value) {
        this.host = value;
    }
}

