/*
 * Decompiled with CFR 0.152.
 */
package sisc.interpreter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sisc.data.Expression;
import sisc.data.ExpressionValue;
import sisc.data.Pair;
import sisc.data.Quantity;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;
import sisc.util.ExpressionVisitee;
import sisc.util.ExpressionVisitor;
import sisc.util.Util;

public class StackTracer
implements Cloneable,
ExpressionVisitee {
    private static Symbol UNKNOWN = Symbol.get("?");
    private int maxDepth = 16;
    private List stack = new ArrayList();
    private List toAdd = new ArrayList();
    private boolean overflown = false;
    private static final int WRAPPER = 0;
    private static final int REPETITION = 1;
    private static final int EXPR = 2;

    public StackTracer(int n) {
        this.maxDepth = n;
    }

    public StackTracer() {
    }

    private static boolean addTailToPreceedingRepetition(List list) {
        int n = list.size();
        for (int i = n - 2; i >= 0; --i) {
            Object e = list.get(i);
            if (!(e instanceof Repetition)) continue;
            Repetition repetition = (Repetition)e;
            List list2 = list.subList(i + 1, n);
            if (!((Object)repetition.exprs).equals(list2)) continue;
            ++repetition.count;
            list2.clear();
            return true;
        }
        return false;
    }

    private static boolean createRepetitionFromTail(List list) {
        int n = list.size();
        for (int i = n - 1; i >= (n + 1) / 2; --i) {
            List list2 = list.subList(i, n);
            if (!((Object)list2).equals(list.subList(2 * i - n, i))) continue;
            Repetition repetition = new Repetition(2, new ArrayList(list2));
            list.subList(2 * i - n, n).clear();
            list.add(repetition);
            return true;
        }
        return false;
    }

    private static void compact(List list) {
        while (StackTracer.addTailToPreceedingRepetition(list) || StackTracer.createRepetitionFromTail(list)) {
        }
    }

    private void addAll() {
        Iterator iterator = this.toAdd.iterator();
        while (iterator.hasNext()) {
            Expression expression = (Expression)iterator.next();
            this.stack.add(new Wrapper(expression));
            StackTracer.compact(this.stack);
        }
        this.toAdd.clear();
    }

    public void add(Expression expression) {
        this.toAdd.add(expression);
        if (this.toAdd.size() + this.stack.size() > this.maxDepth) {
            this.addAll();
            if (this.stack.size() > this.maxDepth) {
                this.stack.subList(0, this.maxDepth / 2).clear();
                this.overflown = true;
            }
        }
    }

    public void clear() {
        this.stack.clear();
        this.toAdd.clear();
        this.overflown = false;
    }

    public Object clone() throws CloneNotSupportedException {
        StackTracer stackTracer = new StackTracer(this.maxDepth);
        stackTracer.toAdd.addAll(this.toAdd);
        Iterator iterator = this.stack.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            stackTracer.stack.add(e instanceof Repetition ? ((Repetition)e).copy() : e);
        }
        stackTracer.overflown = this.overflown;
        return stackTracer;
    }

    public StackTracer copy() {
        try {
            return (StackTracer)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this;
        }
    }

    private static Value deepListToValue(List list) {
        Pair pair = Util.EMPTYLIST;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Repetition) {
                Repetition repetition = (Repetition)e;
                pair = new Pair(new Pair(Quantity.valueOf(repetition.count), StackTracer.deepListToValue(repetition.exprs)), pair);
                continue;
            }
            pair = new Pair(new ExpressionValue(((Wrapper)e).expr), pair);
        }
        return pair;
    }

    public Value toValue() {
        this.addAll();
        return new Pair(Util.truth(this.overflown), StackTracer.deepListToValue(this.stack));
    }

    public void serialize(Serializer serializer) throws IOException {
        serializer.writeInt(this.maxDepth);
        serializer.writeBoolean(this.overflown);
        StackTracer.writeList(serializer, this.toAdd);
        StackTracer.writeList(serializer, this.stack);
    }

    private static void writeList(Serializer serializer, List list) throws IOException {
        serializer.writeInt(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (e instanceof Wrapper) {
                serializer.writeInt(0);
                serializer.writeExpression(((Wrapper)e).expr);
                continue;
            }
            if (e instanceof Repetition) {
                serializer.writeInt(1);
                Repetition repetition = (Repetition)e;
                serializer.writeInt(repetition.count);
                StackTracer.writeList(serializer, repetition.exprs);
                continue;
            }
            if (!(e instanceof Expression)) continue;
            serializer.writeInt(2);
            serializer.writeExpression((Expression)e);
        }
    }

    private static List readList(Deserializer deserializer) throws IOException {
        int n = deserializer.readInt();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        block5: for (int i = 0; i < n; ++i) {
            int n2 = deserializer.readInt();
            switch (n2) {
                case 0: {
                    Expression expression = deserializer.readExpression();
                    arrayList.add(new Wrapper(expression));
                    continue block5;
                }
                case 1: {
                    int n3 = deserializer.readInt();
                    List list = StackTracer.readList(deserializer);
                    arrayList.add(new Repetition(n3, list));
                    continue block5;
                }
                case 2: {
                    arrayList.add(deserializer.readExpression());
                }
            }
        }
        return arrayList;
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        this.maxDepth = deserializer.readInt();
        this.overflown = deserializer.readBoolean();
        this.toAdd = StackTracer.readList(deserializer);
        this.stack = StackTracer.readList(deserializer);
    }

    private static boolean visitList(ExpressionVisitor expressionVisitor, List list) {
        boolean bl = true;
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (e instanceof Wrapper) {
                bl = expressionVisitor.visit(((Wrapper)e).expr) && bl;
            } else if (e instanceof Repetition) {
                Repetition repetition = (Repetition)e;
                bl = StackTracer.visitList(expressionVisitor, repetition.exprs) && bl;
            } else if (e instanceof Expression) {
                boolean bl2 = bl = expressionVisitor.visit((Expression)e) && bl;
            }
            if (bl) continue;
            return false;
        }
        return bl;
    }

    public boolean visit(ExpressionVisitor expressionVisitor) {
        return StackTracer.visitList(expressionVisitor, this.toAdd) && StackTracer.visitList(expressionVisitor, this.stack);
    }

    private static class Repetition
    implements Cloneable {
        public int count;
        public List exprs;

        public Repetition(int n, List list) {
            this.count = n;
            this.exprs = list;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Repetition)) {
                return false;
            }
            Repetition repetition = (Repetition)object;
            return repetition.count == this.count && ((Object)repetition.exprs).equals(this.exprs);
        }

        public Object clone() throws CloneNotSupportedException {
            return new Repetition(this.count, this.exprs);
        }

        public Repetition copy() {
            try {
                return (Repetition)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return this;
            }
        }
    }

    private static class Wrapper {
        public Expression expr;

        public Wrapper(Expression expression) {
            this.expr = expression;
        }

        public int hashCode() {
            return System.identityHashCode(this.expr);
        }

        public boolean equals(Object object) {
            return object instanceof Wrapper && ((Wrapper)object).expr == this.expr;
        }
    }
}

