/*
 * Decompiled with CFR 0.152.
 */
package sisc.interpreter;

import java.io.PrintStream;
import java.io.PrintWriter;
import sisc.data.Pair;
import sisc.data.Procedure;
import sisc.data.SchemeString;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.interpreter.Context;
import sisc.interpreter.Interpreter;
import sisc.interpreter.SchemeCaller;
import sisc.util.Util;

public class SchemeException
extends Exception {
    public Pair m;
    public Procedure e;
    public Procedure f;

    public SchemeException(Pair pair, Procedure procedure, Procedure procedure2) {
        this.m = pair;
        this.e = procedure;
        this.f = procedure2;
    }

    public String getMessage() {
        return this.m.toString();
    }

    public String getMessageText() {
        return ((Pair)this.m.car()).cdr().toString();
    }

    private String schemeStackTrace() {
        try {
            SchemeString schemeString = (SchemeString)Context.execute(new SchemeCaller(){

                public Object execute(Interpreter interpreter) throws SchemeException {
                    Procedure procedure = (Procedure)interpreter.lookup(Symbol.get("error->string"), Util.TOPLEVEL);
                    return interpreter.eval(procedure, new Value[]{SchemeException.this.m, SchemeException.this.e});
                }
            });
            return "Scheme exception:\n" + schemeString.asString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void printStackTrace(PrintStream printStream) {
        super.printStackTrace(printStream);
        printStream.print(this.schemeStackTrace());
    }

    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        printWriter.print(this.schemeStackTrace());
    }
}

