/*
 * Decompiled with CFR 0.152.
 */
package sisc.interpreter;

import java.io.IOException;
import java.security.AccessControlException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import sisc.env.DynamicEnvironment;
import sisc.interpreter.AppContext;
import sisc.interpreter.Interpreter;
import sisc.interpreter.SchemeCaller;
import sisc.interpreter.SchemeException;
import sisc.interpreter.ThreadContext;
import sisc.util.Util;

public abstract class Context
extends Util {
    private static Map apps = Collections.synchronizedMap(new HashMap());
    private static ThreadLocal currentThreadContext = new ThreadLocal(){

        protected Object initialValue() {
            return new ThreadContext();
        }
    };
    private static volatile AppContext defaultAppContext;

    public static void register(String string, AppContext appContext) {
        apps.put(string, appContext);
    }

    public static void unregister(String string) {
        apps.remove(string);
    }

    public static AppContext lookup(String string) {
        return (AppContext)apps.get(string);
    }

    public static ThreadContext lookupThreadContext() {
        return (ThreadContext)currentThreadContext.get();
    }

    public static Interpreter currentInterpreter() {
        ThreadContext threadContext = Context.lookupThreadContext();
        return threadContext.currentInterpreter();
    }

    public static Interpreter currentInterpreter(AppContext appContext) {
        ThreadContext threadContext = Context.lookupThreadContext();
        return threadContext.currentInterpreter(appContext);
    }

    public static synchronized void setDefaultAppContext(AppContext appContext) {
        defaultAppContext = appContext;
    }

    public static synchronized AppContext getDefaultAppContext() {
        if (defaultAppContext == null) {
            Context.setDefaultAppContext(new AppContext());
            try {
                defaultAppContext.addDefaultHeap();
            }
            catch (IOException iOException) {
                throw new RuntimeException(Util.liMessage(Util.SISCB, "errorloadingheap"));
            }
        }
        return defaultAppContext;
    }

    public static AppContext currentAppContext() {
        Interpreter interpreter = Context.currentInterpreter();
        return interpreter == null ? Context.getDefaultAppContext() : interpreter.getCtx();
    }

    public static Interpreter enter() {
        Interpreter interpreter = Context.currentInterpreter();
        return Context.enter(interpreter == null ? new DynamicEnvironment(Context.getDefaultAppContext()) : interpreter.dynenv);
    }

    public static Interpreter enter(AppContext appContext) {
        Interpreter interpreter = Context.currentInterpreter(appContext);
        return Context.enter(interpreter == null ? new DynamicEnvironment(appContext) : interpreter.dynenv);
    }

    public static Interpreter enter(DynamicEnvironment dynamicEnvironment) {
        dynamicEnvironment.bind();
        ClassLoader classLoader = Util.currentClassLoader();
        ClassLoader classLoader2 = Context.determineClassLoader(classLoader, dynamicEnvironment.getClassLoader());
        Thread thread = Thread.currentThread();
        try {
            thread.setContextClassLoader(classLoader2);
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        ThreadContext threadContext = Context.lookupThreadContext();
        threadContext.setHostThread(dynamicEnvironment, thread);
        Interpreter interpreter = Context.createInterpreter(threadContext, dynamicEnvironment);
        threadContext.pushState(new ThreadContext.State(interpreter, classLoader));
        return interpreter;
    }

    private static ClassLoader determineClassLoader(ClassLoader classLoader, ClassLoader classLoader2) {
        try {
            for (ClassLoader classLoader3 = classLoader2; classLoader3 != null; classLoader3 = classLoader3.getParent()) {
                if (classLoader != classLoader3) continue;
                return classLoader2;
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        return classLoader;
    }

    public static Interpreter enter(String string) {
        return Context.enter(Context.lookup(string));
    }

    public static void exit() {
        ThreadContext threadContext = Context.lookupThreadContext();
        ThreadContext.State state = threadContext.popState();
        Interpreter interpreter = state.interpreter;
        Context.returnInterpreter(interpreter);
        try {
            Thread.currentThread().setContextClassLoader(state.classLoader);
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    public static Object execute(SchemeCaller schemeCaller) throws SchemeException {
        Interpreter interpreter = Context.currentInterpreter();
        return Context.execute(interpreter == null ? new DynamicEnvironment(Context.getDefaultAppContext()) : interpreter.dynenv, schemeCaller);
    }

    public static Object execute(AppContext appContext, SchemeCaller schemeCaller) throws SchemeException {
        Interpreter interpreter = Context.currentInterpreter(appContext);
        return Context.execute(interpreter == null ? new DynamicEnvironment(appContext) : interpreter.dynenv, schemeCaller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object execute(DynamicEnvironment dynamicEnvironment, SchemeCaller schemeCaller) throws SchemeException {
        Interpreter interpreter = Context.enter(dynamicEnvironment);
        Object t = interpreter.tctx.hostThread.get();
        try {
            Object object = schemeCaller.execute(interpreter);
            return object;
        }
        finally {
            if (interpreter != null) {
                Context.exit();
            }
        }
    }

    public static Object execute(String string, SchemeCaller schemeCaller) {
        try {
            return Context.execute(Context.lookup(string), schemeCaller);
        }
        catch (SchemeException schemeException) {
            System.err.println(Context.warn("SchemeException caught from execute:" + schemeException.getMessage()));
            return null;
        }
    }

    private static Interpreter createInterpreter(ThreadContext threadContext, DynamicEnvironment dynamicEnvironment) {
        return new Interpreter(threadContext, dynamicEnvironment);
    }

    private static void returnInterpreter(Interpreter interpreter) {
    }
}

