/*
 * Decompiled with CFR 0.152.
 */
package sisc.exprs.fp;

import java.io.IOException;
import sisc.compiler.Compiler;
import sisc.data.Expression;
import sisc.data.Immediate;
import sisc.data.Procedure;
import sisc.data.Value;
import sisc.exprs.AppExp;
import sisc.exprs.FreeReferenceExp;
import sisc.exprs.fp.OptimismUnwarrantedException;
import sisc.exprs.fp.OptimisticExpression;
import sisc.exprs.fp.OptimisticHost;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.nativefun.FixableProcedure;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;
import sisc.util.ExpressionVisitor;
import sisc.util.FreeReference;
import sisc.util.UndefinedVarException;

public class FixedAppExp_0
extends Expression
implements Immediate,
OptimisticExpression {
    transient FixableProcedure proc;
    public FreeReference ref;
    public OptimisticHost host;
    public int uexpPosition;

    public FixedAppExp_0(FreeReference freeReference) {
        this.ref = freeReference;
    }

    public void setHost(OptimisticHost optimisticHost, int n) {
        this.host = optimisticHost;
        this.uexpPosition = n;
    }

    public void eval(Interpreter interpreter) throws ContinuationException {
        interpreter.acc = this.getValue(interpreter);
        interpreter.nxp = null;
    }

    public Value doGetValue(FixableProcedure fixableProcedure, Interpreter interpreter) throws ContinuationException {
        return fixableProcedure.apply();
    }

    public Value getValue(Interpreter interpreter) throws ContinuationException {
        try {
            Value value = this.ref.getValue();
            if (value != this.proc) {
                if (value instanceof FixableProcedure) {
                    this.proc = (FixableProcedure)value;
                } else {
                    this.revert(interpreter);
                }
            }
            return this.doGetValue(this.proc, interpreter);
        }
        catch (UndefinedVarException undefinedVarException) {
            this.forceRevert(interpreter);
        }
        catch (OptimismUnwarrantedException optimismUnwarrantedException) {
            throw optimismUnwarrantedException;
        }
        catch (RuntimeException runtimeException) {
            this.forceRevert(interpreter);
        }
        return null;
    }

    public Expression[] getOperands() {
        return ZV;
    }

    public final void forceRevert(Interpreter interpreter) {
        this.revert(interpreter, this.getOperands(), 1);
    }

    public final void revert(Interpreter interpreter) {
        this.revert(interpreter, this.getOperands());
    }

    public final void revert(Interpreter interpreter, Expression[] expressionArray) {
        this.revert(interpreter, expressionArray, 0);
    }

    public final void revert(Interpreter interpreter, Expression[] expressionArray, int n) {
        if (this.host == null) {
            Procedure.throwPrimException(FixedAppExp_0.liMessage(SISCB, "nosafeexpr"));
        }
        try {
            AppExp appExp = (AppExp)Compiler.application(interpreter, new FreeReferenceExp(this.ref), expressionArray, n, this.getAnnotations(), interpreter.getCtx().symenv);
            if (appExp instanceof OptimisticExpression) {
                ((OptimisticExpression)((Object)appExp)).setHost(this.host, this.uexpPosition);
            }
            this.host.alter(interpreter, this.uexpPosition, appExp);
            throw new OptimismUnwarrantedException();
        }
        catch (ContinuationException continuationException) {
            Procedure.throwPrimException(continuationException.getMessage());
            return;
        }
    }

    public Value express() {
        return FixedAppExp_0.list(FixedAppExp_0.sym("fapp"), this.ref.express());
    }

    public void serialize(Serializer serializer) throws IOException {
        this.ref.serialize(serializer);
        serializer.writeExpression((Expression)((Object)this.host));
        serializer.writeInt(this.uexpPosition);
    }

    public FixedAppExp_0() {
        this.ref = new FreeReference();
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        this.ref.deserialize(deserializer);
        this.host = (OptimisticHost)((Object)deserializer.readExpression());
        this.uexpPosition = deserializer.readInt();
    }

    public boolean visit(ExpressionVisitor expressionVisitor) {
        return this.ref.visit(expressionVisitor) && expressionVisitor.visit((Expression)((Object)this.host));
    }

    public void dropSafe() {
        this.host = null;
    }
}

