/*
 * Decompiled with CFR 0.152.
 */
package sisc.exprs;

import java.io.IOException;
import sisc.data.Box;
import sisc.data.Expression;
import sisc.data.Value;
import sisc.exprs.fp.OptimismUnwarrantedException;
import sisc.exprs.fp.OptimisticHost;
import sisc.exprs.fp.Utils;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;
import sisc.util.ExpressionVisitor;

public class LetrecEval
extends Expression
implements OptimisticHost {
    public Expression body;

    public LetrecEval(Expression expression) {
        this.body = expression;
    }

    public void setHosts() {
        Utils.linkOptimistic(this, this.body, 0);
    }

    public void eval(Interpreter interpreter) throws ContinuationException {
        int n;
        for (n = interpreter.vlr.length - 1; n >= 0; --n) {
            ((Box)interpreter.lcl[n]).val = interpreter.vlr[n];
        }
        do {
            try {
                interpreter.next(this.body);
                n = 0;
            }
            catch (OptimismUnwarrantedException optimismUnwarrantedException) {
                n = 1;
            }
        } while (n != 0);
    }

    public Value express() {
        return LetrecEval.list(LetrecEval.sym("letrec-eval"), this.body.express());
    }

    public LetrecEval() {
    }

    public void serialize(Serializer serializer) throws IOException {
        serializer.writeExpression(this.body);
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        this.body = deserializer.readExpression();
    }

    public boolean visit(ExpressionVisitor expressionVisitor) {
        return expressionVisitor.visit(this.body);
    }

    public synchronized void alter(Interpreter interpreter, int n, Expression expression) {
        this.body = expression;
    }
}

