/*
 * Decompiled with CFR 0.152.
 */
package sisc.exprs;

import java.io.IOException;
import sisc.data.Closure;
import sisc.data.Expression;
import sisc.data.Immediate;
import sisc.data.Pair;
import sisc.data.Quantity;
import sisc.data.Value;
import sisc.env.LexicalUtils;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;
import sisc.util.ExpressionVisitor;

public class LambdaExp
extends Expression
implements Immediate {
    public boolean infiniteArity;
    public int fcount;
    public int lcount;
    public int[] localIndices;
    public int[] lexicalIndices;
    public int[] boxes;
    public Expression body;

    public LambdaExp(int n, Expression expression, boolean bl, int[] nArray, int[] nArray2, int[] nArray3) {
        this.infiniteArity = bl;
        this.fcount = n;
        this.body = expression;
        this.localIndices = nArray;
        this.lexicalIndices = nArray2;
        this.boxes = nArray3;
        this.lcount = nArray.length + nArray2.length;
    }

    public void eval(Interpreter interpreter) throws ContinuationException {
        interpreter.acc = this.getValue(interpreter);
        interpreter.nxp = null;
    }

    public Value getValue(Interpreter interpreter) throws ContinuationException {
        return new Closure(this.infiniteArity, this.fcount, this.body, LexicalUtils.fixLexicals(interpreter, this.lcount, this.localIndices, this.lexicalIndices), this.boxes);
    }

    public Value express() {
        Pair pair = LexicalUtils.intArrayToList(this.localIndices);
        Pair pair2 = LexicalUtils.intArrayToList(this.lexicalIndices);
        Pair pair3 = LexicalUtils.intArrayToList(this.boxes);
        return LambdaExp.list(LambdaExp.sym("lambda"), new Pair(LambdaExp.truth(this.infiniteArity), new Pair(Quantity.valueOf(this.fcount), pair3)), LambdaExp.list(pair, pair2), this.body.express());
    }

    public void serialize(Serializer serializer) throws IOException {
        serializer.writeBoolean(this.infiniteArity);
        serializer.writeInt(this.fcount);
        LexicalUtils.writeIntArray(serializer, this.localIndices);
        LexicalUtils.writeIntArray(serializer, this.lexicalIndices);
        LexicalUtils.writeIntArray(serializer, this.boxes);
        serializer.writeExpression(this.body);
    }

    public LambdaExp() {
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        this.infiniteArity = deserializer.readBoolean();
        this.fcount = deserializer.readInt();
        this.localIndices = LexicalUtils.readIntArray(deserializer);
        this.lexicalIndices = LexicalUtils.readIntArray(deserializer);
        this.lcount = (this.localIndices == null ? 0 : this.localIndices.length) + (this.lexicalIndices == null ? 0 : this.lexicalIndices.length);
        this.boxes = LexicalUtils.readIntArray(deserializer);
        this.body = deserializer.readExpression();
    }

    public boolean visit(ExpressionVisitor expressionVisitor) {
        return expressionVisitor.visit(this.body);
    }
}

