/*
 * Decompiled with CFR 0.152.
 */
package sisc.exprs;

import java.io.IOException;
import sisc.data.Expression;
import sisc.data.Pair;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.env.SymbolicEnvironment;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;
import sisc.util.ExpressionVisitor;
import sisc.util.FreeReference;
import sisc.util.UndefinedVarException;

public class FreeSetEval
extends Expression {
    private FreeReference ref;

    public FreeSetEval(Symbol symbol, SymbolicEnvironment symbolicEnvironment) {
        this.ref = new FreeReference(symbol, symbolicEnvironment);
    }

    public void eval(Interpreter interpreter) throws ContinuationException {
        this.setValue(interpreter, interpreter.acc);
        interpreter.acc = VOID;
        interpreter.nxp = null;
    }

    public void setValue(Interpreter interpreter, Value value) throws ContinuationException {
        try {
            this.ref.setValue(value);
        }
        catch (UndefinedVarException undefinedVarException) {
            FreeSetEval.error(interpreter, FreeSetEval.liMessage(SISCB, "undefinedvar", undefinedVarException.var));
        }
    }

    public void serialize(Serializer serializer) throws IOException {
        this.ref.serialize(serializer);
    }

    public Value express() {
        return new Pair(FreeSetEval.sym("ref!"), this.ref.express());
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        this.ref.deserialize(deserializer);
    }

    public FreeSetEval() {
        this.ref = new FreeReference();
    }

    public boolean equals(Object object) {
        if (!(object instanceof FreeSetEval)) {
            return false;
        }
        FreeSetEval freeSetEval = (FreeSetEval)object;
        return this.ref.equals(freeSetEval.ref);
    }

    public int hashCode() {
        return this.ref.hashCode();
    }

    public boolean visit(ExpressionVisitor expressionVisitor) {
        return this.ref.visit(expressionVisitor);
    }
}

