/*
 * Decompiled with CFR 0.152.
 */
package sisc.exprs;

import java.io.IOException;
import sisc.compiler.Compiler;
import sisc.data.Expression;
import sisc.data.Immediate;
import sisc.data.Pair;
import sisc.data.Value;
import sisc.exprs.FillRibExp;
import sisc.exprs.fp.OptimismUnwarrantedException;
import sisc.exprs.fp.OptimisticExpression;
import sisc.exprs.fp.OptimisticHost;
import sisc.exprs.fp.Utils;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;
import sisc.util.ExpressionVisitor;

public class AppExp
extends Expression
implements OptimisticHost {
    public static final int POS_EXP = -1;
    public static final int POS_NXP = -2;
    public Expression exp;
    public Expression[] rands;
    public Expression nxp;
    public boolean allImmediate;
    protected int l;

    public AppExp(Expression expression, Expression[] expressionArray, Expression expression2, boolean bl) {
        this.exp = expression;
        this.rands = expressionArray;
        this.l = expressionArray.length;
        this.nxp = expression2;
        this.allImmediate = bl;
    }

    public void setHosts() {
        if (!this.allImmediate || this.haveOptimisticRands()) {
            Utils.assertNonOptimistic(this.nxp);
        }
        Utils.linkOptimistic(this, this.exp, -1);
        Utils.linkOptimistic(this, this.nxp, -2);
        for (int i = 0; i < this.rands.length; ++i) {
            Utils.linkOptimistic(this, this.rands[i], i);
        }
    }

    private boolean haveOptimisticRands() {
        for (int i = 0; i < this.rands.length; ++i) {
            if (!(this.rands[i] instanceof OptimisticExpression)) continue;
            return true;
        }
        return false;
    }

    public void eval(Interpreter interpreter) throws ContinuationException {
        boolean bl;
        interpreter.newVLR(this.l);
        do {
            try {
                if (this.allImmediate) {
                    interpreter.acc = this.exp.getValue(interpreter);
                    for (int i = this.l - 1; i >= 0; --i) {
                        interpreter.vlr[i] = this.rands[i].getValue(interpreter);
                    }
                    interpreter.next(this.nxp);
                } else {
                    for (int i = this.l - 1; i >= 0; --i) {
                        Expression expression = this.rands[i];
                        if (expression == null) continue;
                        interpreter.vlr[i] = expression.getValue(interpreter);
                    }
                    interpreter.push(this.nxp);
                    interpreter.next(this.exp);
                }
                bl = false;
            }
            catch (OptimismUnwarrantedException optimismUnwarrantedException) {
                bl = true;
            }
        } while (bl);
    }

    public Value express() {
        Pair pair = EMPTYLIST;
        for (int i = this.rands.length - 1; i >= 0; --i) {
            pair = new Pair(this.rands[i] == null ? VOID : this.rands[i].express(), pair);
        }
        return AppExp.list(AppExp.sym("app"), pair, this.exp.express(), this.nxp.express());
    }

    public void serialize(Serializer serializer) throws IOException {
        serializer.writeExpression(this.exp);
        serializer.writeInt(this.l);
        for (int i = 0; i < this.l; ++i) {
            serializer.writeExpression(this.rands[i]);
        }
        serializer.writeExpression(this.nxp);
        serializer.writeBoolean(this.allImmediate);
    }

    public AppExp() {
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        this.exp = deserializer.readExpression();
        this.l = deserializer.readInt();
        this.rands = new Expression[this.l];
        for (int i = 0; i < this.l; ++i) {
            this.rands[i] = deserializer.readExpression();
        }
        this.nxp = deserializer.readExpression();
        this.allImmediate = deserializer.readBoolean();
    }

    public boolean visit(ExpressionVisitor expressionVisitor) {
        if (!expressionVisitor.visit(this.exp)) {
            return false;
        }
        for (int i = 0; i < this.rands.length; ++i) {
            if (expressionVisitor.visit(this.rands[i])) continue;
            return false;
        }
        return expressionVisitor.visit(this.nxp);
    }

    public synchronized void alter(Interpreter interpreter, int n, Expression expression) {
        switch (n) {
            case -1: {
                this.exp = expression;
                break;
            }
            case -2: {
                this.nxp = expression;
                break;
            }
            default: {
                if (expression instanceof Immediate) {
                    this.rands[n] = expression;
                    break;
                }
                this.nxp = Compiler.makeFillRib(interpreter, this.exp, expression, n, this.nxp, false);
                this.exp = expression;
                this.rands[n] = null;
                ((FillRibExp)this.nxp).setHosts();
            }
        }
        if (this.allImmediate && !(expression instanceof Immediate)) {
            this.allImmediate = false;
        }
    }
}

