/*
 * Decompiled with CFR 0.152.
 */
package sisc.env;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import sisc.data.Value;
import sisc.env.Parameter;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.io.ValueWriter;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;

public class NativeParameter
extends Parameter {
    private Method readMethod;
    private Method writeMethod;
    private String fieldName;
    static /* synthetic */ Class class$sisc$env$DynamicEnvironment;

    public NativeParameter() {
    }

    public NativeParameter(String string) {
        this.fieldName = string;
        this.init();
    }

    private void init() {
        try {
            PropertyDescriptor[] propertyDescriptorArray = Introspector.getBeanInfo(class$sisc$env$DynamicEnvironment == null ? (class$sisc$env$DynamicEnvironment = NativeParameter.class$("sisc.env.DynamicEnvironment")) : class$sisc$env$DynamicEnvironment).getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                if (!propertyDescriptor.getName().equals(this.fieldName)) continue;
                this.readMethod = propertyDescriptor.getReadMethod();
                this.writeMethod = propertyDescriptor.getWriteMethod();
                return;
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        throw new RuntimeException(NativeParameter.liMessage(SISCB, "nativeparamnotfound", this.fieldName));
    }

    public Value getValue(Interpreter interpreter) throws ContinuationException {
        try {
            return (Value)this.readMethod.invoke((Object)interpreter.dynenv, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            NativeParameter.error(interpreter, NativeParameter.liMessage(SISCB, "nativeparamaccess", invocationTargetException.getMessage()));
        }
        catch (IllegalAccessException illegalAccessException) {
            NativeParameter.error(interpreter, NativeParameter.liMessage(SISCB, "nativeparamaccess", illegalAccessException.getMessage()));
        }
        return null;
    }

    public void setValue(Interpreter interpreter, Value value) throws ContinuationException {
        try {
            this.writeMethod.invoke((Object)interpreter.dynenv, value);
        }
        catch (InvocationTargetException invocationTargetException) {
            NativeParameter.error(interpreter, NativeParameter.liMessage(SISCB, "nativeparamaccess", invocationTargetException.getMessage()));
            throw new RuntimeException(invocationTargetException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            NativeParameter.error(interpreter, NativeParameter.liMessage(SISCB, "nativeparamaccess", illegalAccessException.getMessage()));
        }
    }

    public void display(ValueWriter valueWriter) throws IOException {
        valueWriter.append("#<").append(NativeParameter.liMessage(SISCB, "nativeparameter"));
        valueWriter.append(" ").append(this.fieldName).append('>');
    }

    public void serialize(Serializer serializer) throws IOException {
        serializer.writeUTF(this.fieldName);
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        this.fieldName = deserializer.readUTF();
        this.init();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

