/*
 * Decompiled with CFR 0.152.
 */
package sisc.env;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.util.Map;
import java.util.WeakHashMap;
import sisc.data.Pair;
import sisc.data.Quantity;
import sisc.data.SchemeCharacterInputPort;
import sisc.data.SchemeCharacterOutputPort;
import sisc.data.Value;
import sisc.interpreter.AppContext;
import sisc.io.AutoflushWriter;
import sisc.io.Charset;
import sisc.reader.Lexer;
import sisc.reader.Parser;
import sisc.reader.SourceReader;
import sisc.util.Defaults;
import sisc.util.Util;

public class DynamicEnvironment
extends Util
implements Cloneable {
    public final AppContext ctx;
    public Value in;
    public Value out;
    public Pair sourceAnnotations = EMPTYLIST;
    public Charset characterSet = Util.getDefaultCharacterSet();
    public boolean caseSensitive = Defaults.CASE_SENSITIVE;
    public boolean printShared = Defaults.PRINT_SHARED;
    public boolean vectorLengthPrefixing = Defaults.VECTOR_LENGTH_PREFIXING;
    public boolean emitDebuggingSymbols = Defaults.EMIT_DEBUGGING_SYMBOLS;
    public boolean permissiveParsing = Defaults.PERMISSIVE_PARSING;
    public boolean hedgedInlining = Defaults.HEDGED_INLINING;
    public boolean internalDebugging = Defaults.INTERNAL_DEBUGGING;
    public int synopsisLength = Defaults.SYNOPSIS_LENGTH;
    public int maxStackTraceDepth = Defaults.MAX_STACK_TRACE_DEPTH;
    private static String defaultCharacterSet = Util.getDefaultCharacterSet().displayName();
    private static String defaultCaseSensitive = new Boolean(Defaults.CASE_SENSITIVE).toString();
    private static String defaultPrintShared = new Boolean(Defaults.PRINT_SHARED).toString();
    private static String defaultVectorLengthPrefixing = new Boolean(Defaults.VECTOR_LENGTH_PREFIXING).toString();
    private static String defaultEmitDebuggingSymbols = new Boolean(Defaults.EMIT_DEBUGGING_SYMBOLS).toString();
    private static String defaultPermissiveParsing = new Boolean(Defaults.PERMISSIVE_PARSING).toString();
    private static String defaultHedgedInlining = new Boolean(Defaults.HEDGED_INLINING).toString();
    private static String defaultInternalDebugging = new Boolean(Defaults.INTERNAL_DEBUGGING).toString();
    private static String defaultSynopsisLength = new Integer(Defaults.SYNOPSIS_LENGTH).toString();
    private static String defaultEmitAnnotations = new Boolean(Defaults.EMIT_ANNOTATIONS).toString();
    private static String defaultStrictR5RS = new Boolean(Defaults.STRICT_R5RS).toString();
    private static String defaultMaxStackTraceDepth = new Integer(Defaults.MAX_STACK_TRACE_DEPTH).toString();
    public Value wind = FALSE;
    public Parser parser = new Parser(new Lexer());
    private Thread bindingThread;
    private ClassLoader classLoader;
    private ExtensibleURLClassLoader urlClassLoader;
    private URL[] initialClassPathExtension;
    public Map parameters = new WeakHashMap(1);

    public DynamicEnvironment(AppContext appContext) {
        this(appContext, System.in, System.out);
    }

    public DynamicEnvironment(AppContext appContext, InputStream inputStream, OutputStream outputStream) {
        this.ctx = appContext;
        this.characterSet = Util.charsetFromString(appContext.getProperty("sisc.characterSet", defaultCharacterSet));
        try {
            this.in = new SchemeCharacterInputPort(new SourceReader((Reader)new InputStreamReader(inputStream, this.characterSet.getName()), DynamicEnvironment.liMessage(SISCB, "console")));
            this.out = new SchemeCharacterOutputPort(new AutoflushWriter(new OutputStreamWriter(outputStream, this.characterSet.getName())));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getMessage());
        }
        this.caseSensitive = appContext.getProperty("sisc.caseSensitive", defaultCaseSensitive).equals("true");
        this.printShared = appContext.getProperty("sisc.printShared", defaultPrintShared).equals("true");
        this.vectorLengthPrefixing = appContext.getProperty("sisc.vectorLengthPrefixing", defaultVectorLengthPrefixing).equals("true");
        this.emitDebuggingSymbols = appContext.getProperty("sisc.emitDebuggingSymbols", defaultEmitDebuggingSymbols).equals("true");
        this.permissiveParsing = appContext.getProperty("sisc.permissiveParsing", defaultPermissiveParsing).equals("true");
        this.hedgedInlining = appContext.getProperty("sisc.hedgedInlining", defaultHedgedInlining).equals("true");
        this.internalDebugging = appContext.getProperty("sisc.internalDebugging", defaultInternalDebugging).equals("true");
        this.synopsisLength = Integer.parseInt(appContext.getProperty("sisc.synopsisLength", defaultSynopsisLength));
        this.parser.annotate = appContext.getProperty("sisc.emitAnnotations", defaultEmitAnnotations).equals("true");
        this.parser.lexer.strictR5RS = appContext.getProperty("sisc.strictR5RS", defaultStrictR5RS).equals("true");
        this.maxStackTraceDepth = Integer.parseInt(appContext.getProperty("sisc.maxStackTraceDepth", defaultMaxStackTraceDepth));
        this.initialClassPathExtension = new URL[0];
    }

    public Value getCurrentInPort() {
        return this.in;
    }

    public Reader getCurrentInReader() {
        return DynamicEnvironment.charinreader(this.in);
    }

    public Value getCurrentOutPort() {
        return this.out;
    }

    public Writer getCurrentOutWriter() {
        return DynamicEnvironment.charoutwriter(this.out);
    }

    public Object clone() throws CloneNotSupportedException {
        DynamicEnvironment dynamicEnvironment = (DynamicEnvironment)super.clone();
        dynamicEnvironment.parser = new Parser(new Lexer());
        dynamicEnvironment.parser.annotate = this.parser.annotate;
        dynamicEnvironment.parser.lexer.strictR5RS = this.parser.lexer.strictR5RS;
        dynamicEnvironment.initialClassPathExtension = this.getClassPath();
        dynamicEnvironment.bindingThread = null;
        dynamicEnvironment.classLoader = null;
        dynamicEnvironment.urlClassLoader = null;
        WeakHashMap weakHashMap = new WeakHashMap();
        weakHashMap.putAll(dynamicEnvironment.parameters);
        dynamicEnvironment.parameters = weakHashMap;
        return dynamicEnvironment;
    }

    public DynamicEnvironment copy() {
        try {
            return (DynamicEnvironment)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this;
        }
    }

    public void bind() {
        Thread thread = Thread.currentThread();
        if (this.bindingThread == null) {
            this.bindingThread = thread;
            this.classLoader = DynamicEnvironment.currentClassLoader();
            try {
                this.urlClassLoader = new ExtensibleURLClassLoader(this.initialClassPathExtension, this.classLoader);
            }
            catch (AccessControlException accessControlException) {}
        } else if (this.bindingThread != thread) {
            throw new RuntimeException(DynamicEnvironment.liMessage(SISCB, "dynenvrebind"));
        }
    }

    public ClassLoader getClassLoader() {
        return this.urlClassLoader == null ? this.classLoader : this.urlClassLoader;
    }

    public URL[] getClassPath() {
        return this.urlClassLoader == null ? new URL[]{} : this.urlClassLoader.getURLs();
    }

    public void extendClassPath(URL uRL) {
        if (this.urlClassLoader == null) {
            return;
        }
        this.urlClassLoader.addURL(uRL);
    }

    public Value getInputPort() {
        return this.in;
    }

    public void setInputPort(Value value) {
        this.in = value;
    }

    public Value getOutputPort() {
        return this.out;
    }

    public void setOutputPort(Value value) {
        this.out = value;
    }

    public Value getSourceAnnotations() {
        return this.sourceAnnotations;
    }

    public void setSourceAnnotations(Value value) {
        this.sourceAnnotations = DynamicEnvironment.pair(value);
    }

    public Charset getCharacterSet() {
        return this.characterSet;
    }

    public void setCharacterSet(Value value) {
        this.characterSet = Util.charsetFromString(DynamicEnvironment.string(value));
    }

    public Value getCaseSensitive() {
        return DynamicEnvironment.truth(this.caseSensitive);
    }

    public void setCaseSensitive(Value value) {
        this.caseSensitive = DynamicEnvironment.truth(value);
    }

    public Value getPrintShared() {
        return DynamicEnvironment.truth(this.printShared);
    }

    public void setPrintShared(Value value) {
        this.printShared = DynamicEnvironment.truth(value);
    }

    public Value getVectorLengthPrefixing() {
        return DynamicEnvironment.truth(this.vectorLengthPrefixing);
    }

    public void setVectorLengthPrefixing(Value value) {
        this.vectorLengthPrefixing = DynamicEnvironment.truth(value);
    }

    public Value getEmitDebuggingSymbols() {
        return DynamicEnvironment.truth(this.emitDebuggingSymbols);
    }

    public void setEmitDebuggingSymbols(Value value) {
        this.emitDebuggingSymbols = DynamicEnvironment.truth(value);
    }

    public Value getPermissiveParsing() {
        return DynamicEnvironment.truth(this.permissiveParsing);
    }

    public void setPermissiveParsing(Value value) {
        this.permissiveParsing = DynamicEnvironment.truth(value);
    }

    public Value getHedgedInlining() {
        return DynamicEnvironment.truth(this.hedgedInlining);
    }

    public void setHedgedInlining(Value value) {
        this.hedgedInlining = DynamicEnvironment.truth(value);
    }

    public Value getInternalDebugging() {
        return DynamicEnvironment.truth(this.internalDebugging);
    }

    public void setInternalDebugging(Value value) {
        this.internalDebugging = DynamicEnvironment.truth(value);
    }

    public Value getSynopsisLength() {
        return Quantity.valueOf(this.synopsisLength);
    }

    public void setSynopsisLength(Value value) {
        this.synopsisLength = DynamicEnvironment.num(value).intValue();
    }

    public Value getEmitAnnotations() {
        return DynamicEnvironment.truth(this.parser.annotate);
    }

    public void setEmitAnnotations(Value value) {
        this.parser.annotate = DynamicEnvironment.truth(value);
    }

    public Value getStrictR5RSCompliance() {
        return DynamicEnvironment.truth(this.parser.lexer.strictR5RS);
    }

    public void setStrictR5RSCompliance(Value value) {
        this.parser.lexer.strictR5RS = DynamicEnvironment.truth(value);
    }

    public int getMaxStackTraceDepthAsInt() {
        return this.maxStackTraceDepth;
    }

    public Value getMaxStackTraceDepth() {
        return Quantity.valueOf(this.maxStackTraceDepth);
    }

    public void setMaxStackTraceDepth(Value value) {
        this.maxStackTraceDepth = DynamicEnvironment.num(value).indexValue();
    }

    private static class ExtensibleURLClassLoader
    extends URLClassLoader {
        public ExtensibleURLClassLoader(URL[] uRLArray, ClassLoader classLoader) {
            super(uRLArray, classLoader);
        }

        public void addURL(URL uRL) {
            super.addURL(uRL);
        }
    }
}

