/*
 * Decompiled with CFR 0.152.
 */
package sisc.data;

import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.StringWriter;
import sisc.data.Expression;
import sisc.data.Immediate;
import sisc.data.Symbol;
import sisc.interpreter.Context;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.io.SharedValueWriter;
import sisc.io.ValueWriter;
import sisc.util.Defaults;
import sisc.util.InternedValue;

public abstract class Value
extends Expression
implements Immediate {
    public abstract void display(ValueWriter var1) throws IOException;

    public void apply(Interpreter interpreter) throws ContinuationException {
        Value.error(interpreter, Value.liMessage(SISCB, "nonprocapp", this.synopsis()));
    }

    public String synopsis() {
        Interpreter interpreter = Context.currentInterpreter();
        return this.synopsis(interpreter == null ? Defaults.SYNOPSIS_LENGTH : interpreter.dynenv.synopsisLength);
    }

    public String synopsis(int n) {
        String string = this.toString();
        if (string.length() > n) {
            return string.substring(0, n) + "...";
        }
        return string;
    }

    public void write(ValueWriter valueWriter) throws IOException {
        this.display(valueWriter);
    }

    public boolean equals(Object object) {
        return this.eqv(object);
    }

    public boolean eqv(Object object) {
        return this == object;
    }

    public boolean valueEqual(Value value) {
        return this.eqv(value) || this.equals(value);
    }

    public int valueHashCode() {
        return this.hashCode();
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        SharedValueWriter sharedValueWriter = new SharedValueWriter(stringWriter, false, false);
        try {
            sharedValueWriter.write(this);
            stringWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public void eval(Interpreter interpreter) throws ContinuationException {
        interpreter.acc = this;
        interpreter.nxp = null;
    }

    public Value getValue(Interpreter interpreter) throws ContinuationException {
        return this;
    }

    public Value express() {
        return Value.list(Value.sym("val"), this);
    }

    public void displayNamedOpaque(ValueWriter valueWriter, String string) throws IOException {
        valueWriter.append("#<").append(string);
        Symbol symbol = this.getName();
        if (symbol != null) {
            valueWriter.append(' ').append(symbol);
        }
        valueWriter.append('>');
    }

    public Object writeReplace() throws ObjectStreamException {
        InternedValue internedValue = InternedValue.lookupByValue(this);
        return internedValue == null ? this : internedValue;
    }
}

