/*
 * Decompiled with CFR 0.152.
 */
package sisc.data;

import java.io.IOException;
import sisc.data.Quantity;
import sisc.data.Value;
import sisc.io.ValueWriter;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;
import sisc.util.ExpressionVisitor;

public class SchemeVector
extends Value {
    public Value[] vals;
    protected int lastUnique = -1;

    public SchemeVector() {
    }

    public SchemeVector(int n) {
        this(n, Quantity.ZERO);
    }

    public SchemeVector(int n, Value value) {
        this.vals = new Value[n];
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = value;
        }
    }

    public SchemeVector(Value[] valueArray) {
        this.vals = valueArray;
    }

    public boolean valueEqual(Value value) {
        if (value == this) {
            return true;
        }
        if (!(value instanceof SchemeVector)) {
            return false;
        }
        SchemeVector schemeVector = (SchemeVector)value;
        if (schemeVector.vals.length != this.vals.length) {
            return false;
        }
        for (int i = 0; i < this.vals.length; ++i) {
            if (this.vals[i].valueEqual(schemeVector.vals[i])) continue;
            return false;
        }
        return true;
    }

    public int valueHashCode() {
        int n = 0;
        for (int i = 0; i < this.vals.length; ++i) {
            n ^= this.vals[i].valueHashCode();
        }
        return n;
    }

    public int findEnd() {
        if (this.lastUnique > -1) {
            return this.lastUnique;
        }
        if (this.vals.length > 1) {
            Value value = this.vals[this.vals.length - 1];
            for (int i = this.vals.length - 2; i >= 0; --i) {
                if (this.vals[i].eqv(value)) continue;
                this.lastUnique = i + 2;
                return this.lastUnique;
            }
            this.lastUnique = 1;
            return 1;
        }
        this.lastUnique = this.vals.length;
        return this.lastUnique;
    }

    public void display(ValueWriter valueWriter) throws IOException {
        valueWriter.append('#');
        if (valueWriter.vectorLengthPrefixing()) {
            valueWriter.append(Integer.toString(this.vals.length));
        }
        valueWriter.append('(');
        int n = valueWriter.vectorLengthPrefixing() ? this.findEnd() : this.vals.length;
        for (int i = 0; i < n - 1; ++i) {
            valueWriter.append(this.vals[i]).append(' ');
        }
        if (n > 0) {
            valueWriter.append(this.vals[n - 1]);
        }
        valueWriter.append(')');
    }

    public void fill(Value value) {
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = value;
        }
        this.lastUnique = -1;
    }

    public void set(int n, Value value) {
        this.lastUnique = -1;
        this.vals[n] = value;
    }

    public String synopsis(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('#').append(this.vals.length).append('(');
        int n3 = this.findEnd();
        for (n2 = 0; n2 < n3 && stringBuffer.length() < n; ++n2) {
            stringBuffer.append(this.vals[n2].synopsis(n - stringBuffer.length()));
            if (n2 + 1 >= n3) continue;
            stringBuffer.append(' ');
        }
        if (n2 < n3) {
            stringBuffer.append("...");
        } else {
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public void serialize(Serializer serializer) throws IOException {
        serializer.writeInt(this.vals.length);
        for (int i = 0; i < this.vals.length; ++i) {
            serializer.writeExpression(this.vals[i]);
        }
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        this.vals = new Value[deserializer.readInt()];
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = (Value)deserializer.readExpression();
        }
    }

    public boolean visit(ExpressionVisitor expressionVisitor) {
        for (int i = 0; i < this.vals.length; ++i) {
            if (expressionVisitor.visit(this.vals[i])) continue;
            return false;
        }
        return true;
    }
}

