/*
 * Decompiled with CFR 0.152.
 */
package sisc.data;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import sisc.data.Singleton;
import sisc.data.Value;
import sisc.io.ValueWriter;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;

public class Quantity
extends Value
implements Singleton {
    public static final BigInteger _BI_NEGONE = BigInteger.valueOf(-1L);
    public static final BigInteger _BI_ZERO = BigInteger.valueOf(0L);
    public static final BigInteger _BI_ONE = BigInteger.valueOf(1L);
    public static final BigInteger _BI_TEN = BigInteger.valueOf(10L);
    public static final BigInteger _INT_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    public static final BigInteger _INT_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
    public static final Quantity ZERO = Quantity.valueOf(0);
    public static final Quantity IZERO = ZERO.toInexact();
    public static final Quantity ONE = Quantity.valueOf(1);
    public static final Quantity NEGONE = Quantity.valueOf(-1);
    public static final Quantity TWO = Quantity.valueOf(2);
    public static final Quantity I = Quantity.valueOf(0.0, 1.0);
    public static final Quantity TWO_I = Quantity.valueOf(0.0, 2.0);
    public static final Quantity POSITIVE_INFINITY = Quantity.valueOf(Double.POSITIVE_INFINITY);
    public static final Quantity NEGATIVE_INFINITY = Quantity.valueOf(Double.NEGATIVE_INFINITY);
    public static final Quantity HALF_PI = Quantity.valueOf(1.5707963267948966);
    public static final Quantity NaN = Quantity.valueOf(Double.NaN);
    public static final int FIXED = 1;
    public static final int EXACT = 2;
    public static final int INEXACT = 4;
    public static final int RATIONAL = 8;
    public static final int IMAGINARY = 16;
    public static final int INTEGER = 32;
    public static final int DECIMAL = 64;
    public static final int FIXEDINT = 0;
    public static final int DECIM = 1;
    public static final int INTEG = 2;
    public static final int RATIO = 3;
    public static final int COMPLEX = 4;
    public static final int POSINF = 5;
    public static final int NEGINF = 6;
    public static final int NAN = 7;
    public static final int[] characteristics = new int[]{43, 68, 42, 10, 20};
    public int type;
    public int val;
    public double d;
    public double im = 0.0;
    public BigInteger i;
    public BigInteger de = _BI_ONE;

    public static Quantity valueOf(int n) {
        return new Quantity(n);
    }

    public static Quantity valueOf(long l) {
        Quantity quantity = new Quantity(l);
        quantity.simplify();
        return quantity;
    }

    public static Quantity valueOf(double d) {
        return new Quantity(d);
    }

    public static Quantity valueOf(BigInteger bigInteger) {
        return new Quantity(bigInteger);
    }

    public static Quantity valueOf(BigDecimal bigDecimal) {
        return new Quantity(bigDecimal.doubleValue());
    }

    public static Quantity valueOf(BigInteger bigInteger, BigInteger bigInteger2) {
        return new Quantity(bigInteger, bigInteger2);
    }

    public static Quantity valueOf(Quantity quantity, Quantity quantity2) {
        return new Quantity(quantity.toInexact().doubleValue(), quantity2.toInexact().doubleValue());
    }

    public static Quantity valueOf(double d, double d2) {
        return new Quantity(d, d2);
    }

    public static Quantity valueOf(String string) {
        return Quantity.valueOf(string, 10);
    }

    public static final Quantity valueOf(String string, int n) {
        return Quantity.valueOf(string, n, true);
    }

    public static Quantity valueOf(String string, int n, boolean bl) {
        String string2;
        int n2;
        if (bl && (n2 = string.indexOf(105)) != -1) {
            float f;
            float f2;
            if (n2 != string.length() - 1) {
                throw new NumberFormatException(Quantity.liMessage(SISCB, "invalidcomplex"));
            }
            n2 = string.lastIndexOf(43);
            if (n2 == -1) {
                n2 = string.lastIndexOf(45);
                if (n2 == -1) {
                    throw new NumberFormatException(Quantity.liMessage(SISCB, "invalidcomplex"));
                }
                f2 = n2 == 0 ? 0.0f : (float)Quantity.valueOf(string.substring(0, n2), n, false).decimal();
                f = n2 + 2 == string.length() ? -1.0f : (float)Quantity.valueOf(string.substring(n2, string.length() - 1), n, false).decimal();
            } else {
                f2 = n2 == 0 ? 0.0f : (float)Quantity.valueOf(string.substring(0, n2), n, false).decimal();
                f = n2 + 2 == string.length() ? 1.0f : (float)Quantity.valueOf(string.substring(n2 + 1, string.length() - 1), n, false).decimal();
            }
            return new Quantity(f2, f);
        }
        n2 = string.indexOf(47);
        if (n2 != -1) {
            Quantity quantity = Quantity.parseUinteger(string.substring(0, n2), n);
            Quantity quantity2 = Quantity.parseUinteger(string.substring(n2 + 1), n);
            if (quantity.is(4) || quantity2.is(4)) {
                return quantity.div(quantity2);
            }
            return new Quantity(quantity.integer(), quantity2.integer());
        }
        n2 = string.indexOf(64);
        if (n2 != -1) {
            double d = Quantity.parseDecimal(string.substring(0, n2), n, true);
            double d2 = Quantity.parseDecimal(string.substring(n2 + 1), n, true);
            return new Quantity(d * Math.cos(d2), d * Math.sin(d2));
        }
        if (n == 10 && ((string2 = string.toLowerCase()).indexOf(46) != -1 || string2.indexOf(101) != -1 || string2.indexOf(115) != -1 || string2.indexOf(102) != -1 || string2.indexOf(100) != -1 || string2.indexOf(108) != -1)) {
            return new Quantity(Quantity.parseDecimal(string2, n));
        }
        return Quantity.parseUinteger(string, n);
    }

    public Quantity() {
    }

    Quantity(int n) {
        this.val = n;
        this.type = 0;
    }

    Quantity(double d) {
        this.d = d;
        this.type = 1;
    }

    Quantity(long l) {
        this.i = BigInteger.valueOf(l);
        this.type = 2;
    }

    Quantity(BigInteger bigInteger) {
        this.type = 2;
        this.i = bigInteger;
        this.simplify();
    }

    Quantity(BigInteger bigInteger, BigInteger bigInteger2) {
        this.i = bigInteger;
        this.de = bigInteger2;
        this.type = 3;
        this.simplify();
    }

    Quantity(double d, double d2) {
        this.d = d;
        this.im = d2;
        this.type = 4;
        this.simplify();
    }

    protected static int sign(double d) {
        if (d < 0.0) {
            return -1;
        }
        if (d > 0.0) {
            return 1;
        }
        return 0;
    }

    protected static boolean parsePounds(char[] cArray) {
        boolean bl = false;
        for (int i = cArray.length - 1; i >= 0 && cArray[i] == '#'; --i) {
            bl = true;
            cArray[i] = 48;
        }
        return bl;
    }

    protected static Quantity parseUinteger(String string, int n) {
        char[] cArray = string.toCharArray();
        boolean bl = Quantity.parsePounds(cArray);
        if (cArray[0] == '+' && cArray.length > 1) {
            cArray[0] = 48;
        }
        if (bl) {
            return new Quantity(Double.parseDouble(new String(cArray)));
        }
        return new Quantity(new BigInteger(new String(cArray), n));
    }

    protected static double parseDecimal(String string, int n) {
        return Quantity.parseDecimal(string, n, false);
    }

    protected static double parseDecimal(String string, int n, boolean bl) {
        try {
            if (n == 10) {
                int n2 = string.indexOf(101);
                if (n2 != -1) {
                    int n3 = n2;
                    StringBuffer stringBuffer = new StringBuffer();
                    String string2 = string.substring(0, n3);
                    n2 = string2.indexOf(46);
                    if (n2 != -1) {
                        char[] cArray = string2.substring(0, n2).toCharArray();
                        boolean bl2 = Quantity.parsePounds(cArray);
                        stringBuffer.append(cArray);
                        cArray = string2.substring(n2 + 1).toCharArray();
                        if (bl2) {
                            for (int i = 0; i < cArray.length; ++i) {
                                if (cArray[i] == '#') continue;
                                throw new NumberFormatException(Quantity.liMessage(SISCB, "noncontigpounds"));
                            }
                        }
                        Quantity.parsePounds(cArray);
                        stringBuffer.append('.').append(cArray);
                    } else {
                        char[] cArray = string.substring(0, n3).toCharArray();
                        Quantity.parsePounds(cArray);
                        stringBuffer.append(cArray);
                    }
                    stringBuffer.append(string.substring(n3));
                    string = stringBuffer.toString();
                    return Double.parseDouble(string);
                }
                n2 = string.indexOf(115);
                if (n2 != -1 || (n2 = string.indexOf(102)) != -1 || (n2 = string.indexOf(100)) != -1 || (n2 = string.indexOf(108)) != -1) {
                    StringBuffer stringBuffer = new StringBuffer(string.substring(0, n2));
                    stringBuffer.append('e').append(string.substring(n2 + 1));
                    string = stringBuffer.toString();
                    return Quantity.parseDecimal(string, n, bl);
                }
                n2 = string.indexOf(46);
                if (n2 != -1) {
                    StringBuffer stringBuffer = new StringBuffer();
                    char[] cArray = string.substring(0, n2).toCharArray();
                    if (Quantity.parsePounds(cArray)) {
                        stringBuffer.append(cArray);
                        cArray = string.substring(n2 + 1).toCharArray();
                        for (int i = 0; i < cArray.length; ++i) {
                            if (cArray[i] == '#') continue;
                            throw new NumberFormatException(Quantity.liMessage(SISCB, "noncontigpounds"));
                        }
                        Quantity.parsePounds(cArray);
                    } else {
                        stringBuffer.append(cArray);
                        cArray = string.substring(n2 + 1).toCharArray();
                        Quantity.parsePounds(cArray);
                    }
                    stringBuffer.append('.').append(cArray);
                    return Double.parseDouble(stringBuffer.toString());
                }
                if (string.indexOf(35) != -1) {
                    char[] cArray = string.toCharArray();
                    Quantity.parsePounds(cArray);
                    return Double.parseDouble(new String(cArray));
                }
                if (bl) {
                    return Double.parseDouble(string);
                }
                throw new NumberFormatException(Quantity.liMessage(SISCB, "notadecimal"));
            }
            int n4 = string.indexOf(46);
            if (n4 == -1) {
                if (string.indexOf(35) != -1) {
                    char[] cArray = string.toCharArray();
                    Quantity.parsePounds(cArray);
                    return Double.parseDouble(new String(cArray));
                }
                if (bl) {
                    return Double.parseDouble(string);
                }
                throw new NumberFormatException(Quantity.liMessage(SISCB, "notadecimal"));
            }
            BigDecimal bigDecimal = new BigDecimal(new BigInteger(string.substring(0, n4), n));
            String string3 = string.substring(n4 + 1);
            BigInteger bigInteger = new BigInteger(string3, n);
            return bigDecimal.add(new BigDecimal(Double.toString(bigInteger.doubleValue() / Math.pow(n, string3.length())))).doubleValue();
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new NumberFormatException(Quantity.liMessage(SISCB, "notadecimal"));
        }
    }

    protected void simplify() {
        if (this.type == 3) {
            if (this.de.equals(_BI_ZERO)) {
                throw new ArithmeticException(Quantity.liMessage(SISCB, "divisionbyzero"));
            }
            BigInteger bigInteger = this.i.gcd(this.de);
            if (!bigInteger.equals(_BI_ONE)) {
                this.i = this.i.divide(bigInteger);
                this.de = this.de.divide(bigInteger);
            }
            if (this.de.signum() == -1) {
                this.i = this.i.negate();
                this.de = this.de.negate();
            }
            if (this.de.equals(_BI_ONE)) {
                this.type = 2;
            }
        } else if (this.type == 4 && this.im == 0.0) {
            this.type = 1;
        }
        if (this.type == 2 && this.i.compareTo(_INT_MAX) <= 0 && this.i.compareTo(_INT_MIN) >= 0) {
            this.val = this.i.intValue();
            this.type = 0;
        }
    }

    public Quantity and(Quantity quantity) throws NumberFormatException {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        switch (this.type) {
            case 0: {
                if (quantity.type == 0) {
                    return new Quantity(this.val & quantity.val);
                }
                bigInteger2 = BigInteger.valueOf(this.val);
                break;
            }
            case 2: {
                bigInteger2 = this.i;
                break;
            }
            default: {
                throw new NumberFormatException(Quantity.liMessage(SISCB, "logicoprequiresint"));
            }
        }
        switch (quantity.type) {
            case 0: {
                bigInteger = BigInteger.valueOf(quantity.val);
                break;
            }
            case 2: {
                bigInteger = quantity.i;
                break;
            }
            default: {
                throw new NumberFormatException(Quantity.liMessage(SISCB, "logicoprequiresint"));
            }
        }
        return new Quantity(bigInteger2.and(bigInteger));
    }

    public Quantity or(Quantity quantity) throws NumberFormatException {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        switch (this.type) {
            case 0: {
                if (quantity.type == 0) {
                    return new Quantity(this.val | quantity.val);
                }
                bigInteger2 = BigInteger.valueOf(this.val);
                break;
            }
            case 2: {
                bigInteger2 = this.i;
                break;
            }
            default: {
                throw new NumberFormatException(Quantity.liMessage(SISCB, "logicoprequiresint"));
            }
        }
        switch (quantity.type) {
            case 0: {
                bigInteger = BigInteger.valueOf(quantity.val);
                break;
            }
            case 2: {
                bigInteger = quantity.i;
                break;
            }
            default: {
                throw new NumberFormatException(Quantity.liMessage(SISCB, "logicoprequiresint"));
            }
        }
        return new Quantity(bigInteger2.or(bigInteger));
    }

    public Quantity xor(Quantity quantity) throws NumberFormatException {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        switch (this.type) {
            case 0: {
                if (quantity.type == 0) {
                    return new Quantity(this.val ^ quantity.val);
                }
                bigInteger2 = BigInteger.valueOf(this.val);
                break;
            }
            case 2: {
                bigInteger2 = this.i;
                break;
            }
            default: {
                throw new NumberFormatException(Quantity.liMessage(SISCB, "logicoprequiresint"));
            }
        }
        switch (quantity.type) {
            case 0: {
                bigInteger = BigInteger.valueOf(quantity.val);
                break;
            }
            case 2: {
                bigInteger = quantity.i;
                break;
            }
            default: {
                throw new NumberFormatException(Quantity.liMessage(SISCB, "logicoprequiresint"));
            }
        }
        return new Quantity(bigInteger2.xor(bigInteger));
    }

    public Quantity not() throws NumberFormatException {
        switch (this.type) {
            case 0: {
                return new Quantity(~this.val);
            }
            case 2: {
                return new Quantity(this.i.not());
            }
        }
        throw new NumberFormatException(Quantity.liMessage(SISCB, "logicoprequiresint"));
    }

    public Quantity bitCount() throws NumberFormatException {
        switch (this.type) {
            case 0: {
                return Quantity.valueOf(this.integer().bitCount());
            }
            case 2: {
                return Quantity.valueOf(this.i.bitCount());
            }
        }
        throw new NumberFormatException(Quantity.liMessage(SISCB, "logicoprequiresint"));
    }

    public Quantity lsh(int n) throws NumberFormatException {
        switch (this.type) {
            case 0: {
                return new Quantity((long)this.val).lsh(n);
            }
            case 2: {
                return new Quantity(this.i.shiftLeft(n));
            }
        }
        throw new NumberFormatException(Quantity.liMessage(SISCB, "onlyshiftintegers"));
    }

    public Quantity rsh(int n) throws NumberFormatException {
        switch (this.type) {
            case 0: {
                return new Quantity((long)this.val).rsh(n);
            }
            case 2: {
                return new Quantity(this.i.shiftRight(n));
            }
        }
        throw new NumberFormatException(Quantity.liMessage(SISCB, "onlyshiftintegers"));
    }

    public Quantity floor() {
        return this.round(3);
    }

    public Quantity ceiling() {
        return this.round(2);
    }

    public Quantity truncate() {
        return this.round(1);
    }

    public Quantity round() {
        return this.round(6);
    }

    protected static BigInteger d2i(double d) {
        return new BigDecimal(d).toBigInteger();
    }

    public Quantity gcd(Quantity quantity) {
        switch (this.type) {
            case 0: {
                return quantity.gcd(new Quantity((long)this.val));
            }
            case 1: {
                if (Math.floor(this.d) == this.d) {
                    return new Quantity(Quantity.d2i(this.d)).gcd(quantity).toInexact();
                }
            }
            case 2: {
                if (quantity.type == 0) {
                    quantity = new Quantity((long)quantity.val);
                }
                if (quantity.type == 2) {
                    return new Quantity(this.i.gcd(quantity.i));
                }
                if (quantity.type != 1 || Math.floor(this.d) != this.d) break;
                return new Quantity(this.i.gcd(Quantity.d2i(this.d))).toInexact();
            }
        }
        throw new ArithmeticException(Quantity.liMessage(SISCB, "isnotaninteger", this.toString()));
    }

    public Quantity lcm(Quantity quantity) {
        switch (this.type) {
            case 0: {
                return quantity.lcm(new Quantity((long)this.val));
            }
            case 1: {
                if (Math.floor(this.d) == this.d) {
                    return new Quantity(Quantity.d2i(this.d)).lcm(quantity).toInexact();
                }
            }
            case 2: {
                BigInteger bigInteger = null;
                boolean bl = false;
                if (quantity.type == 0) {
                    bigInteger = BigInteger.valueOf(quantity.val);
                }
                if (quantity.type == 2) {
                    bigInteger = quantity.i;
                }
                if (quantity.type == 1 && Math.floor(quantity.d) == quantity.d) {
                    bl = true;
                }
                BigInteger bigInteger2 = bigInteger.abs();
                BigInteger bigInteger3 = _BI_ONE;
                BigInteger bigInteger4 = this.i.abs();
                bigInteger3 = bigInteger4.gcd(bigInteger2);
                bigInteger2 = bigInteger3.compareTo(_BI_ZERO) == 0 ? bigInteger3 : bigInteger4.divide(bigInteger3).multiply(bigInteger2);
                return bl ? new Quantity(bigInteger2).toInexact() : new Quantity(bigInteger2);
            }
        }
        throw new ArithmeticException(Quantity.liMessage(SISCB, "isnotaninteger", this.toString()));
    }

    protected Quantity round(int n) {
        switch (this.type) {
            case 1: {
                switch (n) {
                    case 3: {
                        return new Quantity(Math.floor(this.d));
                    }
                    case 2: {
                        return new Quantity(Math.ceil(this.d));
                    }
                    case 6: {
                        return new Quantity(new BigDecimal(this.d).setScale(0, n).doubleValue());
                    }
                    case 1: {
                        return new Quantity(Quantity.d2i(this.d).doubleValue());
                    }
                }
                return this;
            }
            case 4: {
                throw new ArithmeticException(Quantity.liMessage(SISCB, "isnotareal", this.toString()));
            }
            case 3: {
                return this.toInexact().round(n).toExact();
            }
        }
        return this;
    }

    public Quantity modulo(Quantity quantity) {
        switch (this.type) {
            case 0: {
                if (quantity.type == 0) {
                    return new Quantity(this.val % quantity.val);
                }
                return new Quantity((long)this.val).modulo(quantity);
            }
            case 2: {
                if (quantity.type == 0) {
                    quantity = new Quantity((long)quantity.val);
                }
                if (quantity.type == 2) {
                    return new Quantity(this.i.mod(quantity.i));
                }
                if (quantity.type == 1 && Math.floor(this.d) == this.d) {
                    return new Quantity(this.i.mod(Quantity.d2i(this.d))).toInexact();
                }
            }
            case 1: {
                if (Math.floor(this.d) != this.d) break;
                return new Quantity(Quantity.d2i(this.d)).modulo(quantity).toInexact();
            }
        }
        throw new NumberFormatException(Quantity.liMessage(SISCB, "expectedintegers"));
    }

    public Quantity quotient(Quantity quantity) {
        switch (this.type) {
            case 0: {
                if (quantity.type == 0) {
                    return new Quantity(this.val / quantity.val);
                }
                return new Quantity((long)this.val).quotient(quantity);
            }
            case 2: {
                if (quantity.type == 0) {
                    quantity = new Quantity((long)quantity.val);
                }
                if (quantity.type == 2) {
                    return new Quantity(this.i.divide(quantity.i));
                }
                if (quantity.type != 1 || Math.floor(quantity.d) != quantity.d) break;
                return new Quantity(this.i.divide(Quantity.d2i(quantity.d))).toInexact();
            }
            case 1: {
                if (Math.floor(this.d) != this.d) break;
                return new Quantity(Quantity.d2i(this.d)).quotient(quantity).toInexact();
            }
        }
        throw new NumberFormatException(Quantity.liMessage(SISCB, "expectedintegers"));
    }

    public Quantity remainder(Quantity quantity) {
        switch (this.type) {
            case 0: {
                return new Quantity((long)this.val).remainder(quantity);
            }
            case 2: {
                if (quantity.type == 0) {
                    quantity = new Quantity((long)quantity.val);
                }
                if (quantity.type == 2) {
                    return new Quantity(this.i.remainder(quantity.i));
                }
                if (quantity.type != 1 || Math.floor(quantity.d) != quantity.d) break;
                return new Quantity(this.i.remainder(Quantity.d2i(quantity.d))).toInexact();
            }
            case 1: {
                if (Math.floor(this.d) != this.d) break;
                return new Quantity(Quantity.d2i(this.d)).remainder(quantity).toInexact();
            }
        }
        throw new NumberFormatException(Quantity.liMessage(SISCB, "expectedintegers"));
    }

    public static double sinh(double d) {
        return (Math.exp(d) - Math.exp(-d)) / 2.0;
    }

    public static double cosh(double d) {
        return (Math.exp(d) + Math.exp(-d)) / 2.0;
    }

    public Quantity sin() {
        if (this.type == 4) {
            Quantity quantity = this.mul(I);
            quantity = quantity.exp().sub(quantity.negate().exp());
            return quantity.div(TWO_I);
        }
        return new Quantity(Math.sin(this.doubleValue()));
    }

    public Quantity cos() {
        if (this.type == 4) {
            Quantity quantity = this.mul(I);
            quantity = quantity.exp().add(quantity.negate().exp());
            return quantity.div(TWO);
        }
        return new Quantity(Math.cos(this.doubleValue()));
    }

    public Quantity tan() {
        if (this.type == 4) {
            Quantity quantity = this.mul(I);
            Quantity quantity2 = quantity.exp();
            Quantity quantity3 = quantity.negate().exp();
            return quantity2.sub(quantity3).div(I.mul(quantity2.add(quantity3)));
        }
        return new Quantity(Math.tan(this.doubleValue()));
    }

    public Quantity asin() {
        Quantity quantity = ONE.sub(this.mul(this)).sqrt();
        quantity = this.mul(I).add(quantity).log();
        return I.mul(quantity).negate();
    }

    public Quantity acos() {
        return HALF_PI.sub(this.asin());
    }

    public Quantity atan() {
        Quantity quantity = this.mul(I);
        quantity = ONE.add(quantity).log().sub(ONE.sub(quantity).log());
        return quantity.div(TWO_I);
    }

    public Quantity atan(Quantity quantity) {
        if (this.type == 4) {
            throw new ArithmeticException(Quantity.liMessage(SISCB, "isnotareal", this.toString()));
        }
        if (quantity.type == 4) {
            throw new ArithmeticException(Quantity.liMessage(SISCB, "isnotareal", quantity.toString()));
        }
        return new Quantity(Math.atan2(this.doubleValue(), quantity.doubleValue()));
    }

    public Quantity exp() {
        if (this.type == 4) {
            double d = Math.exp(this.d);
            double d2 = this.im;
            return new Quantity(d * Math.cos(d2), d * Math.sin(d2));
        }
        return new Quantity(Math.exp(this.doubleValue()));
    }

    public Quantity log() {
        if (this.type == 4 || this.type == 1 && this.d < 0.0) {
            double d = this.d * this.d;
            double d2 = this.im * this.im;
            double d3 = Math.atan2(this.im, this.d);
            double d4 = Math.log(Math.sqrt(d + d2));
            return new Quantity(d4, d3);
        }
        return new Quantity(Math.log(this.doubleValue()));
    }

    public Quantity negate() {
        switch (this.type) {
            case 0: {
                return new Quantity(this.val * -1);
            }
            case 2: {
                return new Quantity(this.i.negate());
            }
            case 1: {
                return new Quantity(-this.d);
            }
            case 3: {
                return new Quantity(this.i.negate(), this.de);
            }
            case 4: {
                return new Quantity(-this.d, -this.im);
            }
        }
        return null;
    }

    public static BigDecimal[] sqrtrem(BigDecimal bigDecimal) throws ArithmeticException {
        BigDecimal bigDecimal2 = bigDecimal.setScale(bigDecimal.scale() * 2);
        int n = Quantity.scale(bigDecimal.scale(), 32);
        BigInteger[] bigIntegerArray = Quantity.sqrtrem(bigDecimal2.movePointRight(n).toBigInteger());
        BigDecimal[] bigDecimalArray = new BigDecimal[]{new BigDecimal(bigIntegerArray[0], n / 2), new BigDecimal(bigIntegerArray[1], n)};
        return bigDecimalArray;
    }

    public static BigInteger[] sqrtrem(BigInteger object) throws ArithmeticException {
        Object object2;
        if (((BigInteger)object).signum() == 0) {
            BigInteger[] bigIntegerArray = new BigInteger[]{object, object};
            return bigIntegerArray;
        }
        int n = ((BigInteger)object).bitLength() - 1 >> 1;
        BigInteger bigInteger = _BI_ONE.shiftLeft(n);
        object = ((BigInteger)object).subtract(bigInteger.shiftLeft(n));
        while (n-- > 0) {
            object2 = ((BigInteger)object).subtract(_BI_ONE.shiftLeft(n + n)).subtract(bigInteger.shiftLeft(n + 1));
            if (((BigInteger)object2).signum() < 0) continue;
            bigInteger = bigInteger.add(_BI_ONE.shiftLeft(n));
            object = object2;
        }
        object2 = new BigInteger[]{bigInteger, object};
        return object2;
    }

    public Quantity sqrt() {
        switch (this.type) {
            case 1: {
                if (this.d < 0.0) {
                    return new Quantity(0.0, Math.sqrt(-this.d));
                }
                return new Quantity(Math.sqrt(this.d));
            }
            case 0: 
            case 2: {
                BigInteger bigInteger = this.integer();
                BigInteger bigInteger2 = bigInteger.abs();
                BigInteger[] bigIntegerArray = Quantity.sqrtrem(bigInteger2);
                if (bigIntegerArray[1].equals(_BI_ZERO)) {
                    if (bigInteger.signum() > -1) {
                        return new Quantity(bigIntegerArray[0]);
                    }
                    return new Quantity(0.0, bigIntegerArray[0].doubleValue());
                }
                double d = this.decimal();
                if (d < 0.0) {
                    return new Quantity(0.0, Math.sqrt(-d));
                }
                return new Quantity(Math.sqrt(d));
            }
            case 3: {
                BigDecimal[] bigDecimalArray = Quantity.sqrtrem(new BigDecimal(this.decimal()));
                return new Quantity(bigDecimalArray[0].doubleValue());
            }
            case 4: {
                double d = this.d * this.d;
                double d2 = this.im * this.im;
                double d3 = Math.sqrt(d + d2);
                double d4 = Math.sqrt((d3 - this.d) / 2.0);
                double d5 = this.im / (2.0 * d4);
                if (d5 < 0.0) {
                    return new Quantity(d5, d4).negate();
                }
                return new Quantity(d5, d4);
            }
        }
        return new Quantity(Math.sqrt(this.doubleValue()));
    }

    public Quantity add(Quantity quantity) {
        switch (this.type) {
            case 0: {
                if (quantity.type != 0) {
                    return quantity.add(this);
                }
                return this.intBound((long)quantity.val + (long)this.val);
            }
            case 1: {
                switch (quantity.type) {
                    case 0: {
                        return new Quantity(this.d + (double)quantity.val);
                    }
                    case 1: {
                        return new Quantity(this.d + quantity.d);
                    }
                    case 2: {
                        return new Quantity(this.d + quantity.i.doubleValue());
                    }
                    case 3: {
                        return new Quantity(Quantity.ratioToDecimal(quantity.i, quantity.de) + this.d);
                    }
                    case 4: {
                        return quantity.add(this);
                    }
                }
            }
            case 2: {
                switch (quantity.type) {
                    case 0: {
                        return new Quantity(this.i.add(BigInteger.valueOf(quantity.val)));
                    }
                    case 1: {
                        return new Quantity(this.i.doubleValue() + quantity.d);
                    }
                    case 2: {
                        return new Quantity(this.i.add(quantity.i));
                    }
                    case 3: {
                        BigInteger bigInteger = this.i.multiply(quantity.de);
                        BigInteger bigInteger2 = bigInteger.add(quantity.i);
                        return new Quantity(bigInteger2, quantity.de);
                    }
                    case 4: {
                        return quantity.add(this);
                    }
                }
            }
            case 3: {
                switch (quantity.type) {
                    case 0: {
                        BigInteger bigInteger = this.de.multiply(BigInteger.valueOf(quantity.val));
                        return new Quantity(this.i.add(bigInteger), this.de);
                    }
                    case 1: {
                        return new Quantity(Quantity.ratioToDecimal(this.i, this.de) + quantity.d);
                    }
                    case 2: {
                        BigInteger bigInteger = quantity.i.multiply(this.de);
                        return new Quantity(this.i.add(bigInteger), this.de);
                    }
                    case 3: {
                        BigInteger bigInteger = this.i.multiply(quantity.de);
                        BigInteger bigInteger3 = quantity.i.multiply(this.de);
                        BigInteger bigInteger4 = this.de.multiply(quantity.de);
                        BigInteger bigInteger5 = bigInteger.add(bigInteger3);
                        return new Quantity(bigInteger5, bigInteger4);
                    }
                    case 4: {
                        return quantity.add(this);
                    }
                }
            }
            case 4: {
                switch (quantity.type) {
                    case 0: {
                        return new Quantity(this.d + (double)quantity.val, this.im);
                    }
                    case 1: {
                        return new Quantity(this.d + quantity.d, this.im);
                    }
                    case 2: {
                        return new Quantity(this.d + quantity.i.doubleValue(), this.im);
                    }
                    case 3: {
                        return new Quantity(this.d + Quantity.ratioToDecimal(quantity.i, quantity.de), this.im);
                    }
                    case 4: {
                        return new Quantity(this.d + quantity.d, this.im + quantity.im);
                    }
                }
            }
        }
        return null;
    }

    public Quantity mul(Quantity quantity) {
        switch (this.type) {
            case 0: {
                if (quantity.type != 0) {
                    return quantity.mul(this);
                }
                return this.intBound((long)quantity.val * (long)this.val);
            }
            case 1: {
                switch (quantity.type) {
                    case 0: {
                        return new Quantity(this.d * (double)quantity.val);
                    }
                    case 1: {
                        return new Quantity(this.d * quantity.d);
                    }
                    case 4: {
                        return quantity.mul(this);
                    }
                }
                return new Quantity(this.d * quantity.doubleValue());
            }
            case 2: {
                switch (quantity.type) {
                    case 0: {
                        return new Quantity(this.i.multiply(BigInteger.valueOf(quantity.val)));
                    }
                    case 1: {
                        return new Quantity(this.i.doubleValue() * quantity.d);
                    }
                    case 2: {
                        return new Quantity(this.i.multiply(quantity.i));
                    }
                    case 3: {
                        BigInteger bigInteger = this.i.multiply(quantity.i);
                        return new Quantity(bigInteger, quantity.de);
                    }
                    case 4: {
                        return quantity.mul(this);
                    }
                }
                break;
            }
            case 3: {
                switch (quantity.type) {
                    case 0: {
                        BigInteger bigInteger = this.i.multiply(BigInteger.valueOf(quantity.val));
                        return new Quantity(bigInteger, this.de);
                    }
                    case 1: {
                        return new Quantity(Quantity.ratioToDecimal(this.i, this.de) * quantity.d);
                    }
                    case 2: {
                        BigInteger bigInteger = this.i.multiply(quantity.i);
                        return new Quantity(bigInteger, this.de);
                    }
                    case 3: {
                        BigInteger bigInteger = quantity.i.gcd(this.de);
                        BigInteger bigInteger2 = this.i.gcd(quantity.de);
                        return new Quantity(this.i.divide(bigInteger2).multiply(quantity.i.divide(bigInteger)), this.de.divide(bigInteger).multiply(quantity.de.divide(bigInteger2)));
                    }
                    case 4: {
                        return quantity.mul(this);
                    }
                }
                break;
            }
            case 4: {
                double d = 0.0;
                double d2 = 0.0;
                switch (quantity.type) {
                    case 0: {
                        d = quantity.val;
                        break;
                    }
                    case 4: {
                        d = quantity.d;
                        d2 = quantity.im;
                        break;
                    }
                    case 1: {
                        d = quantity.d;
                        break;
                    }
                    case 2: {
                        d = quantity.i.doubleValue();
                        break;
                    }
                    case 3: {
                        d = Quantity.ratioToDecimal(quantity.i, quantity.de);
                        break;
                    }
                    default: {
                        return NaN;
                    }
                }
                double d3 = this.d * d - this.im * d2;
                double d4 = this.d * d2 + this.im * d;
                return new Quantity(d3, d4);
            }
        }
        return null;
    }

    public Quantity sub(Quantity quantity) {
        switch (this.type) {
            case 0: {
                switch (quantity.type) {
                    case 0: {
                        return this.intBound((long)this.val - (long)quantity.val);
                    }
                    case 1: {
                        return new Quantity((double)this.val - quantity.d);
                    }
                    case 4: {
                        return new Quantity((double)this.val - quantity.d, -quantity.im);
                    }
                }
                return new Quantity((long)this.val).sub(quantity);
            }
            case 1: {
                switch (quantity.type) {
                    case 0: {
                        return new Quantity(this.d - (double)quantity.val);
                    }
                    case 1: {
                        return new Quantity(this.d - quantity.d);
                    }
                    case 2: {
                        return new Quantity(this.d - quantity.i.doubleValue());
                    }
                    case 3: {
                        return new Quantity(this.d - Quantity.ratioToDecimal(quantity.i, quantity.de));
                    }
                    case 4: {
                        return new Quantity(this.d - quantity.d, -quantity.im);
                    }
                }
            }
            case 2: {
                switch (quantity.type) {
                    case 0: {
                        return new Quantity(this.i.subtract(BigInteger.valueOf(quantity.val)));
                    }
                    case 1: {
                        return new Quantity(this.i.doubleValue() - quantity.d);
                    }
                    case 2: {
                        return new Quantity(this.i.subtract(quantity.i));
                    }
                    case 3: {
                        BigInteger bigInteger = this.i.multiply(quantity.de);
                        BigInteger bigInteger2 = bigInteger.subtract(quantity.i);
                        return new Quantity(bigInteger2, quantity.de);
                    }
                    case 4: {
                        return new Quantity(this.i.doubleValue() - quantity.d, -quantity.im);
                    }
                }
            }
            case 3: {
                switch (quantity.type) {
                    case 0: {
                        BigInteger bigInteger = BigInteger.valueOf(quantity.val).multiply(this.de);
                        BigInteger bigInteger3 = this.i.subtract(bigInteger);
                        return new Quantity(bigInteger3, this.de);
                    }
                    case 1: {
                        return new Quantity(Quantity.ratioToDecimal(this.i, this.de) - quantity.d);
                    }
                    case 2: {
                        BigInteger bigInteger = quantity.i.multiply(this.de);
                        BigInteger bigInteger4 = this.i.subtract(bigInteger);
                        return new Quantity(bigInteger4, this.de);
                    }
                    case 3: {
                        BigInteger bigInteger = this.i.multiply(quantity.de);
                        BigInteger bigInteger5 = quantity.i.multiply(this.de);
                        BigInteger bigInteger6 = this.de.multiply(quantity.de);
                        BigInteger bigInteger7 = bigInteger.subtract(bigInteger5);
                        return new Quantity(bigInteger7, bigInteger6);
                    }
                    case 4: {
                        return new Quantity(Quantity.ratioToDecimal(this.i, this.de) - quantity.d, -quantity.im);
                    }
                }
            }
            case 4: {
                switch (quantity.type) {
                    case 0: {
                        return new Quantity(this.d - (double)quantity.val, this.im);
                    }
                    case 1: {
                        return new Quantity(this.d - quantity.d, this.im);
                    }
                    case 2: {
                        return new Quantity(this.d - quantity.i.doubleValue(), this.im);
                    }
                    case 3: {
                        return new Quantity(this.d - Quantity.ratioToDecimal(quantity.i, quantity.de), this.im);
                    }
                    case 4: {
                        return new Quantity(this.d - quantity.d, this.im - quantity.im);
                    }
                }
            }
        }
        return null;
    }

    protected static double div(double d, double d2) {
        return d / d2;
    }

    public Quantity div(Quantity quantity) {
        switch (this.type) {
            case 0: {
                switch (quantity.type) {
                    case 0: {
                        return new Quantity(BigInteger.valueOf(this.val), BigInteger.valueOf(quantity.val));
                    }
                    case 1: {
                        return new Quantity((double)this.val / quantity.d);
                    }
                    case 4: {
                        Quantity quantity2 = new Quantity();
                        quantity2.d = this.val;
                        quantity2.im = 0.0;
                        quantity2.type = 4;
                        return quantity2.div(quantity);
                    }
                }
                return new Quantity((long)this.val).div(quantity);
            }
            case 1: {
                switch (quantity.type) {
                    case 0: {
                        return new Quantity(this.d / (double)quantity.val);
                    }
                    case 1: {
                        return new Quantity(this.d / quantity.d);
                    }
                    case 2: {
                        return new Quantity(this.d / quantity.i.doubleValue());
                    }
                    case 3: {
                        return this.mul(new Quantity(quantity.de, quantity.i));
                    }
                    case 4: {
                        Quantity quantity3 = new Quantity();
                        quantity3.d = this.d;
                        quantity3.im = 0.0;
                        quantity3.type = 4;
                        return quantity3.div(quantity);
                    }
                }
            }
            case 2: {
                switch (quantity.type) {
                    case 0: {
                        return new Quantity(this.i, BigInteger.valueOf(quantity.val));
                    }
                    case 1: {
                        return new Quantity(this.i.doubleValue() / quantity.d);
                    }
                    case 2: {
                        return new Quantity(this.i, quantity.i);
                    }
                    case 3: {
                        BigInteger bigInteger = quantity.de.multiply(this.i);
                        return new Quantity(bigInteger, quantity.i);
                    }
                    case 4: {
                        Quantity quantity4 = new Quantity();
                        quantity4.d = this.i.doubleValue();
                        quantity4.im = 0.0;
                        quantity4.type = 4;
                        return quantity4.div(quantity);
                    }
                    case 5: 
                    case 6: {
                        return ZERO;
                    }
                    case 7: {
                        return NaN;
                    }
                }
            }
            case 3: {
                switch (quantity.type) {
                    case 0: {
                        return new Quantity(this.i, this.de.multiply(BigInteger.valueOf(quantity.val)));
                    }
                    case 1: {
                        double d = Quantity.ratioToDecimal(this.i, this.de);
                        return new Quantity(Quantity.div(d, quantity.d));
                    }
                    case 2: {
                        BigInteger bigInteger = this.de.multiply(quantity.i);
                        return new Quantity(this.i, bigInteger);
                    }
                    case 3: {
                        BigInteger bigInteger = this.i.multiply(quantity.de);
                        BigInteger bigInteger2 = quantity.i.multiply(this.de);
                        return new Quantity(bigInteger, bigInteger2);
                    }
                    case 4: {
                        double d = Quantity.ratioToDecimal(this.i, this.de);
                        return new Quantity(Quantity.div(d, quantity.d), quantity.im);
                    }
                    case 5: 
                    case 6: {
                        return ZERO;
                    }
                    case 7: {
                        return NaN;
                    }
                }
            }
            case 4: {
                double d = 0.0;
                double d2 = 0.0;
                switch (quantity.type) {
                    case 0: {
                        double d3 = quantity.val;
                        return new Quantity(Quantity.div(this.d, d3), Quantity.div(this.im, d3));
                    }
                    case 1: {
                        return new Quantity(Quantity.div(this.d, quantity.d), Quantity.div(this.im, quantity.d));
                    }
                    case 2: {
                        double d4 = quantity.i.doubleValue();
                        return new Quantity(Quantity.div(this.d, d4), Quantity.div(this.im, d4));
                    }
                    case 3: {
                        double d5 = Quantity.ratioToDecimal(quantity.i, quantity.de);
                        return new Quantity(Quantity.div(this.d, d5), Quantity.div(this.im, d5));
                    }
                    case 4: {
                        d = quantity.d;
                        d2 = quantity.im;
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        return NaN;
                    }
                }
                double d6 = d * d;
                double d7 = d2 * d2;
                Quantity quantity5 = new Quantity(d6 + d7);
                double d8 = this.im * d2;
                double d9 = this.d * d;
                double d10 = this.im * d;
                double d11 = this.d * d2;
                Quantity quantity6 = new Quantity(d9 + d8);
                Quantity quantity7 = new Quantity(d10 - d11);
                return quantity6.add(I.mul(quantity7)).div(quantity5);
            }
            case 5: {
                switch (quantity.type) {
                    case 5: 
                    case 6: 
                    case 7: {
                        return NaN;
                    }
                }
                return POSITIVE_INFINITY;
            }
            case 6: {
                switch (quantity.type) {
                    case 5: 
                    case 6: 
                    case 7: {
                        return NaN;
                    }
                }
                return NEGATIVE_INFINITY;
            }
        }
        return NaN;
    }

    public boolean comp(Quantity quantity, int n) {
        switch (this.type) {
            case 0: {
                if (quantity.type != 0) {
                    return new Quantity((long)this.val).comp(quantity, n);
                }
                return n == (this.val > quantity.val ? 1 : (this.val < quantity.val ? -1 : 0));
            }
            case 1: {
                switch (quantity.type) {
                    case 0: {
                        return Quantity.sign(this.d - (double)quantity.val) == n;
                    }
                    case 1: {
                        return Quantity.sign(this.d - quantity.d) == n;
                    }
                    case 2: {
                        return Quantity.sign(this.d - quantity.i.doubleValue()) == n;
                    }
                    case 3: {
                        return Quantity.sign(this.d - Quantity.ratioToDecimal(quantity.i, quantity.de)) == n;
                    }
                    case 4: {
                        if (n == 0) {
                            return quantity.im == 0.0 && this.d == quantity.d;
                        }
                    }
                    case 5: {
                        return n == -1;
                    }
                    case 6: {
                        return n == 1;
                    }
                }
            }
            case 2: {
                switch (quantity.type) {
                    case 0: {
                        return this.i.compareTo(BigInteger.valueOf(quantity.val)) == n;
                    }
                    case 1: {
                        return Quantity.sign(this.i.doubleValue() - quantity.d) == n;
                    }
                    case 2: {
                        return this.i.compareTo(quantity.i) == n;
                    }
                    case 3: {
                        BigInteger bigInteger = this.i.multiply(quantity.de);
                        return bigInteger.compareTo(quantity.i) == n;
                    }
                    case 4: {
                        if (n == 0) {
                            return quantity.im == 0.0 && this.comp(new Quantity(quantity.d), 0);
                        }
                    }
                    case 5: {
                        return n == -1;
                    }
                    case 6: {
                        return n == 1;
                    }
                }
                break;
            }
            case 3: {
                switch (quantity.type) {
                    case 0: {
                        BigInteger bigInteger = BigInteger.valueOf(quantity.val).multiply(this.de);
                        return this.i.compareTo(bigInteger) == n;
                    }
                    case 1: {
                        return Quantity.sign(Quantity.ratioToDecimal(this.i, this.de) - quantity.d) == n;
                    }
                    case 2: {
                        BigInteger bigInteger = quantity.i.multiply(this.de);
                        return this.i.compareTo(bigInteger) == n;
                    }
                    case 3: {
                        BigInteger bigInteger = this.i.multiply(quantity.de);
                        BigInteger bigInteger2 = quantity.i.multiply(this.de);
                        return bigInteger.compareTo(bigInteger2) == n;
                    }
                    case 4: {
                        if (n == 0) {
                            return quantity.im == 0.0 && this.comp(new Quantity(quantity.d), 0);
                        }
                    }
                    case 5: {
                        return n == -1;
                    }
                    case 6: {
                        return n == 1;
                    }
                }
                break;
            }
            case 4: {
                if (quantity.type == 4) {
                    int n2 = 0;
                    n2 = Quantity.sign(this.d - quantity.d);
                    if (n2 == 0) {
                        return Quantity.sign(this.im - quantity.im) == n;
                    }
                    return n2 == n;
                }
                return quantity.comp(this, n);
            }
        }
        throw new NumberFormatException(Quantity.liMessage(SISCB, "nocomplexcomparison"));
    }

    public double doubleValue() {
        switch (this.type) {
            case 0: {
                return this.val;
            }
            case 1: {
                return this.d;
            }
            case 2: {
                return this.i.doubleValue();
            }
            case 3: {
                return Quantity.ratioToDecimal(this.i, this.de);
            }
        }
        return 0.0;
    }

    public double decimal() {
        switch (this.type) {
            case 0: {
                return this.val;
            }
            case 2: {
                return this.i.doubleValue();
            }
            case 1: {
                return this.d;
            }
            case 3: {
                return Quantity.ratioToDecimal(this.i, this.de);
            }
        }
        throw new NumberFormatException(Quantity.liMessage(SISCB, "isnotareal", this.toString()));
    }

    public long longValue() {
        switch (this.type) {
            case 0: {
                return this.val;
            }
            case 1: {
                return (long)this.d;
            }
            case 2: {
                return this.i.longValue();
            }
            case 3: {
                return this.i.divide(this.de).longValue();
            }
        }
        return 0L;
    }

    public int indexValue() {
        if (this.type == 0) {
            return this.val;
        }
        throw new RuntimeException(Quantity.liMessage(SISCB, "nonintegerindex"));
    }

    public int intValue() {
        switch (this.type) {
            case 0: {
                return this.val;
            }
            case 1: {
                return (int)this.d;
            }
            case 2: {
                return this.i.intValue();
            }
            case 3: {
                return this.i.divide(this.de).intValue();
            }
        }
        return 0;
    }

    public BigInteger integer() {
        switch (this.type) {
            case 0: {
                return BigInteger.valueOf(this.val);
            }
            case 2: {
                return this.i;
            }
        }
        throw new NumberFormatException(Quantity.liMessage(SISCB, "notaninteger"));
    }

    public Quantity toExact() {
        switch (this.type) {
            case 1: {
                BigInteger bigInteger = Quantity.d2i(this.d);
                BigDecimal bigDecimal = new BigDecimal(Double.toString(this.d - bigInteger.doubleValue()));
                int n = bigDecimal.scale();
                bigDecimal = bigDecimal.movePointRight(n);
                BigInteger bigInteger2 = _BI_TEN.pow(n);
                BigInteger bigInteger3 = bigInteger.multiply(bigInteger2).add(bigDecimal.toBigInteger());
                return new Quantity(bigInteger3, bigInteger2);
            }
            case 4: {
                return new Quantity(Math.round(this.d), Math.round(this.im));
            }
        }
        return this;
    }

    public Quantity toInexact() {
        switch (this.type) {
            case 0: {
                return new Quantity((double)this.val);
            }
            case 2: {
                return new Quantity(this.i.doubleValue());
            }
            case 3: {
                return new Quantity(Quantity.ratioToDecimal(this.i, this.de));
            }
        }
        return this;
    }

    public Quantity realpart() {
        if (this.type == 4) {
            return new Quantity(this.d);
        }
        return this;
    }

    public Quantity imagpart() {
        switch (this.type) {
            case 1: {
                return IZERO;
            }
            case 4: {
                return new Quantity(this.im);
            }
        }
        return ZERO;
    }

    public Quantity numerator() throws NumberFormatException {
        switch (this.type) {
            case 4: {
                throw new NumberFormatException(Quantity.liMessage(SISCB, "isnotrational", this.toString()));
            }
            case 1: {
                return this.toExact().numerator().toInexact();
            }
            case 3: {
                return new Quantity(this.i);
            }
        }
        return this;
    }

    public Quantity denominator() throws NumberFormatException {
        switch (this.type) {
            case 4: {
                throw new NumberFormatException(Quantity.liMessage(SISCB, "isnotrational", this.toString()));
            }
            case 1: {
                return this.toExact().denominator().toInexact();
            }
            case 3: {
                return new Quantity(this.de);
            }
        }
        return ONE;
    }

    protected static double ratioToDecimal(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.doubleValue() / bigInteger2.doubleValue();
    }

    protected static int scale(int n, int n2) {
        return Math.min(Math.max(minFloatPrecision, Math.max(n, n2)), maxFloatPrecision);
    }

    protected final Quantity intBound(long l) {
        int n = (int)l;
        return (long)n == l ? new Quantity(n) : new Quantity(l);
    }

    public boolean is(int n) {
        return (characteristics[this.type] & n) != 0;
    }

    public boolean greater(Quantity quantity) {
        return this.comp(quantity, 1);
    }

    public boolean less(Quantity quantity) {
        return this.comp(quantity, -1);
    }

    public boolean eqv(Object object) {
        if (!(object instanceof Quantity)) {
            return false;
        }
        Quantity quantity = (Quantity)object;
        return (this.is(2) && quantity.is(2) || this.is(4) && quantity.is(4)) && this.comp(quantity, 0);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Quantity)) {
            return false;
        }
        Quantity quantity = (Quantity)object;
        return quantity.type == this.type && this.comp(quantity, 0);
    }

    public boolean valueEqual(Value value) {
        if (this == value) {
            return true;
        }
        if (value instanceof Quantity) {
            Quantity quantity = (Quantity)value;
            return this.type == quantity.type && this.comp(quantity, 0);
        }
        return false;
    }

    public int hashCode() {
        int n = this.type;
        switch (this.type) {
            case 0: {
                return n ^ this.val;
            }
            case 1: {
                long l = Double.doubleToLongBits(this.d);
                return n ^ (int)(l & 0xFFFFFFFFFFFFFFFFL) ^ (int)(l >>> 32 & 0xFFFFFFFFFFFFFFFFL);
            }
            case 2: {
                return n ^ this.i.hashCode();
            }
            case 3: {
                return n ^ this.i.hashCode() ^ this.de.hashCode();
            }
            case 4: {
                long l = Double.doubleToLongBits(this.d);
                long l2 = Double.doubleToLongBits(this.im);
                return n ^ (int)(l & 0xFFFFFFFFFFFFFFFFL) ^ (int)(l >>> 32 & 0xFFFFFFFFFFFFFFFFL) ^ (int)(l2 & 0xFFFFFFFFFFFFFFFFL) ^ (int)(l2 >>> 32 & 0xFFFFFFFFFFFFFFFFL);
            }
        }
        return n;
    }

    public void display(ValueWriter valueWriter) throws IOException {
        valueWriter.append(this.toString());
    }

    public String toString() {
        return this.toString(10);
    }

    protected static String zeroTrim(String string) {
        int n = string.indexOf(46);
        if (n != -1 && string.indexOf(101) == -1) {
            for (int i = string.length() - 1; i > 1; --i) {
                char c = string.charAt(i);
                if (c == '0') continue;
                return c == '.' ? string.substring(0, i + 2) : string.substring(0, i + 1);
            }
            return string.length() > 2 ? string.substring(0, 3) : string;
        }
        return string;
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.type == 0) {
            stringBuffer.append(Integer.toString(this.val, n));
        } else if (this.type == 1) {
            String string = Quantity.zeroTrim(Double.toString(this.d).toLowerCase());
            stringBuffer.append(string);
            if (string.indexOf(46) == -1) {
                stringBuffer.append(".0");
            }
        } else if (this.type == 2) {
            stringBuffer.append(this.i.toString(n));
        } else if (this.type == 3) {
            stringBuffer.append(this.i.toString(n)).append('/').append(this.de.toString(n));
        } else if (this.type == 4) {
            stringBuffer.append(Quantity.zeroTrim(Double.toString(this.d).toLowerCase()));
            if (this.im > 0.0) {
                stringBuffer.append('+');
                if (this.im != 1.0) {
                    stringBuffer.append(Double.toString(this.im).toLowerCase());
                }
            } else if (this.im == -1.0) {
                stringBuffer.append('-');
            } else {
                stringBuffer.append(Quantity.zeroTrim(Double.toString(this.im).toLowerCase()));
            }
            stringBuffer.append('i');
        }
        return stringBuffer.toString();
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        this.type = deserializer.readInt();
        switch (this.type) {
            case 0: {
                this.val = deserializer.readInt();
                break;
            }
            case 2: {
                this.i = deserializer.readBigInteger();
                break;
            }
            case 1: {
                this.d = deserializer.readBigDecimal().doubleValue();
                break;
            }
            case 3: {
                this.i = deserializer.readBigInteger();
                this.de = deserializer.readBigInteger();
                break;
            }
            case 4: {
                this.d = deserializer.readBigDecimal().doubleValue();
                this.im = deserializer.readBigDecimal().doubleValue();
            }
        }
        this.simplify();
    }

    public void serialize(Serializer serializer) throws IOException {
        serializer.writeInt(this.type);
        switch (this.type) {
            case 0: {
                serializer.writeInt(this.val);
                break;
            }
            case 2: {
                serializer.writeBigInteger(this.i);
                break;
            }
            case 1: {
                serializer.writeBigDecimal(new BigDecimal(this.d));
                break;
            }
            case 3: {
                serializer.writeBigInteger(this.i);
                serializer.writeBigInteger(this.de);
                break;
            }
            case 4: {
                serializer.writeBigDecimal(new BigDecimal(this.d));
                serializer.writeBigDecimal(new BigDecimal(this.im));
            }
        }
    }

    public Value singletonValue() {
        return this;
    }
}

