/*
 * Decompiled with CFR 0.152.
 */
package sisc.data;

import java.io.IOException;
import sisc.data.Value;
import sisc.io.ValueWriter;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;
import sisc.util.ExpressionVisitor;

public class Pair
extends Value {
    private Value car;
    private Value cdr;

    public Pair() {
        this.car = this.cdr = EMPTYLIST;
    }

    public Pair(Value value, Value value2) {
        this.car = value;
        this.cdr = value2;
    }

    public Value car() {
        return this.car;
    }

    public Value cdr() {
        return this.cdr;
    }

    public void setCar(Value value) {
        this.car = value;
    }

    public void setCdr(Value value) {
        this.cdr = value;
    }

    private static boolean quasiquote(ValueWriter valueWriter, String string, Value value, Value value2) throws IOException {
        if (value2 instanceof Pair && ((Pair)value2).cdr() == EMPTYLIST) {
            String string2 = null;
            if (value == QUOTE) {
                string2 = "'";
            } else if (value == UNQUOTE) {
                string2 = ",";
            } else if (value == BACKQUOTE) {
                string2 = "`";
            } else if (value == UNQUOTE_SPLICING) {
                string2 = ",@";
            } else {
                return false;
            }
            valueWriter.append(string).append(string2).append(((Pair)value2).car());
            return true;
        }
        return false;
    }

    public void display(ValueWriter valueWriter) throws IOException {
        Value value = this.car;
        Value value2 = this.cdr;
        if (Pair.quasiquote(valueWriter, "", value, value2)) {
            return;
        }
        valueWriter.append('(').append(value);
        while (value2 != EMPTYLIST) {
            if (value2 instanceof Pair && valueWriter.isInlinable(value2)) {
                Pair pair = (Pair)value2;
                value = pair.car();
                if (Pair.quasiquote(valueWriter, " . ", value, value2 = pair.cdr())) break;
                valueWriter.append(' ').append(value);
                continue;
            }
            valueWriter.append(" . ");
            valueWriter.append(value2);
            break;
        }
        valueWriter.append(')');
    }

    public boolean valueEqual(Value value) {
        if (value == this) {
            return true;
        }
        if (!(value instanceof Pair)) {
            return false;
        }
        Pair pair = (Pair)value;
        return this.car.valueEqual(pair.car()) && this.cdr.valueEqual(pair.cdr());
    }

    public int valueHashCode() {
        return this.car.valueHashCode() ^ this.cdr.valueHashCode();
    }

    public void serialize(Serializer serializer) throws IOException {
        serializer.writeExpression(this.car);
        serializer.writeExpression(this.cdr);
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        this.car = (Value)deserializer.readExpression();
        this.cdr = (Value)deserializer.readExpression();
    }

    public boolean visit(ExpressionVisitor expressionVisitor) {
        return expressionVisitor.visit(this.car) && expressionVisitor.visit(this.cdr);
    }
}

