/*
 * Decompiled with CFR 0.152.
 */
package sisc.data;

import java.io.IOException;
import sisc.data.Box;
import sisc.data.Expression;
import sisc.data.NamedValue;
import sisc.data.Pair;
import sisc.data.Procedure;
import sisc.data.Quantity;
import sisc.data.Value;
import sisc.env.LexicalUtils;
import sisc.interpreter.CallFrame;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.io.ValueWriter;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;
import sisc.util.ExpressionVisitor;

public class Closure
extends Procedure
implements NamedValue {
    public boolean arity;
    public int fcount;
    public int[] boxes;
    private transient int bl;
    public Value[] env;
    public Expression body;

    public Closure(boolean bl, int n, Expression expression, Value[] valueArray, int[] nArray) {
        this.arity = bl;
        this.fcount = n;
        this.env = valueArray;
        this.body = expression;
        this.boxes = nArray;
        this.bl = nArray == null ? -1 : nArray.length - 1;
    }

    private final Value[] matchArgs(Interpreter interpreter) throws ContinuationException {
        Value[] valueArray;
        if (!this.arity) {
            valueArray = this.bl < 0 ? interpreter.vlr : interpreter.vlrToArgs();
            if (valueArray.length != this.fcount) {
                Closure.error(interpreter, Closure.liMessage(SISCB, "notenoughargsto", this.toString(), this.fcount, interpreter.vlr.length));
                return null;
            }
        } else {
            if (interpreter.vlr.length < this.fcount - 1) {
                Closure.error(interpreter, Closure.liMessage(SISCB, "notenoughargstoinf", this.toString(), this.fcount - 1, interpreter.vlr.length));
                return null;
            }
            valueArray = interpreter.vlrToRestArgs(this.fcount);
        }
        for (int i = this.bl; i >= 0; --i) {
            int n = this.boxes[i];
            valueArray[n] = new Box(valueArray[n]);
        }
        return valueArray;
    }

    public void apply(Interpreter interpreter) throws ContinuationException {
        interpreter.lcl = this.matchArgs(interpreter);
        interpreter.vlr = null;
        interpreter.env = this.env;
        interpreter.nxp = this.body;
    }

    public void display(ValueWriter valueWriter) throws IOException {
        this.displayNamedOpaque(valueWriter, "procedure");
    }

    public void serialize(Serializer serializer) throws IOException {
        long l = (long)this.fcount << 1;
        if (this.arity) {
            l |= 1L;
        }
        serializer.writeLong(l);
        LexicalUtils.writeIntArray(serializer, this.boxes);
        serializer.writeExpressionArray(this.env);
        serializer.writeExpression(this.body);
    }

    public Value express() {
        Pair pair = LexicalUtils.intArrayToList(this.boxes);
        return Closure.list(Closure.sym("closure"), new Pair(Closure.truth(this.arity), new Pair(Quantity.valueOf(this.fcount), pair)), Closure.valArrayToVec(this.env), this.body.express());
    }

    public Closure() {
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        long l = deserializer.readLong();
        this.fcount = (int)(l >> 1);
        this.arity = (l & 1L) != 0L;
        this.boxes = LexicalUtils.readIntArray(deserializer);
        this.bl = this.boxes == null ? -1 : this.boxes.length - 1;
        this.env = deserializer.readValueArray();
        this.body = deserializer.readExpression();
    }

    public boolean visit(ExpressionVisitor expressionVisitor) {
        return super.visit(expressionVisitor) && CallFrame.visitValueArray(expressionVisitor, this.env) && expressionVisitor.visit(this.body);
    }
}

