/*
 * Decompiled with CFR 0.152.
 */
package sisc.compiler;

import java.io.IOException;
import sisc.compiler.CompilerConstants;
import sisc.data.NamedValue;
import sisc.data.Singleton;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.io.ValueWriter;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;
import sisc.util.Util;

public class Syntax
extends Value
implements NamedValue,
Singleton {
    int synid;

    public Syntax(int n) {
        this.synid = n;
    }

    public void eval(Interpreter interpreter) throws ContinuationException {
        Syntax.error(interpreter, Util.liMessage(SISCB, "invalidsyncontext", this.getName().toString()));
    }

    public void display(ValueWriter valueWriter) throws IOException {
        valueWriter.append("#%").append(this.getName());
    }

    public Syntax() {
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        this.synid = deserializer.readInt();
        this.setName(Symbol.get(deserializer.readUTF()));
    }

    public void serialize(Serializer serializer) throws IOException {
        serializer.writeInt(this.synid);
        serializer.writeUTF(this.getName().symval);
    }

    public Value singletonValue() {
        return (Value)CompilerConstants.SYNTACTIC_TOKENS.get(this.getName().symval);
    }
}

