/*
 * Decompiled with CFR 0.152.
 */
package sisc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import sisc.data.Procedure;
import sisc.data.Quantity;
import sisc.data.SchemeString;
import sisc.data.SchemeThread;
import sisc.data.SchemeVoid;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.env.DynamicEnvironment;
import sisc.interpreter.AppContext;
import sisc.interpreter.Context;
import sisc.interpreter.Interpreter;
import sisc.interpreter.SchemeException;
import sisc.util.Util;

public class REPL {
    public SchemeThread primordialThread;
    static final int SWITCH = 0;
    static final int OPTION = 1;
    static final String[][] opts = new String[][]{{"?", "help"}, {"l", "listen"}, {"h", "heap"}, {"p", "properties"}, {"e", "eval"}, {"c", "call-with-args"}, {"x", "no-repl"}, {"v", "version"}};
    static final int[] optTypes = new int[]{0, 1, 1, 1, 1, 1, 0, 0};

    public REPL(DynamicEnvironment dynamicEnvironment, Procedure procedure) {
        this(new SchemeThread(dynamicEnvironment, procedure));
    }

    public REPL(SchemeThread schemeThread) {
        this.primordialThread = schemeThread;
        schemeThread.thread.setDaemon(true);
    }

    public void go() {
        if (this.primordialThread.thunk == null) {
            System.err.println(Util.liMessage(Util.SISCB, "heapnotfound"));
            return;
        }
        this.primordialThread.start();
    }

    public static Procedure getCliProc(AppContext appContext) {
        return (Procedure)appContext.toplevel_env.lookup(Symbol.get("sisc-cli"));
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Value[] valueArray;
        Object object2;
        Util util;
        Object object3;
        Object object4;
        Object object5;
        Map map = REPL.parseOpts(stringArray);
        if (map.get("help") != null) {
            REPL.printUsage();
            System.exit(0);
        } else if (map.get("version") != null) {
            System.out.println("SISC - The Second Interpreter of Scheme Code - 1.16.6");
            System.exit(0);
        }
        Properties properties = new Properties();
        String string = (String)map.get("properties");
        if (string != null) {
            try {
                object5 = Util.url(string);
                object4 = ((URL)object5).openConnection();
                ((URLConnection)object4).setDoInput(true);
                ((URLConnection)object4).setDoOutput(false);
                properties.load(((URLConnection)object4).getInputStream());
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("WARNING: " + malformedURLException.getMessage());
            }
            catch (IOException iOException) {
                System.err.println("WARNING: " + iOException.getMessage());
            }
        }
        object5 = new AppContext(properties);
        Context.setDefaultAppContext((AppContext)object5);
        object4 = AppContext.findHeap(Util.makeURL((String)map.get("heap")));
        if (object4 == null) {
            System.err.println(Util.liMessage(Util.SISCB, "heapnotfound"));
            return;
        }
        if (!((AppContext)object5).addHeap(AppContext.openHeap((URL)object4))) {
            return;
        }
        Interpreter interpreter = Context.enter((AppContext)object5);
        boolean bl = interpreter.loadSourceFiles(((Vector)map.get("files")).toArray(new String[0]));
        boolean bl2 = map.get("no-repl") != null;
        boolean bl3 = map.get("call-with-args") != null;
        int n = 0;
        String string2 = (String)map.get("eval");
        if (string2 != null) {
            object3 = Util.VOID;
            try {
                object3 = interpreter.eval(string2);
                if (!bl3) {
                    System.out.println(object3);
                }
            }
            catch (SchemeException schemeException) {
                schemeException.printStackTrace();
                n = 1;
            }
        }
        if ((object3 = (String)map.get("call-with-args")) != null) {
            util = null;
            try {
                util = Util.proc(interpreter.eval((String)object3));
            }
            catch (SchemeException schemeException) {
                schemeException.printStackTrace();
                n = 1;
            }
            if (util != null) {
                object2 = (Vector)map.get("argv");
                valueArray = new Value[object2 == null ? 0 : ((Vector)object2).size()];
                for (int i = 0; i < valueArray.length; ++i) {
                    valueArray[i] = new SchemeString((String)((Vector)object2).elementAt(i));
                }
                object = Util.VOID;
                try {
                    object = interpreter.eval((Procedure)util, valueArray);
                    if (bl2) {
                        if (object instanceof Quantity) {
                            n = ((Quantity)object).indexValue();
                        } else if (!(object instanceof SchemeVoid)) {
                            System.out.println(object);
                        }
                    }
                }
                catch (SchemeException schemeException) {
                    schemeException.printStackTrace();
                    n = 1;
                }
            }
        }
        util = interpreter.dynenv;
        Context.exit();
        if (!bl2) {
            object2 = (String)map.get("listen");
            if (object2 != null) {
                int n2 = ((String)object2).indexOf(58);
                object = n2 == -1 ? new ServerSocket(Integer.parseInt((String)object2), 50) : new ServerSocket(Integer.parseInt(((String)object2).substring(n2 + 1)), 50, InetAddress.getByName(((String)object2).substring(0, n2)));
                System.out.println("Listening on " + ((ServerSocket)object).getInetAddress().toString() + ":" + ((ServerSocket)object).getLocalPort());
                System.out.flush();
                REPL.listen((AppContext)object5, (ServerSocket)object);
            } else {
                valueArray = new REPL((DynamicEnvironment)util, REPL.getCliProc((AppContext)object5));
                valueArray.go();
                valueArray.primordialThread.thread.join();
                switch (valueArray.primordialThread.state) {
                    case 2: {
                        if (!(valueArray.primordialThread.rv instanceof Quantity)) break;
                        n = ((Quantity)valueArray.primordialThread.rv).intValue();
                        break;
                    }
                    case 3: {
                        n = 1;
                    }
                }
            }
        } else if (n == 0 && !bl) {
            n = 1;
        }
        System.exit(n);
    }

    public static void listen(AppContext appContext, ServerSocket serverSocket) throws IOException {
        while (true) {
            Socket socket = serverSocket.accept();
            DynamicEnvironment dynamicEnvironment = new DynamicEnvironment(appContext, socket.getInputStream(), socket.getOutputStream());
            SchemeSocketThread schemeSocketThread = new SchemeSocketThread(dynamicEnvironment, REPL.getCliProc(appContext), socket);
            REPL rEPL = new REPL(schemeSocketThread);
            rEPL.go();
        }
    }

    public static void printUsage() {
        System.out.println("SISC - Second Interpreter of Scheme Code\n");
        System.out.println("usage: sisc [-?xv] [-l port] [-h heapfile] [-p property-file]");
        System.out.println("            [-e s-expression] [-c function] [source-file ...] [-- arguments ...]");
    }

    public static Map parseOpts(String[] stringArray) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Vector<String> vector = new Vector<String>();
        block4: for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.startsWith("-")) {
                int n = string.startsWith("--") ? 1 : 0;
                if ("".equals(string = string.substring(n + 1))) {
                    Vector<String> vector2 = new Vector<String>();
                    if (n == 0) {
                        vector2.addElement("-");
                    } else {
                        while (++i < stringArray.length) {
                            vector2.addElement(stringArray[i]);
                        }
                    }
                    hashMap.put("argv", vector2);
                    break;
                }
                for (int j = 0; j < opts.length; ++j) {
                    if (!opts[j][n].equals(string)) continue;
                    switch (optTypes[j]) {
                        case 1: {
                            hashMap.put(opts[j][1], stringArray[++i]);
                            break;
                        }
                        case 0: {
                            hashMap.put(opts[j][1], Boolean.TRUE);
                        }
                    }
                    continue block4;
                }
                continue;
            }
            vector.addElement(stringArray[i]);
        }
        hashMap.put("files", vector);
        return hashMap;
    }

    public static class SchemeSocketThread
    extends SchemeThread {
        public Socket s;

        public SchemeSocketThread(DynamicEnvironment dynamicEnvironment, Procedure procedure, Socket socket) {
            super(dynamicEnvironment, procedure);
            this.s = socket;
        }

        public void run() {
            super.run();
            try {
                this.s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

